/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.jms.impl;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.jms.JmsHandler;
import com.artfess.application.jms.impl.AppPushHandler;
import com.artfess.application.model.AppPushContent;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.model.SysExecutor;
import com.artfess.application.persistence.manager.MessageLogManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.application.persistence.manager.SysMessageManager;
import com.artfess.application.service.impl.TemplateServiceImpl;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.vo.ClientInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InnerHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(InnerHandler.class);
    @Resource
    SysMessageManager sysMessageManager;
    @Resource
    MessageLogManager messageLogManager;
    @Resource
    AppPushHandler appPushHandler;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    TemplateServiceImpl templateServiceImpl;

    @Override
    public String getType() {
        return NoticeMessageType.INNER.key();
    }

    @Override
    public boolean send(JmsMessage jmsMessage) {
        try {
            List receivers = jmsMessage.getReceivers();
            ArrayList<SysExecutor> list = new ArrayList<SysExecutor>();
            for (JmsActor actor : receivers) {
                SysExecutor executor = new SysExecutor(actor.getId(), actor.getName(), SysExecutor.TYPE_USER);
                list.add(executor);
            }
            if (BeanUtils.isEmpty(list)) {
                return false;
            }
            String senderId = null;
            String senderName = null;
            JmsActor sender = jmsMessage.getSender();
            if (BeanUtils.isNotEmpty((Object)sender)) {
                senderId = sender.getId();
                senderName = sender.getName();
            }
            this.sysMessageManager.sendMsg(jmsMessage.getSubject(), jmsMessage.getContent(), jmsMessage.getType(), jmsMessage.getTypeKey(), senderId, senderName, list);
            MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
            if (BeanUtils.isNotEmpty((Object)((Object)msgTemplate))) {
                jmsMessage.getExtendVars().put("templateType", msgTemplate.getTypeKey());
            }
            String content = this.templateServiceImpl.parsePlainContent(msgTemplate, jmsMessage.getExtendVars());
            Map vars = jmsMessage.getExtendVars();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("taskId", vars.getOrDefault("taskId", ""));
            params.put("instId", vars.getOrDefault("instId", ""));
            params.put("templateType", vars.getOrDefault("templateType", ""));
            params.put("templateAlias", jmsMessage.getTemplateAlias());
            for (JmsActor actor : receivers) {
                if (!BeanUtils.isNotEmpty((Object)actor.getClientId())) continue;
                this.appPushHandler.pushIndexMsgToSingle(new ClientInfo(actor.getClientId(), actor.getClientToken()), new AppPushContent(jmsMessage.getSubject(), content, params));
            }
            this.messageLogManager.handLogByMsgHander(jmsMessage, true, "");
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, ex.getMessage());
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "\u5185\u90e8\u6d88\u606f";
    }

    @Override
    public boolean getIsDefault() {
        return true;
    }

    @Override
    public boolean getSupportHtml() {
        return false;
    }
}

