package com.artfess.zsj.home.vo;

import com.artfess.base.entity.BizDelModel;
import com.artfess.zsj.home.model.SystemWorkOrder;
import com.artfess.zsj.home.model.SystemWorkOrderHandleLog;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 系统工单处理记录更新VO
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2025-03-12
 */
@ApiModel(value="BizSystemWorkOrderHandleVO对象", description="系统工单处理记录VO")
@Data
public class SystemWorkOrderHandleVo extends SystemWorkOrderHandleLog {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "工单编号（系统自动生成）")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "工单标题")
    @TableField("TITLE_")
    private String title;

    @ApiModelProperty(value = "所属模块（使用字典：1：智慧收费，2：智慧运行，3：智慧养护，4：智慧服务）")
    @TableField("MODULE_")
    private String module;

    @ApiModelProperty(value = "工单类型（使用字典，1：系统问题，2：使用帮助，3：业务需求，4：其他）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "紧急程度（使用字典，1：一般，2：较为紧急，3：非常紧急）")
    @TableField("URGENCY_")
    private Integer urgency;

    @ApiModelProperty(value = "处理方式（使用字典，1：现场运维部处理，2：:分发至研发部处理，3：反馈至客户处理，4：其他处理方式）")
    @TableField("HANDLING_METHOD_")
    private Integer handlingMethod;

    @ApiModelProperty(value = "计划完成时间")
    @TableField("PLANNED_COMPLETION_TIME_")
    private LocalDate plannedCompletionTime;

    @ApiModelProperty(value = "实际完成时间")
    @TableField("ACTUAL_COMPLETION_TIME_")
    private LocalDate actualCompletionTime;

    @ApiModelProperty(value = "处理步骤")
    @TableField("HANDLING_STEPS_")
    private String handlingSteps;

    @ApiModelProperty(value = "服务满意度")
    @TableField("SERVICE_SATISFACTION_")
    private Double serviceSatisfaction;

    @ApiModelProperty(value = "评价时间")
    @TableField("EVALUATION_TIME_")
    private LocalDateTime evaluationTime;

    @ApiModelProperty(value = "评价用户ID")
    @TableField("EVALUATION_USER_ID_")
    private String evaluationUserId;

    @ApiModelProperty(value = "评价用户")
    @TableField("EVALUATION_USER_NAME_")
    private String evaluationUserName;

}
