package com.artfess.zsj.home.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.zsj.home.manager.SystemWorkOrderHandleLogManager;
import com.artfess.zsj.home.model.SystemWorkOrder;
import com.artfess.zsj.home.dao.SystemWorkOrderDao;
import com.artfess.zsj.home.manager.SystemWorkOrderManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.zsj.home.model.SystemWorkOrderHandleLog;
import com.artfess.zsj.home.vo.SystemWorkOrderHandleVo;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * 系统工单表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2025-03-12
 */
@Service
public class SystemWorkOrderManagerImpl extends BaseManagerImpl<SystemWorkOrderDao, SystemWorkOrder> implements SystemWorkOrderManager {

    @Resource
    private SystemWorkOrderHandleLogManager systemWorkOrderHandleLogManager;

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Override
    public SystemWorkOrder get(Serializable id) {
        return this.getById(id);
    }

    @Override
    public SystemWorkOrder getById(Serializable id) {
        SystemWorkOrder systemWorkOrder = this.getBaseMapper().selectById(id);
        if(null != systemWorkOrder){
            systemWorkOrder.setSystemWorkOrderHandleLogList(systemWorkOrderHandleLogManager.queryListBySysWorkOrderId(systemWorkOrder.getId()));
        }
        return systemWorkOrder;
    }

    @Override
    @Transactional
    public boolean save(SystemWorkOrder t) {
        t.setCode(sysIdentityManager.nextId("xtgdbh"));
        t.setHandlingStatus(1);
        // 保存记录
        SystemWorkOrderHandleLog log = new SystemWorkOrderHandleLog();
        Integer result = this.getBaseMapper().insert(t);
        log.setSystemWorkOrderId(t.getId());
        log.setHandlingUpdateTime(LocalDateTime.now());
        log.setHandlingUpdateUserName(ContextUtil.getCurrentUserName());
        log.setHandlingUpdateUserId(ContextUtil.getCurrentUserId());
        log.setHandlingUserName(ContextUtil.getCurrentUserName());
        log.setBenchmarkPrice(LocalDateTime.now());
        log.setHandlingStatus(1);
        log.setHandlingProgress(0);
        systemWorkOrderHandleLogManager.save(log);
        return null != result && result >= 1;
    }

    @Override
    @Transactional
    public void create(SystemWorkOrder t) {
        this.save(t);
    }

    @Override
    @Transactional
    public void update(SystemWorkOrder t) {
        this.updateById(t);
    }

    @Override
    @Transactional
    public void remove(Serializable id) {
        this.removeById(id);
    }

    @Override
    @Transactional
    public boolean removeById(Serializable id) {
        Integer result = this.getBaseMapper().deleteById(id);
        systemWorkOrderHandleLogManager.removeById(id.toString());
        return null != result && result >= 1;
    }

    @Override
    @Transactional
    public void removeByIds(String ...ids) {
        List<String> idList = Arrays.asList(ids);
        this.removeByIds(idList);
    }

    @Override
    @Transactional
    public boolean removeByIds(List<String> idList) {
        Integer result = this.getBaseMapper().deleteBatchIds(idList);
        systemWorkOrderHandleLogManager.removeByIds(idList);
        return null != result && result >= 1;
    }

    @Override
    @Transactional
    public void updateHandlingStatus(SystemWorkOrderHandleVo t) {
        Assert.notNull(t, "系统工单更新数据不能为空");
        Assert.notNull(t.getId(), "系统工单ID不能为空");
        Assert.notNull(t.getHandlingStatus(), "系统工单处理状态不能为空");
        SystemWorkOrder order = this.get(t.getId());
        if(5 == order.getHandlingStatus()){
            throw new BaseException("工单已经关闭，不能更新工单处理进度");
        }
        if(order.getHandlingStatus() != 3 && t.getHandlingStatus() < order.getHandlingStatus()){
            throw new BaseException("工单进度已经更新，");
        }
        order.setHandlingStatus(t.getHandlingStatus());
        if(t.getPlannedCompletionTime() != null){
            order.setPlannedCompletionTime(t.getPlannedCompletionTime());
        }
        if(StringUtils.isNotBlank(t.getHandlingSteps())){
            order.setHandlingSteps(t.getHandlingSteps());
        }
        if(t.getServiceSatisfaction() != null){
            order.setServiceSatisfaction(t.getServiceSatisfaction());
            order.setEvaluationTime(LocalDateTime.now());
            order.setEvaluationUserId(ContextUtil.getCurrentUserId());
            order.setEvaluationUserName(ContextUtil.getCurrentUserName());
        }
        if(null != t.getHandlingMethod()){
            order.setHandlingMethod(t.getHandlingMethod());
        }
        SystemWorkOrderHandleLog log = new SystemWorkOrderHandleLog();
        BeanUtils.copyProperties(t, log);
        log.setId("");
        log.setSystemWorkOrderId(t.getId());
        log.setHandlingUpdateTime(LocalDateTime.now());
        log.setHandlingUpdateUserName(ContextUtil.getCurrentUserName());
        log.setHandlingUpdateUserId(ContextUtil.getCurrentUserId());
        log.setHandlingUserName(ContextUtil.getCurrentUserName());
        if(t.getBenchmarkPrice() == null){
            log.setBenchmarkPrice(LocalDateTime.now());
        }else {
            log.setBenchmarkPrice(t.getBenchmarkPrice());
        }
        log.setHandlingStatus(t.getHandlingStatus());
        // 已处理，更新处理时间
        if(4 == t.getHandlingStatus()){
            order.setActualCompletionTime(LocalDate.now());
        }
        this.update(order);
        systemWorkOrderHandleLogManager.save(log);
    }
}
