package com.artfess.zsj.home.manager.impl;

import com.artfess.zsj.home.model.SystemWorkOrderHandleLog;
import com.artfess.zsj.home.dao.SystemWorkOrderHandleLogDao;
import com.artfess.zsj.home.manager.SystemWorkOrderHandleLogManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 系统工单处理记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2025-03-12
 */
@Service
public class SystemWorkOrderHandleLogManagerImpl extends BaseManagerImpl<SystemWorkOrderHandleLogDao, SystemWorkOrderHandleLog> implements SystemWorkOrderHandleLogManager {

    @Override
    public List<SystemWorkOrderHandleLog> queryListBySysWorkOrderId(String sysWorkOrderId) {
        QueryWrapper<SystemWorkOrderHandleLog> queryWrapper = new QueryWrapper();
        queryWrapper.eq("SYSTEM_WORK_ORDER_ID_", sysWorkOrderId);
        queryWrapper.orderByDesc("create_time_");
        return this.list(queryWrapper);
    }

    @Override
    public boolean removeBySysWorkOrderId(String sysWorkOrderId) {
        QueryWrapper<SystemWorkOrderHandleLog> queryWrapper = new QueryWrapper();
        queryWrapper.eq("SYSTEM_WORK_ORDER_ID_", sysWorkOrderId);
        return this.remove(queryWrapper);
    }

    @Override
    public boolean removeBySysWorkOrderIds(List<String> sysWorkOrderIds) {
        QueryWrapper<SystemWorkOrderHandleLog> queryWrapper = new QueryWrapper();
        queryWrapper.in("SYSTEM_WORK_ORDER_ID_", sysWorkOrderIds);
        return this.remove(queryWrapper);
    }
}
