package com.artfess.zsj.home.manager;

import com.artfess.zsj.home.model.SystemWorkOrderHandleLog;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 系统工单处理记录表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2025-03-12
 */
public interface SystemWorkOrderHandleLogManager extends BaseManager<SystemWorkOrderHandleLog> {

    /**
     * 根据系统工单ID查询处理记录
     * @param sysWorkOrderId 系统工单ID
     * @return
     */
    List<SystemWorkOrderHandleLog> queryListBySysWorkOrderId(String sysWorkOrderId);

    /**
     * 根据系统工单ID删除处理记录
     * @param sysWorkOrderId 系统工单ID
     */
    boolean removeBySysWorkOrderId(String sysWorkOrderId);

    /**
     * 根据系统工单ID批量删除处理记录
     * @param sysWorkOrderIds 系统工单ID集合
     */
    boolean removeBySysWorkOrderIds(List<String> sysWorkOrderIds);
}
