package com.artfess.zsj.application;


import com.aliyun.oss.common.utils.StringUtils;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.conf.JwtConfig;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.*;
import com.artfess.redis.util.RedisUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

@RestController
@RequestMapping("/application/server/")
@Api(tags = "第三方应用跳转登陆")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_ZSJ})
public class AppDoorLoginController {

    @Resource
    private RedisUtil redisUtil;

//    @Resource
//    private JwtConfig jwtConfig;
    @Resource
    private JwtTokenHandler jwtTokenHandler;

    @Resource
    private UCFeignService uCFeignService;

    @Resource
    private UserDetailsService userDetailsService;

    private static final  String TOKENKEY="tokenKey";

    @RequestMapping(value = "generateTokenKey", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value ="生成tokenKey", httpMethod = "GET", notes = "生成tokenKey")
    public CommonResult generateTokenKey(HttpServletRequest request) {
        //生成随机6位数
        String uid = CommonUtil.createGUID();
//        String token = request.getHeader(jwtConfig.getHeader());
        String token = HttpUtil.getRequest().getHeader("Authorization");
        if(StringUtil.isEmpty(token)){
            new CommonResult(false,"请求头中未获取到合法token令牌");
        }
        token = token.replace("Bearer ", "");
        //将token放入缓存，有效期5分钟过期
        redisUtil.set("user." + TOKENKEY + "." + uid, token,300);
        return new CommonResult(true,"接口调用成功",uid);
    }


    @RequestMapping(value = "validateKeyAndGetToken", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value ="验证tokenkey并获取token令牌", httpMethod = "GET", notes = "验证tokenkey并获取token令牌")
    public CommonResult validateKeyAndGetToken(@ApiParam(name="tokenKey", value="tokenKey") @RequestParam(required = true) String tokenKey, HttpServletRequest request) {
        String redisKey = "user." + TOKENKEY + "." + tokenKey;
        String token = (String) redisUtil.get(redisKey);
        if(StringUtils.isNullOrEmpty(token)){
            return new CommonResult(false,"无效的tokenKey");
        }
        //用完就删除
        redisUtil.del(redisKey);
        return new CommonResult(true,"接口调用成功", token);
    }

    @RequestMapping(value = "validateKeyAndGetUser", method = RequestMethod.GET, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value ="验证tokenkey并获取用户信息", httpMethod = "GET", notes = "验证tokenkey并获取用户信息")
    public CommonResult validateKeyAndGetUser(@ApiParam(name="tokenKey", value="tokenKey") @RequestParam(required = true) String tokenKey, HttpServletRequest request) {
        String redisKey = "user." + TOKENKEY + "." + tokenKey;
        String token = (String) redisUtil.get(redisKey);
        if(StringUtils.isNullOrEmpty(token)){
            return new CommonResult(false,"无效的tokenKey");
        }
        // 标记该请求是通过代理过来的，同时设置请求头token
        request.setAttribute("Authorization", token);
        request.setAttribute("Proxy-Authorization", token);
//        jwtConfig.setHeader(token);
        String userId = jwtTokenHandler.getUserIdFromToken(token);
        CommonResult<JsonNode> userResult = uCFeignService.getUserById(userId);
        if (BeanUtils.isEmpty(userResult)){
            return new CommonResult(false,"用户不存在");
        }
        JsonNode userNode = userResult.getValue();
        String account = JsonUtil.getString(userNode, "account");
        String id = JsonUtil.getString(userNode, "id");
        String status = JsonUtil.getString(userNode, "status");
        String lockedStatus = JsonUtil.getString(userNode, "lockedStatus");
//        String username= jwtTokenHandler.getUsernameFromToken(token);
//        final UserDetails user = userDetailsService.loadUserByUsername(username);
        //用完就删除
        redisUtil.del(redisKey);
        Map<String, String> map = new HashMap<>();
        map.put("account", account);
        map.put("userId", id);
        map.put("status", status);
        map.put("lockedStatus", lockedStatus);
        map.put("token", token);
        return new CommonResult(true,"接口调用成功", map);
    }
}
