/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.zsj.home.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.zsj.home.dao.SystemWorkOrderDao;
import com.artfess.zsj.home.manager.SystemWorkOrderHandleLogManager;
import com.artfess.zsj.home.manager.SystemWorkOrderManager;
import com.artfess.zsj.home.model.SystemWorkOrder;
import com.artfess.zsj.home.model.SystemWorkOrderHandleLog;
import com.artfess.zsj.home.vo.SystemWorkOrderHandleVo;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SystemWorkOrderManagerImpl
extends BaseManagerImpl<SystemWorkOrderDao, SystemWorkOrder>
implements SystemWorkOrderManager {
    @Resource
    private SystemWorkOrderHandleLogManager systemWorkOrderHandleLogManager;
    @Resource
    private SysIdentityManager sysIdentityManager;

    public SystemWorkOrder get(Serializable id) {
        return this.getById(id);
    }

    public SystemWorkOrder getById(Serializable id) {
        SystemWorkOrder systemWorkOrder = (SystemWorkOrder)((Object)((SystemWorkOrderDao)this.getBaseMapper()).selectById(id));
        if (null != systemWorkOrder) {
            systemWorkOrder.setSystemWorkOrderHandleLogList(this.systemWorkOrderHandleLogManager.queryListBySysWorkOrderId(systemWorkOrder.getId()));
        }
        return systemWorkOrder;
    }

    @Transactional
    public boolean save(SystemWorkOrder t) {
        t.setCode(this.sysIdentityManager.nextId("xtgdbh"));
        t.setHandlingStatus(1);
        SystemWorkOrderHandleLog log = new SystemWorkOrderHandleLog();
        Integer result = ((SystemWorkOrderDao)this.getBaseMapper()).insert((Object)t);
        log.setSystemWorkOrderId(t.getId());
        log.setHandlingUpdateTime(LocalDateTime.now());
        log.setHandlingUpdateUserName(ContextUtil.getCurrentUserName());
        log.setHandlingUpdateUserId(ContextUtil.getCurrentUserId());
        log.setHandlingUserName(ContextUtil.getCurrentUserName());
        log.setBenchmarkPrice(LocalDateTime.now());
        log.setHandlingStatus(1);
        log.setHandlingProgress(0);
        this.systemWorkOrderHandleLogManager.save((Object)log);
        return null != result && result >= 1;
    }

    @Transactional
    public void create(SystemWorkOrder t) {
        this.save(t);
    }

    @Transactional
    public void update(SystemWorkOrder t) {
        this.updateById((Object)t);
    }

    @Transactional
    public void remove(Serializable id) {
        this.removeById(id);
    }

    @Transactional
    public boolean removeById(Serializable id) {
        Integer result = ((SystemWorkOrderDao)this.getBaseMapper()).deleteById(id);
        this.systemWorkOrderHandleLogManager.removeById((Serializable)((Object)id.toString()));
        return null != result && result >= 1;
    }

    @Transactional
    public void removeByIds(String ... ids) {
        List<String> idList = Arrays.asList(ids);
        this.removeByIds(idList);
    }

    @Override
    @Transactional
    public boolean removeByIds(List<String> idList) {
        Integer result = ((SystemWorkOrderDao)this.getBaseMapper()).deleteBatchIds(idList);
        this.systemWorkOrderHandleLogManager.removeByIds(idList);
        return null != result && result >= 1;
    }

    @Override
    @Transactional
    public void updateHandlingStatus(SystemWorkOrderHandleVo t) {
        Assert.notNull((Object)((Object)t), (String)"\u7cfb\u7edf\u5de5\u5355\u66f4\u65b0\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)t.getId(), (String)"\u7cfb\u7edf\u5de5\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)t.getHandlingStatus(), (String)"\u7cfb\u7edf\u5de5\u5355\u5904\u7406\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        SystemWorkOrder order = this.get((Serializable)((Object)t.getId()));
        if (5 == order.getHandlingStatus()) {
            throw new BaseException("\u5de5\u5355\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u80fd\u66f4\u65b0\u5de5\u5355\u5904\u7406\u8fdb\u5ea6");
        }
        if (order.getHandlingStatus() != 3 && t.getHandlingStatus() < order.getHandlingStatus()) {
            throw new BaseException("\u5de5\u5355\u8fdb\u5ea6\u5df2\u7ecf\u66f4\u65b0\uff0c");
        }
        order.setHandlingStatus(t.getHandlingStatus());
        if (t.getPlannedCompletionTime() != null) {
            order.setPlannedCompletionTime(t.getPlannedCompletionTime());
        }
        if (StringUtils.isNotBlank((CharSequence)t.getHandlingSteps())) {
            order.setHandlingSteps(t.getHandlingSteps());
        }
        if (t.getServiceSatisfaction() != null) {
            order.setServiceSatisfaction(t.getServiceSatisfaction());
            order.setEvaluationTime(LocalDateTime.now());
            order.setEvaluationUserId(ContextUtil.getCurrentUserId());
            order.setEvaluationUserName(ContextUtil.getCurrentUserName());
        }
        if (null != t.getHandlingMethod()) {
            order.setHandlingMethod(t.getHandlingMethod());
        }
        SystemWorkOrderHandleLog log = new SystemWorkOrderHandleLog();
        BeanUtils.copyProperties((Object)((Object)t), (Object)((Object)log));
        log.setId("");
        log.setSystemWorkOrderId(t.getId());
        log.setHandlingUpdateTime(LocalDateTime.now());
        log.setHandlingUpdateUserName(ContextUtil.getCurrentUserName());
        log.setHandlingUpdateUserId(ContextUtil.getCurrentUserId());
        log.setHandlingUserName(ContextUtil.getCurrentUserName());
        if (t.getBenchmarkPrice() == null) {
            log.setBenchmarkPrice(LocalDateTime.now());
        } else {
            log.setBenchmarkPrice(t.getBenchmarkPrice());
        }
        log.setHandlingStatus(t.getHandlingStatus());
        if (4 == t.getHandlingStatus()) {
            order.setActualCompletionTime(LocalDate.now());
        }
        this.update(order);
        this.systemWorkOrderHandleLogManager.save((Object)log);
    }
}

