/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.activiti.editor.language.json.converter;

import com.artfess.activiti.editor.constants.HtStencilConstants;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.UserTaskJsonConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class HtCustomSignTaskJsonConverter
extends UserTaskJsonConverter
implements HtStencilConstants {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        HtCustomSignTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        HtCustomSignTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CustomSignTask", HtCustomSignTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, HtCustomSignTaskJsonConverter.class);
    }

    protected String getStencilId(BaseElement baseElement) {
        return "CustomSignTask";
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        UserTask userTask = (UserTask)baseElement;
        String assignee = userTask.getAssignee();
        if (StringUtils.isNotEmpty((CharSequence)assignee) || CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers()) || CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups())) {
            ObjectNode assignmentNode = this.objectMapper.createObjectNode();
            ObjectNode assignmentValuesNode = this.objectMapper.createObjectNode();
            List idmAssigneeList = (List)userTask.getExtensionElements().get("activiti-idm-assignee");
            List idmAssigneeFieldList = (List)userTask.getExtensionElements().get("activiti-idm-assignee-field");
            if (CollectionUtils.isNotEmpty((Collection)idmAssigneeList) || CollectionUtils.isNotEmpty((Collection)idmAssigneeFieldList) || CollectionUtils.isNotEmpty((Collection)((Collection)userTask.getExtensionElements().get("activiti-idm-candidate-user"))) || CollectionUtils.isNotEmpty((Collection)((Collection)userTask.getExtensionElements().get("activiti-idm-candidate-group")))) {
                assignmentValuesNode.put("type", "idm");
                ObjectNode idmNode = this.objectMapper.createObjectNode();
                assignmentValuesNode.set("idm", (JsonNode)idmNode);
                List canCompleteList = (List)userTask.getExtensionElements().get("initiator-can-complete");
                if (CollectionUtils.isNotEmpty((Collection)canCompleteList)) {
                    assignmentValuesNode.put("initiatorCanCompleteTask", Boolean.valueOf(((ExtensionElement)canCompleteList.get(0)).getElementText()));
                }
                if (StringUtils.isNotEmpty((CharSequence)userTask.getAssignee())) {
                    ObjectNode assigneeNode = this.objectMapper.createObjectNode();
                    if (userTask.getAssignee().contains("${taskAssignmentBean.assignTaskToAssignee(")) {
                        idmNode.set("assigneeField", (JsonNode)assigneeNode);
                        idmNode.put("type", "user");
                        this.fillProperty("id", "activiti-idm-assignee-field", assigneeNode, userTask);
                        this.fillProperty("name", "assignee-field-info-name", assigneeNode, userTask);
                    } else {
                        assigneeNode.put("id", userTask.getAssignee());
                        idmNode.set("assignee", (JsonNode)assigneeNode);
                        idmNode.put("type", "user");
                        this.fillProperty("externalId", "assignee-info-externalid", assigneeNode, userTask);
                        this.fillProperty("email", "assignee-info-email", assigneeNode, userTask);
                        this.fillProperty("firstName", "assignee-info-firstname", assigneeNode, userTask);
                        this.fillProperty("lastName", "assignee-info-lastname", assigneeNode, userTask);
                    }
                }
                List idmCandidateUserList = (List)userTask.getExtensionElements().get("activiti-idm-candidate-user");
                if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers()) && CollectionUtils.isNotEmpty((Collection)idmCandidateUserList)) {
                    ArrayList<String> candidateUserIds = new ArrayList<String>();
                    if (userTask.getCandidateUsers().size() == 1 && ((String)userTask.getCandidateUsers().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateUsers(")) {
                        String[] candidateUserArray;
                        idmNode.put("type", "users");
                        Object candidateUsersString = (String)userTask.getCandidateUsers().get(0);
                        candidateUsersString = ((String)candidateUsersString).replace("${taskAssignmentBean.assignTaskToCandidateUsers('", "");
                        candidateUsersString = ((String)candidateUsersString).replace("', execution)}", "");
                        ArrayList<String> candidateFieldIds = new ArrayList<String>();
                        for (String candidate : candidateUserArray = ((String)candidateUsersString).split(",")) {
                            if (candidate.contains("field(")) {
                                candidateFieldIds.add(candidate.trim().substring(6, candidate.length() - 1));
                                continue;
                            }
                            candidateUserIds.add(candidate.trim());
                        }
                        if (candidateFieldIds.size() > 0) {
                            ArrayNode candidateUserFieldsNode = this.objectMapper.createArrayNode();
                            idmNode.set("candidateUserFields", (JsonNode)candidateUserFieldsNode);
                            for (String fieldId : candidateFieldIds) {
                                ObjectNode fieldNode = this.objectMapper.createObjectNode();
                                fieldNode.put("id", fieldId);
                                candidateUserFieldsNode.add((JsonNode)fieldNode);
                                this.fillProperty("name", "user-field-info-name-" + fieldId, fieldNode, userTask);
                            }
                        }
                    } else {
                        for (Object candidateUser : userTask.getCandidateUsers()) {
                            candidateUserIds.add((String)candidateUser);
                        }
                    }
                    if (candidateUserIds.size() > 0) {
                        ArrayNode candidateUsersNode = this.objectMapper.createArrayNode();
                        idmNode.set("candidateUsers", (JsonNode)candidateUsersNode);
                        idmNode.put("type", "users");
                        for (String candidateUser : candidateUserIds) {
                            ObjectNode candidateUserNode = this.objectMapper.createObjectNode();
                            candidateUserNode.put("id", candidateUser);
                            candidateUsersNode.add((JsonNode)candidateUserNode);
                            this.fillProperty("externalId", "user-info-externalid-" + candidateUser, candidateUserNode, userTask);
                            this.fillProperty("email", "user-info-email-" + candidateUser, candidateUserNode, userTask);
                            this.fillProperty("firstName", "user-info-firstname-" + candidateUser, candidateUserNode, userTask);
                            this.fillProperty("lastName", "user-info-lastname-" + candidateUser, candidateUserNode, userTask);
                        }
                    }
                }
                List idmCandidateGroupList = (List)userTask.getExtensionElements().get("activiti-idm-candidate-group");
                if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups()) && CollectionUtils.isNotEmpty((Collection)idmCandidateGroupList)) {
                    ArrayList<String> candidateGroupIds = new ArrayList<String>();
                    if (userTask.getCandidateGroups().size() == 1 && ((String)userTask.getCandidateGroups().get(0)).contains("${taskAssignmentBean.assignTaskToCandidateGroups(")) {
                        String[] candidateGroupArray;
                        idmNode.put("type", "groups");
                        Object candidateGroupsString = (String)userTask.getCandidateGroups().get(0);
                        candidateGroupsString = ((String)candidateGroupsString).replace("${taskAssignmentBean.assignTaskToCandidateGroups('", "");
                        candidateGroupsString = ((String)candidateGroupsString).replace("', execution)}", "");
                        ArrayList<String> candidateFieldIds = new ArrayList<String>();
                        for (String candidate : candidateGroupArray = ((String)candidateGroupsString).split(",")) {
                            if (candidate.contains("field(")) {
                                candidateFieldIds.add(candidate.trim().substring(6, candidate.length() - 1));
                                continue;
                            }
                            candidateGroupIds.add(candidate.trim());
                        }
                        if (candidateFieldIds.size() > 0) {
                            ArrayNode candidateGroupFieldsNode = this.objectMapper.createArrayNode();
                            idmNode.set("candidateGroupFields", (JsonNode)candidateGroupFieldsNode);
                            for (String fieldId : candidateFieldIds) {
                                ObjectNode fieldNode = this.objectMapper.createObjectNode();
                                fieldNode.put("id", fieldId);
                                candidateGroupFieldsNode.add((JsonNode)fieldNode);
                                this.fillProperty("name", "group-field-info-name-" + fieldId, fieldNode, userTask);
                            }
                        }
                    } else {
                        for (String candidateGroup : userTask.getCandidateGroups()) {
                            candidateGroupIds.add(candidateGroup);
                        }
                    }
                    if (candidateGroupIds.size() > 0) {
                        ArrayNode candidateGroupsNode = this.objectMapper.createArrayNode();
                        idmNode.set("candidateGroups", (JsonNode)candidateGroupsNode);
                        idmNode.put("type", "groups");
                        for (String candidateGroup : candidateGroupIds) {
                            ObjectNode candidateGroupNode = this.objectMapper.createObjectNode();
                            candidateGroupNode.put("id", candidateGroup);
                            candidateGroupsNode.add((JsonNode)candidateGroupNode);
                            this.fillProperty("externalId", "group-info-externalid-" + candidateGroup, candidateGroupNode, userTask);
                            this.fillProperty("name", "group-info-name-" + candidateGroup, candidateGroupNode, userTask);
                        }
                    }
                }
            } else {
                ObjectNode candidateNode;
                ArrayNode candidateArrayNode;
                assignmentValuesNode.put("type", "static");
                if (StringUtils.isNotEmpty((CharSequence)assignee)) {
                    assignmentValuesNode.put("assignee", assignee);
                }
                if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateUsers())) {
                    candidateArrayNode = this.objectMapper.createArrayNode();
                    for (String candidateUser : userTask.getCandidateUsers()) {
                        candidateNode = this.objectMapper.createObjectNode();
                        candidateNode.put("value", candidateUser);
                        candidateArrayNode.add((JsonNode)candidateNode);
                    }
                    assignmentValuesNode.set("candidateUsers", (JsonNode)candidateArrayNode);
                }
                if (CollectionUtils.isNotEmpty((Collection)userTask.getCandidateGroups())) {
                    candidateArrayNode = this.objectMapper.createArrayNode();
                    for (String candidateGroup : userTask.getCandidateGroups()) {
                        candidateNode = this.objectMapper.createObjectNode();
                        candidateNode.put("value", candidateGroup);
                        candidateArrayNode.add((JsonNode)candidateNode);
                    }
                    assignmentValuesNode.set("candidateGroups", (JsonNode)candidateArrayNode);
                }
            }
            assignmentNode.set("assignment", (JsonNode)assignmentValuesNode);
            propertiesNode.set("usertaskassignment", (JsonNode)assignmentNode);
        }
        if (userTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", userTask.getPriority().toString(), propertiesNode);
        }
        if (userTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", userTask.getPriority().toString(), propertiesNode);
        }
        this.setPropertyValue("duedatedefinition", userTask.getDueDate(), propertiesNode);
        this.setPropertyValue("categorydefinition", userTask.getCategory(), propertiesNode);
        this.addFormProperties(userTask.getFormProperties(), propertiesNode);
    }

    protected int getExtensionElementValueAsInt(String name, UserTask userTask) {
        int intValue = 0;
        String value = this.getExtensionElementValue(name, userTask);
        if (value != null && NumberUtils.isNumber((String)value)) {
            intValue = Integer.valueOf(value);
        }
        return intValue;
    }

    protected String getExtensionElementValue(String name, UserTask userTask) {
        String value = "";
        if (CollectionUtils.isNotEmpty((Collection)((Collection)userTask.getExtensionElements().get(name)))) {
            ExtensionElement extensionElement = (ExtensionElement)((List)userTask.getExtensionElements().get(name)).get(0);
            value = extensionElement.getElementText();
        }
        return value;
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        UserTask task;
        UserTask activity = task = new UserTask();
        String multiInstanceType = this.getPropertyValueAsString("multiinstance_type", elementNode);
        String multiInstanceCardinality = this.getPropertyValueAsString("multiinstance_cardinality", elementNode);
        String multiInstanceCollection = this.getPropertyValueAsString("multiinstance_collection", elementNode);
        String multiInstanceCondition = this.getPropertyValueAsString("multiinstance_condition", elementNode);
        ObjectNode objectNode = (ObjectNode)elementNode;
        ObjectNode jsonNode = (ObjectNode)objectNode.get("properties");
        jsonNode.put("multiinstance_type", "");
        String signType = this.getPropertyValueAsString("signtype", elementNode);
        multiInstanceType = "Parallel".equals(signType) || "ParallelApprove".equals(signType) ? "Parallel" : "Sequential";
        HashMap attributes = new HashMap();
        ArrayList<ExtensionAttribute> attrs = new ArrayList<ExtensionAttribute>();
        ExtensionAttribute extensionAttr = new ExtensionAttribute("signType");
        extensionAttr.setValue(signType);
        attrs.add(extensionAttr);
        attributes.put("signType", attrs);
        task.setAttributes(attributes);
        if (StringUtils.isNotEmpty((CharSequence)multiInstanceType) && !"none".equalsIgnoreCase(multiInstanceType)) {
            String multiInstanceVariable = this.getPropertyValueAsString("multiinstance_variable", elementNode);
            MultiInstanceLoopCharacteristics multiInstanceObject = new MultiInstanceLoopCharacteristics();
            if ("sequential".equalsIgnoreCase(multiInstanceType)) {
                multiInstanceObject.setSequential(true);
            } else {
                multiInstanceObject.setSequential(false);
            }
            multiInstanceObject.setLoopCardinality(multiInstanceCardinality);
            multiInstanceObject.setInputDataItem(multiInstanceCollection);
            multiInstanceObject.setElementVariable(multiInstanceVariable);
            multiInstanceObject.setCompletionCondition(multiInstanceCondition);
            activity.setLoopCharacteristics(multiInstanceObject);
        }
        return task;
    }

    protected void fillAssigneeInfo(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode idNode;
        JsonNode assigneeNode = idmDefNode.get("assignee");
        JsonNode assigneeFieldNode = idmDefNode.get("assigneeField");
        if (assigneeNode != null && !assigneeNode.isNull()) {
            JsonNode idNode2 = assigneeNode.get("id");
            JsonNode emailNode = assigneeNode.get("email");
            if (idNode2 != null && !idNode2.isNull() && StringUtils.isNotEmpty((CharSequence)idNode2.asText())) {
                task.setAssignee(idNode2.asText());
                this.addExtensionElement("activiti-idm-assignee", String.valueOf(true), task);
                this.addExtensionElement("assignee-info-email", emailNode, task);
                this.addExtensionElement("assignee-info-firstname", assigneeNode.get("firstName"), task);
                this.addExtensionElement("assignee-info-lastname", assigneeNode.get("lastName"), task);
                this.addExtensionElement("assignee-info-externalid", assigneeNode.get("externalId"), task);
            } else if (emailNode != null && !emailNode.isNull() && StringUtils.isNotEmpty((CharSequence)emailNode.asText())) {
                task.setAssignee(emailNode.asText());
                this.addExtensionElement("activiti-assignee-email", task.getAssignee(), task);
                this.addExtensionElement("activiti-idm-assignee", String.valueOf(true), task);
            }
        } else if (assigneeFieldNode != null && !assigneeFieldNode.isNull() && (idNode = assigneeFieldNode.get("id")) != null && !idNode.isNull() && StringUtils.isNotEmpty((CharSequence)idNode.asText())) {
            task.setAssignee("${taskAssignmentBean.assignTaskToAssignee('" + idNode.asText() + "', execution)}");
            this.addExtensionElement("activiti-idm-assignee-field", idNode.asText(), task);
            this.addExtensionElement("assignee-field-info-name", assigneeFieldNode.get("name"), task);
        }
        if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
            this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
        } else {
            this.addInitiatorCanCompleteExtensionElement(false, task);
        }
    }

    protected void fillCandidateUsers(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode candidateUserFieldsNode;
        JsonNode idNode;
        ArrayList<String> candidateUsers = new ArrayList<String>();
        JsonNode candidateUsersNode = idmDefNode.get("candidateUsers");
        if (candidateUsersNode != null && candidateUsersNode.isArray()) {
            ArrayList<String> emails = new ArrayList<String>();
            for (JsonNode userNode : candidateUsersNode) {
                if (userNode == null || userNode.isNull()) continue;
                idNode = userNode.get("id");
                JsonNode emailNode = userNode.get("email");
                if (idNode != null && !idNode.isNull() && StringUtils.isNotEmpty((CharSequence)idNode.asText())) {
                    String id = idNode.asText();
                    candidateUsers.add(id);
                    this.addExtensionElement("user-info-email-" + id, emailNode, task);
                    this.addExtensionElement("user-info-firstname-" + id, userNode.get("firstName"), task);
                    this.addExtensionElement("user-info-lastname-" + id, userNode.get("lastName"), task);
                    this.addExtensionElement("user-info-externalid-" + id, userNode.get("externalId"), task);
                    continue;
                }
                if (emailNode == null || emailNode.isNull() || !StringUtils.isNotEmpty((CharSequence)emailNode.asText())) continue;
                String email = emailNode.asText();
                candidateUsers.add(email);
                emails.add(email);
            }
            if (emails.size() > 0) {
                this.addExtensionElement("activiti-candidate-users-emails", StringUtils.join(emails, (String)","), task);
            }
            if (candidateUsers.size() > 0) {
                this.addExtensionElement("activiti-idm-candidate-user", String.valueOf(true), task);
                if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                    this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
                } else {
                    this.addInitiatorCanCompleteExtensionElement(false, task);
                }
            }
        }
        if ((candidateUserFieldsNode = idmDefNode.get("candidateUserFields")) != null && candidateUserFieldsNode.isArray()) {
            for (JsonNode fieldNode : candidateUserFieldsNode) {
                idNode = fieldNode.get("id");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                String id = idNode.asText();
                candidateUsers.add("field(" + id + ")");
                this.addExtensionElement("user-field-info-name-" + id, fieldNode.get("name"), task);
            }
        }
        if (candidateUsers.size() > 0) {
            if (candidateUserFieldsNode != null && candidateUserFieldsNode.isArray() && candidateUserFieldsNode.size() > 0) {
                String candidateUsersString = StringUtils.join(candidateUsers, (String)",");
                candidateUsersString = "${taskAssignmentBean.assignTaskToCandidateUsers('" + candidateUsersString + "', execution)}";
                candidateUsers.clear();
                candidateUsers.add(candidateUsersString);
                task.setCandidateUsers(candidateUsers);
            } else {
                task.setCandidateUsers(candidateUsers);
            }
        }
    }

    protected void fillCandidateGroups(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode candidateGroupFieldsNode;
        String id;
        ArrayList<String> candidateGroups = new ArrayList<String>();
        JsonNode candidateGroupsNode = idmDefNode.get("candidateGroups");
        if (candidateGroupsNode != null && candidateGroupsNode.isArray()) {
            for (Iterator groupNode : candidateGroupsNode) {
                if (groupNode == null || groupNode.isNull()) continue;
                JsonNode idNode = groupNode.get("id");
                JsonNode nameNode = groupNode.get("name");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                id = idNode.asText();
                candidateGroups.add(id);
                this.addExtensionElement("group-info-name-" + id, nameNode, task);
                this.addExtensionElement("group-info-externalid-" + id, groupNode.get("externalId"), task);
            }
        }
        if ((candidateGroupFieldsNode = idmDefNode.get("candidateGroupFields")) != null && candidateGroupFieldsNode.isArray()) {
            for (JsonNode fieldNode : candidateGroupFieldsNode) {
                JsonNode idNode = fieldNode.get("id");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                id = idNode.asText();
                candidateGroups.add("field(" + id + ")");
                this.addExtensionElement("group-field-info-name-" + id, fieldNode.get("name"), task);
            }
        }
        if (candidateGroups.size() > 0) {
            if (candidateGroupFieldsNode != null && candidateGroupFieldsNode.isArray() && candidateGroupFieldsNode.size() > 0) {
                String candidateGroupsString = StringUtils.join(candidateGroups, (String)",");
                candidateGroupsString = "${taskAssignmentBean.assignTaskToCandidateGroups('" + candidateGroupsString + "', execution)}";
                candidateGroups.clear();
                candidateGroups.add(candidateGroupsString);
                task.setCandidateGroups(candidateGroups);
            } else {
                task.setCandidateGroups(candidateGroups);
            }
            this.addExtensionElement("activiti-idm-candidate-group", String.valueOf(true), task);
            if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                this.addInitiatorCanCompleteExtensionElement(Boolean.valueOf(canCompleteTaskNode.asText()), task);
            } else {
                this.addInitiatorCanCompleteExtensionElement(false, task);
            }
        }
    }

    protected void addInitiatorCanCompleteExtensionElement(boolean canCompleteTask, UserTask task) {
        this.addExtensionElement("initiator-can-complete", String.valueOf(canCompleteTask), task);
    }

    protected void addExtensionElement(String name, JsonNode elementNode, UserTask task) {
        if (elementNode != null && !elementNode.isNull() && StringUtils.isNotEmpty((CharSequence)elementNode.asText())) {
            this.addExtensionElement(name, elementNode.asText(), task);
        }
    }

    protected void addExtensionElement(String name, String elementText, UserTask task) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setNamespace("http://activiti.com/modeler");
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(elementText);
        task.addExtensionElement(extensionElement);
    }

    protected void fillProperty(String propertyName, String extensionElementName, ObjectNode elementNode, UserTask task) {
        List extensionElementList = (List)task.getExtensionElements().get(extensionElementName);
        if (CollectionUtils.isNotEmpty((Collection)extensionElementList)) {
            elementNode.put(propertyName, ((ExtensionElement)extensionElementList.get(0)).getElementText());
        }
    }
}

