/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bpm.persistence.dao.BpmProBoDao;
import com.artfess.bpm.persistence.manager.BpmProBoManager;
import com.artfess.bpm.persistence.model.BpmProBo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmProBoManager")
public class BpmProBoManagerImpl
extends BaseManagerImpl<BpmProBoDao, BpmProBo>
implements BpmProBoManager {
    @Override
    @Transactional
    public void removeByProcessId(String processId) {
        if (StringUtil.isEmpty((String)processId)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        ((BpmProBoDao)this.baseMapper).removeByProcess(params);
    }

    @Override
    @Transactional
    public void removeByProcessKey(String processKey) {
        if (StringUtil.isEmpty((String)processKey)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processKey", processKey);
        ((BpmProBoDao)this.baseMapper).removeByProcess(params);
    }

    @Override
    @Transactional
    public void removeByBoCode(String boCode) {
        if (StringUtil.isEmpty((String)boCode)) {
            return;
        }
        ((BpmProBoDao)this.baseMapper).removeByBoCode(boCode);
    }

    @Override
    public List<BpmProBo> getByProcessId(String processId) {
        if (StringUtil.isEmpty((String)processId)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processId", processId);
        return ((BpmProBoDao)this.baseMapper).getByProcess(params);
    }

    @Override
    public List<BpmProBo> getByProcessKey(String processKey) {
        if (StringUtil.isEmpty((String)processKey)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("processKey", processKey);
        return ((BpmProBoDao)this.baseMapper).getByProcess(params);
    }

    @Override
    public List<BpmProBo> getByBoCode(String boCode) {
        if (StringUtil.isEmpty((String)boCode)) {
            return null;
        }
        return ((BpmProBoDao)this.baseMapper).getByBoCode(boCode);
    }

    @Override
    @Transactional
    public void createByBpmProBoList(List<BpmProBo> bpmProBoList, String flowId, String flowKey) {
        boolean mark = true;
        if (StringUtil.isNotEmpty((String)flowId)) {
            this.removeByProcessId(flowId);
            mark = false;
        }
        if (mark && StringUtil.isNotEmpty((String)flowKey)) {
            this.removeByProcessKey(flowKey);
        }
        if (bpmProBoList == null || bpmProBoList.size() <= 0) {
            return;
        }
        for (BpmProBo bpmProBo : bpmProBoList) {
            String btId = bpmProBo.getId();
            bpmProBo.setProcessId(flowId);
            bpmProBo.setProcessKey(flowKey);
            if (!StringUtil.isEmpty((String)btId)) continue;
            btId = UniqueIdUtil.getSuid();
            bpmProBo.setId(btId);
        }
        super.saveBatch(bpmProBoList);
    }

    @Override
    public List<BpmProBo> getByProcess(Map<String, Object> params) {
        return ((BpmProBoDao)this.baseMapper).getByProcess(params);
    }
}

