/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.def.impl.handler;

import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.bpm.api.plugin.core.context.PluginParse;
import com.artfess.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.artfess.bpm.engine.def.DefXmlHandlerUtil;
import com.artfess.bpm.engine.def.impl.handler.PluginContextContainer;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.springframework.stereotype.Service;

@Service
public class ServiceNodeBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<String> {
    @Resource
    private PluginContextContainer pluginHandlerContainer;

    @Override
    protected String getXml(String defId, String nodeId, String json) throws Exception {
        ObjectNode jsonObj = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String pluginType = jsonObj.get("pluginType").asText();
        PluginParse ctx = this.pluginHandlerContainer.getPluginParse(pluginType);
        ctx.parse(json);
        String pluginXml = ctx.getPluginXml();
        DefaultBpmDefinition bpmDef = this.bpmDefinitionManager.getById(defId);
        String defXml = bpmDef.getBpmnXml();
        Document doc = Dom4jUtil.loadXml((String)defXml);
        Element root = doc.getRootElement();
        String url = "http://www.jee-soft.cn/bpm/plugins/execution/" + pluginType;
        root.addNamespace("service", url);
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins/service:" + pluginType;
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins";
        DefXmlHandlerUtil.handXmlDom(root, pluginXml, xParentPath, xPath);
        root.remove(new Namespace("service", url));
        return root.asXML();
    }
}

