/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.conf.SaaSConfig;
import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.handler.MultiTenantHandler;
import com.artfess.base.handler.MultiTenantIgnoreResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.dao.SysSwiftMenuDao;
import com.artfess.sysConfig.persistence.manager.SysMenuManager;
import com.artfess.sysConfig.persistence.manager.SysSwiftMenuManager;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.sysConfig.persistence.model.SysSwiftMenu;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="sysSwiftMenuAuthManager")
public class SysSwiftMenuManagerImpl
extends BaseManagerImpl<SysSwiftMenuDao, SysSwiftMenu>
implements SysSwiftMenuManager {
    @Resource
    UCFeignService uCFeignService;
    @Autowired
    SaaSConfig saaSConfig;
    @Autowired
    SysMenuManager sysMenuManager;
    @Resource
    BaseContext baseContext;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String insertSwiftMenus(String menuAlias) {
        Assert.hasText((String)menuAlias, (String)"\u83dc\u5355\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String userId = ContextUtil.getCurrentUserId();
        SysSwiftMenu sysSwiftMenu = this.getSysSwiftMenu(userId, menuAlias, null);
        ((SysSwiftMenuDao)this.baseMapper).insert((Object)sysSwiftMenu);
        return sysSwiftMenu.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertSwiftMenusList(List<String> menuAlias) {
        Assert.notEmpty(menuAlias, (String)"\u83dc\u5355\u52fe\u9009\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String userId = ContextUtil.getCurrentUserId();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysSwiftMenu::getUserId, (Object)userId);
        this.remove((Wrapper)queryWrapper);
        ArrayList<SysSwiftMenu> sysSwiftMenus = new ArrayList<SysSwiftMenu>();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("user_id_", userId);
        Integer sn = this.getNextSequence(param);
        for (String alias : menuAlias) {
            SysSwiftMenu sysSwiftMenu = this.getSysSwiftMenu(userId, alias, sn);
            sysSwiftMenus.add(sysSwiftMenu);
            Integer n = sn;
            Integer n2 = sn = Integer.valueOf(sn + 1);
        }
        return this.saveBatch(sysSwiftMenus);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Integer removeSwiftMenus(String menuAlias) {
        Assert.hasText((String)menuAlias, (String)"\u83dc\u5355\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String userId = ContextUtil.getCurrentUserId();
        QueryWrapper delwrapper = new QueryWrapper();
        delwrapper.eq((Object)"user_id_", (Object)userId);
        delwrapper.eq((Object)"menu_alias_", (Object)menuAlias);
        int num = ((SysSwiftMenuDao)this.baseMapper).delete((Wrapper)delwrapper);
        return num;
    }

    @Override
    public List<SysMenu> getSwiftMenus(String userId, String parentMenuPath) {
        IUser currentUser = ContextUtil.getCurrentUser();
        List<SysMenu> dbMenus = null;
        if (BeanUtils.isEmpty((Object)currentUser)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237");
        }
        if (StringUtil.isEmpty((String)userId)) {
            userId = ContextUtil.getCurrentUserId();
        }
        if (currentUser.isAdmin()) {
            dbMenus = ((SysSwiftMenuDao)this.baseMapper).getSwiftMenuByAdmin(userId, parentMenuPath);
        } else {
            List roles = this.uCFeignService.getRoleListByAccount(currentUser.getAccount());
            ArrayList<String> roleCodes = new ArrayList<String>();
            if (BeanUtils.isNotEmpty((Object)roles)) {
                for (ObjectNode role : roles) {
                    if (1 != role.get("enabled").asInt()) continue;
                    roleCodes.add(role.get("code").asText());
                }
                if (BeanUtils.isNotEmpty(roleCodes)) {
                    String tenantId = this.saaSConfig.isEnable() ? this.baseContext.getCurrentTenantId() : null;
                    try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                        List ignoreMenus = null;
                        if (this.saaSConfig.isEnable() && !"-1".equals(currentUser.getTenantId())) {
                            ignoreMenus = this.uCFeignService.getIgnoreMenuCodes(currentUser.getTenantId());
                        }
                        dbMenus = ((SysSwiftMenuDao)this.baseMapper).getSwiftMenuByUserId(userId, roleCodes, parentMenuPath, tenantId, BeanUtils.isEmpty(ignoreMenus) ? null : ignoreMenus);
                    }
                    catch (Exception e) {
                        throw new BaseException((Throwable)e);
                    }
                }
            }
        }
        this.makeUpMenu(dbMenus);
        return dbMenus;
    }

    private SysSwiftMenu getSysSwiftMenu(String userId, String alias, Integer sn) {
        SysSwiftMenu sysSwiftMenu = new SysSwiftMenu();
        sysSwiftMenu.setMenuAlias(alias);
        sysSwiftMenu.setUserId(userId);
        if (Objects.isNull(sn)) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("user_id_", userId);
            sn = this.getNextSequence(param);
        }
        sysSwiftMenu.setSn(sn);
        return sysSwiftMenu;
    }

    private void makeUpMenu(List<SysMenu> dbMenus) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"status_", (Object)"1");
        queryWrapper.like((Object)"path_", (Object)"%.3.%");
        List all = this.sysMenuManager.list((Wrapper)queryWrapper);
        Map<String, SysMenu> menuMap = all.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        if (CollectionUtils.isEmpty(menuMap)) {
            return;
        }
        for (SysMenu sysMenu : dbMenus) {
            String path = sysMenu.getPath();
            String[] paths = path.split("\\.");
            StringBuffer routrtPathsb = new StringBuffer();
            for (int i = 2; i < paths.length; ++i) {
                String menuId = paths[i];
                if (!menuMap.containsKey(menuId)) continue;
                SysMenu menu = menuMap.get(menuId);
                routrtPathsb.append("/");
                routrtPathsb.append(menu.getAlias());
            }
            if (routrtPathsb.length() <= 1) continue;
            sysMenu.setRouterPath(routrtPathsb.substring(1));
        }
    }
}

