/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.filter;

import com.artfess.base.conf.JwtConfig;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.EncryptUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.SecurityUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadLocalCleanUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.web.filter.OncePerRequestFilter;

public class JwtAuthorizationTokenFilter
extends OncePerRequestFilter {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private String encryKey;
    private UserDetailsService userDetailsService;
    private JwtTokenHandler jwtTokenHandler;
    private String tokenHeader;

    public void setEncryKey(String encryKey) {
        this.encryKey = encryKey;
    }

    public JwtAuthorizationTokenFilter(UserDetailsService userDetailsService, JwtTokenHandler jwtTokenHandler, String tokenHeader) {
        this.userDetailsService = userDetailsService;
        this.jwtTokenHandler = jwtTokenHandler;
        this.tokenHeader = tokenHeader;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        ThreadLocalCleanUtil.cleanAll();
        String requestHeader = request.getHeader(this.tokenHeader);
        if (StringUtil.isEmpty(requestHeader)) {
            requestHeader = request.getHeader("Proxy-Authorization");
        }
        String username = null;
        String authToken = null;
        if (requestHeader != null && requestHeader.startsWith("Bearer ")) {
            authToken = requestHeader.substring(7);
            try {
                username = this.jwtTokenHandler.getUsernameFromToken(authToken);
            }
            catch (Exception e) {
                this.logger.warn("the token valid exception", (Throwable)e);
                this.send401Error(response, e.getMessage());
                return;
            }
        }
        if (requestHeader != null && requestHeader.startsWith("Basic ")) {
            String basicToken = requestHeader.substring(6);
            String userPwd = Base64.getFromBase64(basicToken);
            String[] arys = userPwd.split(":");
            if (arys.length == 2) {
                try {
                    String pwd = "";
                    try {
                        pwd = EncryptUtil.decrypt(arys[1]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if ("admin".equals(arys[0]) && pwd.equals(this.encryKey)) {
                        SecurityUtil.login(request, arys[0], "", true);
                    }
                    SecurityUtil.login(request, arys[0], arys[1], false);
                }
                catch (Exception e) {
                    this.logger.error("\u7528\u6237\u8ba4\u8bc1\u9519\u8bef", (Throwable)e);
                    this.send401Error(response, e.getMessage());
                    return;
                }
            }
        } else {
            this.logger.warn("couldn't find bearer string, will ignore the header");
        }
        this.logger.debug("checking authentication for user '{}'", username);
        if (username != null && SecurityContextHolder.getContext().getAuthentication() == null) {
            this.logger.debug("security context was null, so authorizating user");
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
            if (this.jwtTokenHandler.validateToken(authToken, userDetails).booleanValue()) {
                try {
                    this.handleSingleLogin(request, username, authToken, userDetails);
                }
                catch (Exception e) {
                    this.logger.warn("the token valid exception", (Throwable)e);
                    this.send401Error(response, e.getMessage());
                    return;
                }
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                AuthenticationUtil.setAuthentication((Authentication)authentication);
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void send401Error(HttpServletResponse response, String message) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html; charset=utf-8");
        CommonResult result = new CommonResult(false, message);
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        PrintWriter writer = response.getWriter();
        writer.print(JsonUtil.toJson(result));
        writer.flush();
    }

    private void handleSingleLogin(HttpServletRequest request, String username, String token, UserDetails userDetails) throws Exception {
        JwtConfig jwtConfig = AppUtil.getBean(JwtConfig.class);
        String header = request.getHeader("Proxy-Authorization");
        if (jwtConfig.isSingle() && StringUtil.isEmpty(header)) {
            boolean isMobile = HttpUtil.isMobile(request);
            String userAgent = isMobile ? "mobile" : "pc";
            String tenantId = HttpUtil.getTenantId();
            tenantId = StringUtil.isNotEmpty(tenantId) ? tenantId : "-1";
            String oldToken = this.jwtTokenHandler.getTokenFromCache(userAgent, tenantId, username, jwtConfig.getExpiration());
            if (jwtConfig.isStricty()) {
                if (StringUtil.isEmpty(token) || !token.equals(oldToken)) {
                    throw new Exception("\u5f53\u524d\u767b\u5f55\u72b6\u6001\u5df2\u8fc7\u671f\uff01");
                }
            } else if (StringUtil.isNotEmpty(oldToken) && this.jwtTokenHandler.validateToken(oldToken, userDetails).booleanValue() && !oldToken.equals(token)) {
                throw new Exception("\u5f53\u524d\u8d26\u53f7\u5df2\u5728\u53e6\u4e00\u5730\u65b9\u767b\u5f55\uff0c\u82e5\u4e0d\u662f\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u6ce8\u610f\u8d26\u53f7\u5b89\u5168\uff01");
            }
        }
    }
}

