/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.persistence.dao.BpmWatermarkTypeDao;
import com.artfess.bpm.persistence.manager.BpmWatermarkTypeManager;
import com.artfess.bpm.persistence.model.BpmWatermarkType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service(value="bpmWatermarkTypeManager")
public class BpmWatermarkTypeManagerImpl
extends BaseManagerImpl<BpmWatermarkTypeDao, BpmWatermarkType>
implements BpmWatermarkTypeManager {
    @Override
    public void batchAdd(List<BpmWatermarkType> watermarkTypes, int isAllSave) {
        if (isAllSave == 0) {
            List types = watermarkTypes.stream().filter(item -> {
                BpmWatermarkType type = this.isExist(item.getTypeId());
                return !BeanUtils.isNotEmpty((Object)((Object)type));
            }).collect(Collectors.toList());
            this.saveBatch(types);
        } else {
            for (BpmWatermarkType item2 : watermarkTypes) {
                BpmWatermarkType type = this.isExist(item2.getTypeId());
                if (BeanUtils.isNotEmpty((Object)((Object)type))) {
                    type.setWatermarkId(item2.getWatermarkId());
                    this.update((Model)type);
                    continue;
                }
                this.create((Model)item2);
            }
        }
    }

    @Override
    public CommonResult<String> isExist(List<BpmWatermarkType> watermarkTypes) {
        ArrayList<String> existList = new ArrayList<String>();
        ArrayList<String> existHereList = new ArrayList<String>();
        for (BpmWatermarkType item : watermarkTypes) {
            BpmWatermarkType type = this.isExist(item.getTypeId());
            if (!BeanUtils.isNotEmpty((Object)((Object)type))) continue;
            if (!item.getWatermarkId().equals(type.getWatermarkId())) {
                existList.add(item.getTypeName());
                continue;
            }
            existHereList.add(item.getTypeName());
        }
        if (existHereList.size() == watermarkTypes.size()) {
            return new CommonResult(false, "\u6b64\u5206\u7c7b\u5df2\u5206\u914d");
        }
        if (existList.size() > 0) {
            return new CommonResult(true, "[" + String.join((CharSequence)",", existList) + "]\u5df2\u8bbe\u7f6e");
        }
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f");
    }

    private BpmWatermarkType isExist(String typeId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"type_id_", (Object)typeId);
        BpmWatermarkType type = (BpmWatermarkType)((Object)((BpmWatermarkTypeDao)this.baseMapper).selectOne((Wrapper)wrapper));
        return type;
    }
}

