/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.form;

import com.artfess.base.feign.FormFeignService;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.NodeType;
import com.artfess.bpm.api.model.form.FormType;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.engine.form.AbstractFormService;
import com.artfess.bpm.model.form.BpmForm;
import com.artfess.bpm.model.form.Form;
import com.artfess.bpm.model.form.FormCategory;
import com.artfess.bpm.model.form.FormModel;
import com.artfess.bpm.persistence.model.BpmInstForm;
import com.artfess.bpm.persistence.model.DefaultBpmProcessDefExt;
import com.artfess.i18n.util.I18nUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service(value="defaultBpmFormService")
public class DefaultBpmFormService
extends AbstractFormService {
    @Override
    protected Form getFormByNodeDef(BpmNodeDef bpmNodeDef) {
        return bpmNodeDef.getForm();
    }

    @Override
    protected Form getGlobalFormByDefExt(DefaultBpmProcessDefExt ext) {
        return ext.getGlobalForm();
    }

    @Override
    protected Form getSubForm(BpmNodeDef bpmNodeDef, String parentDefKey) {
        return bpmNodeDef.getSubForm(parentDefKey, FormType.PC);
    }

    @Override
    protected Form getInstFormByDefExt(DefaultBpmProcessDefExt defExt) {
        return defExt.getInstForm();
    }

    @Override
    public FormModel getInstanceNodeForm(BpmProcessInstance instance, String defId, String nodeId) throws Exception {
        boolean isSub = false;
        boolean isInstForm = false;
        if (instance.getId().equals(nodeId)) {
            isInstForm = true;
        }
        if (StringUtil.isNotZeroEmpty((String)instance.getParentInstId())) {
            instance = (BpmProcessInstance)this.bpmProcessInstanceManager.get((Serializable)((Object)instance.getParentInstId()));
            isSub = true;
        }
        BpmInstForm bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), defId, nodeId, FormType.PC.value());
        if (isSub) {
            if (isInstForm) {
                bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), defId, instance.getId(), FormType.PC.value());
            } else {
                BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
                Form form = bpmNodeDef.getSubForm(instance.getProcDefKey(), FormType.PC);
                if (BeanUtils.isEmpty((Object)form)) {
                    List<BpmNodeDef> startNodes;
                    bpmInstForm = null;
                    List<BpmNodeDef> nodeDefs = this.bpmDefinitionAccessor.getAllNodeDef(instance.getProcDefId());
                    for (BpmNodeDef nodeDef : nodeDefs) {
                        if (!nodeDef.getType().equals((Object)NodeType.START) || !BeanUtils.isNotEmpty(nodeDef.getSubFormList())) continue;
                        bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), instance.getProcDefId(), nodeDef.getNodeId(), FormType.PC.value());
                        break;
                    }
                    if (BeanUtils.isEmpty((Object)((Object)bpmInstForm)) && BeanUtils.isNotEmpty(startNodes = this.bpmDefinitionAccessor.getStartNodes(instance.getProcDefId()))) {
                        bpmInstForm = this.bpmInstFormManager.getNodeForm(instance.getId(), instance.getProcDefId(), startNodes.get(0).getNodeId(), FormType.PC.value());
                    }
                }
            }
        }
        if (BeanUtils.isEmpty((Object)((Object)bpmInstForm))) {
            bpmInstForm = this.bpmInstFormManager.getGlobalForm(instance.getId(), FormType.PC.value());
        }
        if (BeanUtils.isEmpty((Object)((Object)bpmInstForm))) {
            return null;
        }
        String formCategory = bpmInstForm.getFormCategory();
        FormModel formModel = new BpmForm();
        if (FormCategory.INNER.equals((Object)FormCategory.fromValue(formCategory))) {
            FormFeignService formService = (FormFeignService)AppUtil.getBean(FormFeignService.class);
            ObjectNode objectNode = formService.getByFormId(bpmInstForm.getFormValue());
            formModel = (FormModel)JsonUtil.toBean((JsonNode)objectNode, BpmForm.class);
            if (BeanUtils.isEmpty((Object)formModel)) {
                return null;
            }
            formModel.setType(FormCategory.INNER);
        } else {
            formModel.setType(FormCategory.FRAME);
            formModel.setFormValue(bpmInstForm.getFormValue());
        }
        formModel = this.handForm(formModel, instance);
        if (StringUtil.isNotEmpty((String)bpmInstForm.getNodeId())) {
            formModel.setNodeId(bpmInstForm.getNodeId());
        }
        String formHtml = I18nUtil.replaceTemp((String)formModel.getFormHtml(), (String)"\\#\\{([\\w]+[\\.\\w]*)\\}", (Locale)LocaleContextHolder.getLocale());
        formModel.setFormHtml(formHtml);
        return formModel;
    }
}

