/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.ueditor.upload;

import com.artfess.base.util.AppUtil;
import com.artfess.ueditor.define.BaseState;
import com.artfess.ueditor.define.FileType;
import com.artfess.ueditor.define.State;
import com.artfess.ueditor.upload.StorageService;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Component
public class BinaryUploader {
    @Autowired
    StorageService storageService;

    public State save(HttpServletRequest request, Map<String, Object> conf) {
        String contentType = request.getContentType();
        if (contentType == null || !contentType.toLowerCase().startsWith("multipart/")) {
            return new BaseState(false, 5);
        }
        MultipartFile file = ((MultipartHttpServletRequest)request).getFile("upfile");
        String suffix = FileType.getSuffixByFilename(file.getOriginalFilename());
        if (!this.validType(suffix, (String[])conf.get("allowFiles"))) {
            return new BaseState(false, 8);
        }
        try {
            State storageState;
            if (this.storageService == null) {
                this.storageService = (StorageService)AppUtil.getBean(StorageService.class);
            }
            if ((storageState = this.storageService.saveFileByInputStream(file.getInputStream(), file.getOriginalFilename())).isSuccess()) {
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", file.getOriginalFilename());
            }
            return storageState;
        }
        catch (IOException e) {
            return new BaseState(false, 4);
        }
    }

    private boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

