/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.manager.SysLogsSettingsManager;
import com.artfess.sysConfig.persistence.model.SysLogsSettings;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logs/sysLogsSettings/v1"})
@Api(tags={"\u65e5\u5fd7\u914d\u7f6e"})
@ApiGroup(group={"group_application"})
public class SysLogsSettingsController
extends BaseController<SysLogsSettingsManager, SysLogsSettings> {
    @PostMapping(value={"/list"})
    @ApiOperation(value="\u65e5\u5fd7\u914d\u7f6e\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u83b7\u53d6\u65e5\u5fd7\u914d\u7f6e\u5217\u8868")
    public PageList<SysLogsSettings> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysLogsSettings> queryFilter) throws Exception {
        return ((SysLogsSettingsManager)this.baseService).query(queryFilter);
    }

    @GetMapping(value={"/get/{id}"})
    @ApiOperation(value="\u65e5\u5fd7\u914d\u7f6e\u6570\u636e\u8be6\u60c5", httpMethod="GET", notes="\u65e5\u5fd7\u914d\u7f6e\u6570\u636e\u8be6\u60c5")
    public SysLogsSettings get(@ApiParam(name="id", value="\u4e1a\u52a1\u5bf9\u8c61\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        return (SysLogsSettings)((SysLogsSettingsManager)this.baseService).get((Serializable)((Object)id));
    }

    @PostMapping(value={"save"})
    @ApiOperation(value="\u65b0\u589e,\u66f4\u65b0\u65e5\u5fd7\u914d\u7f6e\u6570\u636e", httpMethod="POST", notes="\u65b0\u589e,\u66f4\u65b0\u65e5\u5fd7\u914d\u7f6e\u6570\u636e")
    public CommonResult<String> save(@ApiParam(name="sysLogsSettings", value="\u65e5\u5fd7\u914d\u7f6e\u4e1a\u52a1\u5bf9\u8c61", required=true) @RequestBody SysLogsSettings sysLogsSettings) throws Exception {
        String msg = "\u6dfb\u52a0\u65e5\u5fd7\u914d\u7f6e\u6210\u529f";
        boolean isExist = false;
        if (ObjectUtils.isNotEmpty((Object)sysLogsSettings)) {
            PageList query;
            QueryFilter queryFilter = QueryFilter.build().withDefaultPage();
            String id = sysLogsSettings.getId();
            Integer logType = sysLogsSettings.getLogType();
            String moduleType = sysLogsSettings.getModuleType();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                queryFilter.addFilter("id_", (Object)id, QueryOP.NOT_IN);
            }
            if (null != logType) {
                queryFilter.addFilter("LOG_TYPE_", (Object)logType, QueryOP.EQUAL);
            }
            if (StringUtils.isNotBlank((CharSequence)moduleType)) {
                queryFilter.addFilter("module_type_", (Object)moduleType, QueryOP.EQUAL);
            }
            boolean bl = isExist = (query = ((SysLogsSettingsManager)this.baseService).query(queryFilter)).getRows().size() > 0;
        }
        if (isExist) {
            return new CommonResult(false, "\u914d\u7f6e\u4fe1\u606f\u5df2\u7ecf\u5b58\u5728,\u6dfb\u52a0\u5931\u8d25!", null);
        }
        if (StringUtil.isEmpty((String)sysLogsSettings.getId())) {
            ((SysLogsSettingsManager)this.baseService).create((Model)sysLogsSettings);
            msg = "\u6dfb\u52a0\u65e5\u5fd7\u914d\u7f6e\u6210\u529f";
        } else {
            ((SysLogsSettingsManager)this.baseService).update((Model)sysLogsSettings);
            msg = "\u66f4\u65b0\u65e5\u5fd7\u914d\u7f6e\u6210\u529f";
        }
        return new CommonResult(msg);
    }

    @DeleteMapping(value={"remove/{id}"})
    @ApiOperation(value="\u5220\u9664\u65e5\u5fd7\u914d\u7f6e\u8bb0\u5f55", httpMethod="DELETE", notes="\u5220\u9664\u65e5\u5fd7\u914d\u7f6e\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e1a\u52a1\u4e3b\u952e", required=true) @PathVariable String id) throws Exception {
        ((SysLogsSettingsManager)this.baseService).remove((Serializable)((Object)id));
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/removes"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u65e5\u5fd7\u914d\u7f6e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u65e5\u5fd7\u914d\u7f6e\u8bb0\u5f55")
    public CommonResult<String> removes(String ... ids) throws Exception {
        ((SysLogsSettingsManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u6279\u91cf\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/getSysLogsSettingStatusMap"})
    @ApiOperation(value="\u83b7\u53d6\u65e5\u5fd7\u914d\u7f6e\u72b6\u6001\u7684Map\u96c6\u5408", httpMethod="GET", notes="\u83b7\u53d6\u65e5\u5fd7\u914d\u7f6e\u72b6\u6001\u7684Map\u96c6\u5408")
    public Map<String, String> getSysLogsSettingStatusMap() throws Exception {
        return ((SysLogsSettingsManager)this.baseService).getSysLogsSettingStatusMap();
    }
}

