/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.portal.persistence.manager.SysRedisCacheManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SysRedisCacheManagerImpl
implements SysRedisCacheManager {
    private final CacheManager cacheManager;
    private final RedisTemplate<String, Object> redisTemplate;

    public SysRedisCacheManagerImpl(CacheManager cacheManager, RedisTemplate<String, Object> redisTemplate) {
        this.cacheManager = cacheManager;
        this.redisTemplate = redisTemplate;
    }

    @Override
    public Map<String, Object> getAllCache(String key) {
        HashMap map = new HashMap();
        Collection cacheNames = this.cacheManager.getCacheNames();
        cacheNames.forEach(s -> {
            ICache redis = this.cacheManager.getCache(s, CacheSetting.buildDefault((String)s));
            Map keysValues = redis.getKeysValues(s);
            if (Objects.nonNull(keysValues)) {
                map.putAll(keysValues);
            }
        });
        Map<String, Object> collect = new HashMap<String, Object>();
        collect = StringUtils.isNotBlank((CharSequence)key) ? map.entrySet().stream().filter(x -> ((String)x.getKey()).contains(key)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : map;
        return collect;
    }
}

