/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.plugin.task.userassign;

import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.UserAssignRule;
import com.artfess.bpm.engine.def.AbstractBpmDefXmlHandler;
import com.artfess.bpm.engine.def.DefXmlHandlerUtil;
import com.artfess.bpm.persistence.model.DefaultBpmDefinition;
import com.artfess.bpm.plugin.task.userassign.context.UserCopyToPluginContext;
import com.artfess.bpm.plugin.task.userassign.def.UserAssignPluginDef;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

@Service
public class UserCopyToDefBpmDefXmlHandler
extends AbstractBpmDefXmlHandler<String> {
    @Override
    protected String getXml(String defId, String nodeId, String json) {
        throw new RuntimeException("\u8be5\u65b9\u6cd5\u5df2\u7ecf\u8fc7\u65f6\uff01");
    }

    public void saveNodeXml(String defId, Map<String, String> userReadMap, String parentFlowKey) throws Exception {
        if (BeanUtils.isEmpty(userReadMap)) {
            return;
        }
        Set<Map.Entry<String, String>> entrySet = userReadMap.entrySet();
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String defxml = def.getBpmnXml();
        Element root = this.updateRoot(defxml);
        String rtnXml = "";
        for (Map.Entry<String, String> entry : entrySet) {
            String nodeId = entry.getKey();
            String nodeJson = entry.getValue();
            if (StringUtil.isEmpty((String)parentFlowKey)) {
                parentFlowKey = "local_";
            }
            String xml = this.getXmlByJson(nodeJson, defId, nodeId, parentFlowKey);
            String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins/copyTo:userCopyTo";
            String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins";
            rtnXml = DefXmlHandlerUtil.getXml(root, xml, xParentPath, xPath);
            root = this.updateRoot(rtnXml);
        }
        this.updateXml(defId, rtnXml);
    }

    private Element updateRoot(String rtnXml) {
        Document doc = Dom4jUtil.loadXml((String)rtnXml);
        Element root = doc.getRootElement();
        root.addNamespace("copyTo", "http://www.jee-soft.cn/bpm/plugins/task/userCopyTo");
        return root;
    }

    public void saveNodeXml(String defId, String nodeId, String nodeJson, String parentFlowKey) throws Exception {
        if (StringUtil.isEmpty((String)parentFlowKey)) {
            parentFlowKey = "local_";
        }
        DefaultBpmDefinition def = this.bpmDefinitionManager.getById(defId);
        String xml = this.getXmlByJson(nodeJson, defId, nodeId, parentFlowKey);
        String defxml = def.getBpmnXml();
        Document doc = Dom4jUtil.loadXml((String)defxml);
        Element root = doc.getRootElement();
        root.addNamespace("copyTo", "http://www.jee-soft.cn/bpm/plugins/task/userCopyTo");
        String xPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins/copyTo:userCopyTo";
        String xParentPath = "//ext:*[@bpmnElement='" + nodeId + "']/ext:extPlugins";
        String rtnXml = DefXmlHandlerUtil.getXml(root, xml, xParentPath, xPath);
        this.updateXml(defId, rtnXml);
    }

    private String getXmlByJson(String json, String defId, String nodeId, String parentFlowKey) throws Exception {
        UserCopyToPluginContext context = (UserCopyToPluginContext)AppUtil.getBean(UserCopyToPluginContext.class);
        context.parse(json);
        this.handelContext(context, parentFlowKey, defId, nodeId);
        String xml = context.getPluginXml();
        return xml;
    }

    private void handelContext(UserCopyToPluginContext context, String parentFlowKey, String defId, String nodeId) throws Exception {
        UserAssignPluginDef def = (UserAssignPluginDef)context.getBpmPluginDef();
        List<UserAssignRule> ruleList = def.getRuleList();
        for (UserAssignRule rule : ruleList) {
            rule.setParentFlowKey(parentFlowKey);
        }
        BpmNodeDef nodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        UserCopyToPluginContext oldContext = nodeDef.getPluginContext(UserCopyToPluginContext.class);
        if (oldContext == null) {
            return;
        }
        UserAssignPluginDef oldDef = (UserAssignPluginDef)oldContext.getBpmPluginDef();
        List<UserAssignRule> oldRuleList = oldDef.getRuleList();
        if (BeanUtils.isEmpty(oldRuleList)) {
            return;
        }
        for (UserAssignRule oldRule : oldRuleList) {
            if (StringUtil.isEmpty((String)oldRule.getParentFlowKey())) {
                oldRule.setParentFlowKey("local_");
            }
            if (oldRule.getParentFlowKey().equals(parentFlowKey)) continue;
            ruleList.add(oldRule);
        }
    }
}

