/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.persistence.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoData;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.bo.persistence.manager.BoDefManager;
import com.artfess.form.def.BpmBoDef;
import com.artfess.form.extmodel.ProcBoDef;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormField;
import com.artfess.form.model.FormMeta;
import com.artfess.form.persistence.dao.FormMetaDao;
import com.artfess.form.persistence.manager.FormFieldManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.service.FormService;
import com.artfess.form.util.FormUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bpmFormDefManager")
public class FormMetaManagerImpl
extends BaseManagerImpl<FormMetaDao, FormMeta>
implements FormMetaManager {
    private static Logger log = LoggerFactory.getLogger(FormMetaManagerImpl.class);
    public static final HashSet<String> noAttrFields = new HashSet<String>(){
        {
            this.add("button");
            this.add("text");
            this.add("immediate-single");
            this.add("immediate-textarea");
        }
    };
    @Resource
    FormFieldManager formFieldManager;
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormService formService;
    @Resource
    BoDefManager boDefManager;
    @Resource
    FormMetaManager formMetaManager;

    @Transactional
    public void create(FormMeta bpmFormDef) {
        super.create((Model)bpmFormDef);
        try {
            this.createFields(bpmFormDef, null);
            this.updateBpmFormBo(bpmFormDef);
        }
        catch (IOException e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void createFields(FormMeta bpmFormDef, Map<String, String> entIdMap) throws IOException {
        Object expandNode;
        String formId = bpmFormDef.getId();
        List defList = this.boDefManager.getByFormId(bpmFormDef.getId());
        String expand = bpmFormDef.getExpand();
        if (BeanUtils.isEmpty((Object)defList) && StringUtil.isNotEmpty((String)expand) && (expandNode = JsonUtil.toJsonNode((String)expand)).has("boDefList")) {
            ArrayNode array = (ArrayNode)expandNode.get("boDefList");
            for (JsonNode defJson : array) {
                BoDef bodef = this.boDefManager.getByDefId(defJson.get("id").asText());
                if (!BeanUtils.isNotEmpty((Object)bodef)) continue;
                defList.add(bodef);
            }
        }
        if (BeanUtils.isNotEmpty((Object)defList)) {
            for (BoDef boDef : defList) {
                String boDefId = boDef.getId();
                BoEnt mainEnt = boDef.getBoEnt();
                List mainAttr = mainEnt.getBoAttrList();
                if (!BeanUtils.isNotEmpty((Object)mainAttr)) continue;
                for (BoAttribute boAttribute : mainAttr) {
                    this.createFields(boAttribute, formId, boDefId);
                }
                List subEnts = mainEnt.getChildEntList();
                for (BoEnt subEnt : subEnts) {
                    List subAttr = subEnt.getBoAttrList();
                    for (BoAttribute subAttribute : subAttr) {
                        this.createFields(subAttribute, formId, boDefId);
                    }
                    List sunEnts = subEnt.getChildEntList();
                    for (BoEnt sunEnt : sunEnts) {
                        List sunAttr = sunEnt.getBoAttrList();
                        for (BoAttribute sunAttribute : sunAttr) {
                            this.createFields(sunAttribute, formId, boDefId);
                        }
                    }
                }
            }
        }
        try {
            this.createPermissionFields(bpmFormDef);
        }
        catch (Exception e) {
            log.error("\u751f\u6210\u975ebo\u5b57\u6bb5\u5230\u8868form_field\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public void createPermissionFields(FormMeta bpmFormDef) throws IOException {
        ArrayNode fields = FormUtil.resolutionFieldsByFormMeta(bpmFormDef);
        if (BeanUtils.isEmpty((Object)fields)) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            JsonNode fieldObj = fields.get(i);
            String ctrlType = JsonUtil.getString((JsonNode)fieldObj, (String)"ctrlType");
            if ("dataView".equals(ctrlType) && fieldObj.hasNonNull("templateObj")) {
                JsonNode jsonNode;
                String boAttrId = JsonUtil.getString((JsonNode)fieldObj, (String)"boAttrId");
                String columnType = JsonUtil.getString((JsonNode)fieldObj, (String)"columnType");
                FormField formField = (FormField)((Object)JsonUtil.toBean((JsonNode)fieldObj, FormField.class));
                if ("dataView".equals(ctrlType) && fieldObj.hasNonNull("templateObj") && (jsonNode = fieldObj.get("templateObj")).hasNonNull("boDefId")) {
                    formField.setBoDefId(jsonNode.get("boDefId").asText());
                }
                formField.setBoAttrId(boAttrId);
                formField.setCtrlType(ctrlType);
                formField.setType(columnType);
                formField.setId(UniqueIdUtil.getSuid());
                formField.setFormId(bpmFormDef.getId());
                formField.setSn(i);
                this.formFieldManager.create((Model)formField);
                continue;
            }
            if (!noAttrFields.contains(ctrlType) || !fieldObj.hasNonNull("tableName") || !fieldObj.hasNonNull("name")) continue;
            FormField formField = (FormField)((Object)JsonUtil.toBean((JsonNode)fieldObj, FormField.class));
            formField.setCtrlType(ctrlType);
            formField.setId(UniqueIdUtil.getSuid());
            formField.setFormId(bpmFormDef.getId());
            formField.setSn(i);
            this.formFieldManager.create((Model)formField);
        }
    }

    private void createFields(BoAttribute boAttribute, String formId, String boDefId) throws JsonParseException, JsonMappingException, IOException {
        FormField formField = new FormField();
        formField.setId(UniqueIdUtil.getSuid());
        formField.setBoAttrId(boAttribute.getId());
        formField.setType(boAttribute.getDataType());
        formField.setFormId(formId);
        formField.setBoDefId(boDefId);
        formField.setName(boAttribute.getName());
        formField.setDesc(boAttribute.getDesc());
        formField.setSn(boAttribute.getSn());
        formField.setEntId(boAttribute.getEntId());
        this.formFieldManager.create((Model)formField);
    }

    private void updateBpmFormBo(FormMeta formDef) throws IOException {
        String formId = formDef.getId();
        if (!StringUtil.isEmpty((String)formDef.getExpand())) {
            JsonNode expand = JsonUtil.toJsonNode((String)formDef.getExpand());
            JsonNode boDefs = expand.findValue("boDefList");
            List<String> boDef = this.formMetaManager.getBODefIdByFormId(formId);
            for (int i = 0; i < boDefs.size(); ++i) {
                String boDefId = boDefs.get(i).path("id").textValue();
                if (!BeanUtils.isNotEmpty((Object)boDefId) || boDef.contains(boDefId)) continue;
                ((FormMetaDao)this.baseMapper).createBpmFormBo(UniqueIdUtil.getSuid(), boDefId, formId);
            }
        }
    }

    @Override
    public List<FormMeta> getByBODefId(String BODefId) {
        return ((FormMetaDao)this.baseMapper).getByBODefId(BODefId);
    }

    @Override
    public FormMeta getByKey(String formKey) {
        return ((FormMetaDao)this.baseMapper).getByKey(formKey);
    }

    @Override
    @Transactional
    public void updateOpinionConf(String id, String opinionJson) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", id);
        map.put("opinionJson", opinionJson);
        ((FormMetaDao)this.baseMapper).updateOpinionConf(map);
    }

    @Override
    public String getMetaKeyByFormKey(String formKey) {
        return ((FormMetaDao)this.baseMapper).getMetaKeyByFormKey(formKey);
    }

    @Override
    public List<String> getBOCodeByFormId(String formDefId) {
        return ((FormMetaDao)this.baseMapper).getBOCodeByFormId(formDefId);
    }

    @Transactional
    public void remove(String entityId) {
        List<Form> forms = this.bpmFormManager.getByDefId(entityId);
        for (Form form : forms) {
            this.bpmFormManager.remove((Serializable)((Object)form.getId()));
        }
        ((FormMetaDao)this.baseMapper).deleteBpmFormBo(entityId);
        this.formFieldManager.delByMainId(entityId);
        super.remove((Serializable)((Object)entityId));
    }

    @Transactional
    public void update(FormMeta bpmFormDef) {
        super.update((Model)bpmFormDef);
        String formDefId = bpmFormDef.getId();
        try {
            this.formFieldManager.delByMainId(formDefId);
            this.createFields(bpmFormDef, null);
            ((FormMetaDao)this.baseMapper).deleteBpmFormBo(formDefId);
            this.updateBpmFormBo(bpmFormDef);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<BoEnt> getChildrenByFormKey(String formKey) throws IOException {
        ObjectNode expandJson;
        ArrayNode boDefList;
        String expandStr;
        ArrayList<BoEnt> ents = new ArrayList<BoEnt>();
        FormMeta def = ((FormMetaDao)this.baseMapper).getByKey(formKey);
        if (BeanUtils.isNotEmpty((Object)((Object)def)) && StringUtil.isNotEmpty((String)(expandStr = def.getExpand())) && BeanUtils.isNotEmpty((Object)(boDefList = (ArrayNode)JsonUtil.toJsonNode((Object)(expandJson = (ObjectNode)JsonUtil.toJsonNode((String)expandStr)).get("boDefList"))))) {
            for (JsonNode jsonNode : boDefList) {
                BoEnt boEnt;
                BoDef byAlias = null;
                if (jsonNode.has("alias")) {
                    byAlias = this.boDefManager.getByAlias(jsonNode.get("alias").asText());
                }
                if (BeanUtils.isEmpty(byAlias) && jsonNode.has("id")) {
                    byAlias = this.boDefManager.getByDefId(jsonNode.get("id").asText());
                }
                if (!BeanUtils.isNotEmpty((Object)(boEnt = byAlias.getBoEnt()))) continue;
                return boEnt.getChildEntList();
            }
        }
        return ents;
    }

    @Override
    public List<BoData> getBoDataByFormDefId(String formDefId) {
        List<String> boCodes = ((FormMetaDao)this.baseMapper).getBOCodeByFormId(formDefId);
        ArrayList<BoData> boDatas = new ArrayList<BoData>();
        for (String code : boCodes) {
            BoData boData = this.formService.getBodataByDefCode("database", code);
            if (!BeanUtils.isNotEmpty((Object)boData)) continue;
            boDatas.add(boData);
        }
        return boDatas;
    }

    @Override
    @Transactional
    public void deleteBpmFormBo(String formId) {
        ((FormMetaDao)this.baseMapper).deleteBpmFormBo(formId);
    }

    @Override
    @Transactional
    public void createBpmFormBo(String id, String boDefId, String formId) {
        List<String> boDef = this.formMetaManager.getBODefIdByFormId(formId);
        if (BeanUtils.isNotEmpty((Object)boDefId) && !boDef.contains(boDefId)) {
            ((FormMetaDao)this.baseMapper).createBpmFormBo(id, boDefId, formId);
        }
    }

    @Override
    public List<String> getBODefIdByFormId(String formId) {
        return ((FormMetaDao)this.baseMapper).getBODefIdByFormId(formId);
    }

    @Override
    public List<FormMeta> getBODefByFormId(String formId) {
        return ((FormMetaDao)this.baseMapper).getBODefByFormId(formId);
    }

    @Override
    public FormMeta getFormDefByRev(Map<String, Object> map) {
        return ((FormMetaDao)this.baseMapper).getFormDefByRev(map);
    }

    @Override
    public PageList listJson(QueryFilter queryFilter) throws Exception {
        PageList list = this.query(queryFilter);
        ArrayList<JsonNode> bpmFormDefList = new ArrayList<JsonNode>();
        for (FormMeta bpmFormdef : list.getRows()) {
            JsonNode expandJson;
            HashMap<String, String> formJson = new HashMap<String, String>();
            formJson.put("desc", bpmFormdef.getName());
            formJson.put("key", bpmFormdef.getKey());
            formJson.put("id", bpmFormdef.getId());
            formJson.put("name", bpmFormdef.getName());
            formJson.put("type", bpmFormdef.getType());
            String expand = bpmFormdef.getExpand();
            if (StringUtil.isNotEmpty((String)expand) && (expandJson = JsonUtil.toJsonNode((String)expand)).get("boDefList") != null) {
                formJson.put("boDefList", expandJson.get("boDefList").toString());
            }
            bpmFormDefList.add(JsonUtil.toJsonNode(formJson));
        }
        PageList pageJson = new PageList(bpmFormDefList);
        pageJson.setPage(list.getPage());
        pageJson.setPageSize(list.getPageSize());
        pageJson.setRows(list.getRows());
        pageJson.setTotal(list.getTotal());
        return pageJson;
    }

    @Override
    public PageList listJsonByBODef(QueryFilter queryFilter, String defId, String formType, String topDefKey) throws Exception {
        List<Object> boList = new ArrayList();
        if (StringUtil.isNotEmpty((String)topDefKey)) {
            BpmBoDef bpmBodef = new BpmBoDef();
            boList = bpmBodef.getBoDefs();
        }
        if (boList.size() == 0) {
            return new PageList();
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (ProcBoDef procBoDef : boList) {
            codes.add(procBoDef.getKey());
        }
        List<Form> list = this.bpmFormManager.getByBoCodes(codes, formType, (QueryFilter<Form>)queryFilter);
        return new PageList(list);
    }

    @Override
    public Map getChooseDesignTemplate(String subject, String categoryId, String formDesc, Boolean isSimple) throws Exception {
        HashMap<String, Object> mv = new HashMap<String, Object>();
        String templatePath = FormUtil.getDesignTemplatePath();
        String xml = FileUtil.readByClassPath((String)(templatePath + "designtemps.xml"));
        Document document = Dom4jUtil.loadXml((String)xml);
        Element root = document.getRootElement();
        List list = root.elements();
        String reStr = "[";
        for (Element element : list) {
            String alias = element.attributeValue("alias");
            String name = element.attributeValue("name");
            String templateDesc = element.attributeValue("templateDesc");
            if (!reStr.equals("[")) {
                reStr = reStr + ",";
            }
            reStr = reStr + "{name:'" + name + "',alias:'" + alias + "',templateDesc:'" + templateDesc + "'}";
        }
        reStr = reStr + "]";
        mv.put("subject", subject);
        mv.put("categoryId", categoryId);
        mv.put("formDesc", formDesc);
        mv.put("temps", reStr);
        mv.put("isSimple", isSimple);
        return mv;
    }

    @Override
    public void createByImport(FormMeta formDef, Map<String, String> entIdMap) {
        super.create((Model)formDef);
        try {
            this.createFields(formDef, entIdMap);
            this.updateBpmFormBo(formDef);
        }
        catch (IOException e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateByImport(FormMeta formDef, Map<String, String> entIdMap) {
        super.update((Model)formDef);
        String formDefId = formDef.getId();
        try {
            this.formFieldManager.delByMainId(formDefId);
            this.createFields(formDef, entIdMap);
            ((FormMetaDao)this.baseMapper).deleteBpmFormBo(formDefId);
            this.updateBpmFormBo(formDef);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Map<String, Object>> getBoBindFormsByFormKey(String formKey) {
        return ((FormMetaDao)this.baseMapper).getBoBindFormsByFormKey(formKey);
    }
}

