/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.portal.params.ActuatorInfo;
import com.artfess.portal.params.TraceInfo;
import com.artfess.portal.persistence.manager.ActuatorSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/monitor/actuatorSystem/v1"})
@Api(tags={"\u7cfb\u7edf\u76d1\u63a7"})
@ApiGroup(group={"group_system"})
public class ActuatorController
extends BaseController {
    @Autowired
    private ActuatorSystemService actuatorSystemService;

    @GetMapping(value={"/httpTrace"})
    @ApiOperation(value="\u8bf7\u6c42\u8ffd\u8e2a")
    public List<TraceInfo> gethttpTrace() throws IOException {
        return this.actuatorSystemService.getHttpTrace();
    }

    @GetMapping(value={"/tomcat"})
    @ApiOperation(value="tomcat\u76d1\u63a7")
    public List<ActuatorInfo> getTomcat() throws IOException {
        return this.actuatorSystemService.getMetrics("tomcat");
    }

    @GetMapping(value={"/jvm"})
    @ApiOperation(value="jvm\u76d1\u63a7")
    public List<ActuatorInfo> getJvm() throws IOException {
        return this.actuatorSystemService.getMetrics("jvm");
    }

    @GetMapping(value={"/cpu"})
    @ApiOperation(value="cpu\u76d1\u63a7")
    public List<ActuatorInfo> getCpu() throws IOException {
        return this.actuatorSystemService.getMetrics("system");
    }

    @GetMapping(value={"/process"})
    @ApiOperation(value="process\u76d1\u63a7")
    public List<ActuatorInfo> getProcess() throws IOException {
        return this.actuatorSystemService.getMetrics("process");
    }

    @GetMapping(value={"/health"})
    @ApiOperation(value="\u7ec4\u4ef6\u5065\u5eb7\u76d1\u63a7")
    public Map<String, String> getHealth() throws IOException {
        return this.actuatorSystemService.getHealth();
    }
}

