/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.util.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;

public class JVMMemoryUtils {
    private static MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static MemoryPoolMXBean edenSpaceMxBean;
    private static MemoryPoolMXBean survivorSpaceMxBean;
    private static MemoryPoolMXBean oldGenMxBean;
    private static MemoryPoolMXBean permGenMxBean;
    private static MemoryPoolMXBean codeCacheMxBean;

    public static JVMMemoryUsage getHeapMemoryUsage() {
        MemoryUsage usage;
        if (memoryMXBean != null && (usage = memoryMXBean.getHeapMemoryUsage()) != null) {
            return new JVMMemoryUsage(usage);
        }
        return null;
    }

    public static JVMMemoryUsage getNonHeapMemoryUsage() {
        MemoryUsage usage;
        if (memoryMXBean != null && (usage = memoryMXBean.getNonHeapMemoryUsage()) != null) {
            return new JVMMemoryUsage(usage);
        }
        return null;
    }

    public static JVMMemoryUsage getEdenSpaceMemoryUsage() {
        return JVMMemoryUtils.getMemoryPoolUsage(edenSpaceMxBean);
    }

    public static JVMMemoryUsage getAndResetEdenSpaceMemoryPeakUsage() {
        return JVMMemoryUtils.getAndResetMemoryPoolPeakUsage(edenSpaceMxBean);
    }

    public static JVMMemoryUsage getSurvivorSpaceMemoryUsage() {
        return JVMMemoryUtils.getMemoryPoolUsage(survivorSpaceMxBean);
    }

    public static JVMMemoryUsage getAndResetSurvivorSpaceMemoryPeakUsage() {
        return JVMMemoryUtils.getAndResetMemoryPoolPeakUsage(survivorSpaceMxBean);
    }

    public static JVMMemoryUsage getOldGenMemoryUsage() {
        return JVMMemoryUtils.getMemoryPoolUsage(oldGenMxBean);
    }

    public static JVMMemoryUsage getAndResetOldGenMemoryPeakUsage() {
        return JVMMemoryUtils.getAndResetMemoryPoolPeakUsage(oldGenMxBean);
    }

    public static JVMMemoryUsage getPermGenMemoryUsage() {
        return JVMMemoryUtils.getMemoryPoolUsage(permGenMxBean);
    }

    public static JVMMemoryUsage getAndResetPermGenMemoryPeakUsage() {
        return JVMMemoryUtils.getAndResetMemoryPoolPeakUsage(permGenMxBean);
    }

    public static JVMMemoryUsage getCodeCacheMemoryUsage() {
        return JVMMemoryUtils.getMemoryPoolUsage(codeCacheMxBean);
    }

    public static JVMMemoryUsage getAndResetCodeCacheMemoryPeakUsage() {
        return JVMMemoryUtils.getAndResetMemoryPoolPeakUsage(codeCacheMxBean);
    }

    private static JVMMemoryUsage getMemoryPoolUsage(MemoryPoolMXBean memoryPoolMXBean) {
        MemoryUsage usage;
        if (memoryPoolMXBean != null && (usage = memoryPoolMXBean.getUsage()) != null) {
            return new JVMMemoryUsage(usage);
        }
        return null;
    }

    private static JVMMemoryUsage getAndResetMemoryPoolPeakUsage(MemoryPoolMXBean memoryPoolMXBean) {
        MemoryUsage usage;
        if (memoryPoolMXBean != null && (usage = memoryPoolMXBean.getPeakUsage()) != null) {
            memoryPoolMXBean.resetPeakUsage();
            return new JVMMemoryUsage(usage);
        }
        return null;
    }

    public static void main(String[] args) {
        ArrayList listRoot = new ArrayList();
        while (true) {
            System.out.println("=======================================================================");
            System.out.println("getHeapMemoryUsage: " + JVMMemoryUtils.getHeapMemoryUsage());
            System.out.println("getNonHeapMemoryUsage: " + JVMMemoryUtils.getNonHeapMemoryUsage());
            System.out.println("getEdenSpaceMemoryUsage: " + JVMMemoryUtils.getEdenSpaceMemoryUsage());
            System.out.println("getAndResetEdenSpaceMemoryPeakUsage: " + JVMMemoryUtils.getAndResetEdenSpaceMemoryPeakUsage());
            System.out.println("getSurvivorSpaceMemoryUsage: " + JVMMemoryUtils.getSurvivorSpaceMemoryUsage());
            System.out.println("getAndResetSurvivorSpaceMemoryPeakUsage: " + JVMMemoryUtils.getAndResetSurvivorSpaceMemoryPeakUsage());
            System.out.println("getOldGenMemoryUsage: " + JVMMemoryUtils.getOldGenMemoryUsage());
            System.out.println("getAndResetOldGenMemoryPeakUsage: " + JVMMemoryUtils.getAndResetOldGenMemoryPeakUsage());
            System.out.println("getPermGenMemoryUsage: " + JVMMemoryUtils.getPermGenMemoryUsage());
            System.out.println("getAndResetPermGenMemoryPeakUsage: " + JVMMemoryUtils.getAndResetPermGenMemoryPeakUsage());
            System.out.println("getCodeCacheMemoryUsage: " + JVMMemoryUtils.getCodeCacheMemoryUsage());
            System.out.println("getAndResetCodeCacheMemoryPeakUsage: " + JVMMemoryUtils.getAndResetCodeCacheMemoryPeakUsage());
            ArrayList list = new ArrayList(10000);
            listRoot.add(list);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (list.size() > 1) {
                list.remove(0);
            }
            Runtime.getRuntime().gc();
        }
    }

    static {
        List<MemoryPoolMXBean> memoryPoolMXBeanList = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeanList) {
            String poolName = memoryPoolMXBean.getName();
            if (poolName == null) continue;
            if (edenSpaceMxBean == null && poolName.endsWith("Eden Space")) {
                edenSpaceMxBean = memoryPoolMXBean;
                continue;
            }
            if (survivorSpaceMxBean == null && poolName.endsWith("Survivor Space")) {
                survivorSpaceMxBean = memoryPoolMXBean;
                continue;
            }
            if (oldGenMxBean == null && (poolName.endsWith("Tenured Gen") || poolName.endsWith("Old Gen"))) {
                oldGenMxBean = memoryPoolMXBean;
                continue;
            }
            if (permGenMxBean == null && (poolName.endsWith("Perm Gen") || poolName.endsWith("Metaspace"))) {
                permGenMxBean = memoryPoolMXBean;
                continue;
            }
            if (codeCacheMxBean != null || !poolName.endsWith("Code Cache")) continue;
            codeCacheMxBean = memoryPoolMXBean;
        }
    }

    public static class JVMMemoryUsage {
        private long init;
        private long used;
        private long committed;
        private long max;
        private float usedPercent;

        public JVMMemoryUsage(MemoryUsage memoryUsage) {
            this.setMemoryUsage(memoryUsage);
        }

        public JVMMemoryUsage(long init, long used, long committed, long max) {
            this.setMemoryUsage(init, used, committed, max);
        }

        private void setMemoryUsage(MemoryUsage memoryUsage) {
            if (memoryUsage != null) {
                this.setMemoryUsage(memoryUsage.getInit(), memoryUsage.getUsed(), memoryUsage.getCommitted(), memoryUsage.getMax());
            } else {
                this.setMemoryUsage(0L, 0L, 0L, 0L);
            }
        }

        private void setMemoryUsage(long init, long used, long committed, long max) {
            this.init = init;
            this.used = used;
            this.committed = committed;
            this.max = max;
            this.usedPercent = this.used > 0L && max > 0L ? (float)used * Float.valueOf("1.0").floatValue() / (float)max : 0.0f;
        }

        public long getInit() {
            return this.init;
        }

        public long getUsed() {
            return this.used;
        }

        public long getCommitted() {
            return this.committed;
        }

        public long getMax() {
            return this.max;
        }

        public float getUsedPercent() {
            return this.usedPercent;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("init = " + this.init + "(" + (this.init >> 10) + "K) ");
            buf.append("used = " + this.used + "(" + (this.used >> 10) + "K) ");
            buf.append("committed = " + this.committed + "(" + (this.committed >> 10) + "K) ");
            buf.append("max = " + this.max + "(" + (this.max >> 10) + "K)");
            buf.append("usedPercent = " + this.usedPercent);
            return buf.toString();
        }
    }
}

