/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.persistence.manager.impl;

import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.portal.model.PortalDataSensitive;
import com.artfess.portal.persistence.dao.PortalDataSensitiveDao;
import com.artfess.portal.persistence.manager.PortalDataSensitiveManager;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="portalDataSensitiveManager")
public class PortalDataSensitiveManagerImpl
extends BaseManagerImpl<PortalDataSensitiveDao, PortalDataSensitive>
implements PortalDataSensitiveManager {
    @Resource
    DatabaseContext databaseContext;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Cacheable(value={"bpm:sys:dataSensitive"}, key="#root.args[1].toLowerCase()")
    public PortalDataSensitive getByDsNameAndTableName(String dataSourceAlias, String tableName) {
        try (DatabaseSwitchResult setDataSource = this.databaseContext.setDataSource("master");){
            PortalDataSensitive portalDataSensitive = ((PortalDataSensitiveDao)this.baseMapper).getByDsNameAndTableName(dataSourceAlias, tableName);
            return portalDataSensitive;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

