/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.enums;

import java.util.HashMap;
import java.util.Map;

public enum OperationType {
    LIST("LIST", "\u8fdb\u5165\u9875\u9762"),
    DETALL("DETALL", "\u67e5\u8be2\u660e\u7ec6"),
    ADD("ADD", "\u6dfb\u52a0"),
    UPDATE("UPDATE", "\u4fee\u6539"),
    DELETE("DELETE", "\u5220\u9664"),
    MOVE("MOVE", "\u79fb\u52a8"),
    QUERY("QUERY", "\u67e5\u8be2"),
    SYN("SYN", "\u540c\u6b65"),
    SAVE("SAVE", "\u4fdd\u5b58"),
    UPLOAD("UPLOAD", "\u4e0a\u4f20"),
    DOWNLOAD("DOWNLOAD", "\u4e0b\u8f7d"),
    EXPORT("EXPORT", "\u5bfc\u51fa"),
    VIEW("VIEW", "\u67e5\u770b");

    private String id;
    private String name;

    private OperationType(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public static OperationType fromId(String id) {
        switch (id) {
            case "LIST": {
                return LIST;
            }
            case "DETALL": {
                return DETALL;
            }
            case "ADD": {
                return ADD;
            }
            case "UPDATE": {
                return UPDATE;
            }
            case "DELETE": {
                return DELETE;
            }
            case "MOVE": {
                return MOVE;
            }
            case "QUERY": {
                return QUERY;
            }
            case "SYN": {
                return SYN;
            }
            case "SAVE": {
                return SAVE;
            }
            case "UPLOAD": {
                return UPLOAD;
            }
            case "DOWNLOAD": {
                return DOWNLOAD;
            }
            case "VIEW": {
                return VIEW;
            }
        }
        throw new RuntimeException(String.format("\u65e0\u6548\u64cd\u4f5c\u7c7b\u578b\u7c7b\u578b\u201c%s\u201d\u3002", String.valueOf(id)));
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static Map<String, String> getData() {
        HashMap<String, String> map = new HashMap<String, String>(OperationType.values().length);
        for (OperationType c : OperationType.values()) {
            map.put(String.valueOf(c.getId()), c.getName());
        }
        return map;
    }
}

