/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.exceptions.XMLException;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.apache.commons.lang3.StringUtils;

public class ActivitiMapExceptionParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "mapException";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Activity)) {
            return;
        }
        String errorCode = xtr.getAttributeValue(null, "errorCode");
        String andChildren = xtr.getAttributeValue(null, "includeChildExceptions");
        String exceptionClass = xtr.getElementText();
        boolean hasChildrenBool = false;
        if (StringUtils.isEmpty((CharSequence)andChildren) || andChildren.toLowerCase().equals("false")) {
            hasChildrenBool = false;
        } else if (andChildren.toLowerCase().equals("true")) {
            hasChildrenBool = true;
        } else {
            throw new XMLException("'" + andChildren + "' is not valid boolean in mapException with errorCode=" + errorCode + " and class=" + exceptionClass);
        }
        if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)errorCode.trim())) {
            throw new XMLException("No errorCode defined mapException with errorCode=" + errorCode + " and class=" + exceptionClass);
        }
        ((Activity)parentElement).getMapExceptions().add(new MapExceptionEntry(errorCode, exceptionClass, hasChildrenBool));
    }
}

