/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.rabbitmq.config;

import com.artfess.rabbitmq.config.RabbitMqConfirmCallback;
import com.artfess.rabbitmq.config.RabbitMqReturnCallback;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.ExchangeBuilder;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.core.QueueBuilder;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    @Bean(name={"msg"})
    public Queue queueMsg() {
        return new Queue("hz.msg");
    }

    @Bean(name={"scada_webSocket"})
    public Queue queueScadaWebSocket() {
        return QueueBuilder.durable((String)"hz.WindPlat.scada.webSocket").build();
    }

    @Bean(name={"scada"})
    public Queue queueScada() {
        return new Queue("hz.WindPlat.scada", true);
    }

    @Bean(name={"cmsState"})
    public Queue queueCmsState() {
        return new Queue("hz.WindPlat.cms.state");
    }

    @Bean(name={"cmsNow"})
    public Queue queueCmsNow() {
        return new Queue("hz.WindPlat.cms.now");
    }

    @Bean(name={"scadaMsg"})
    public Queue queueScadaMsg() {
        return new Queue("scada.point.msg", true);
    }

    @Bean
    public Exchange exchange() {
        return ExchangeBuilder.topicExchange((String)"exchange.hz").durable(true).build();
    }

    @Bean
    Binding bindingExchangeMessage() {
        return BindingBuilder.bind((Queue)this.queueMsg()).to(this.exchange()).with("hz.msg").noargs();
    }

    @Bean
    Binding bindingExchangeScada() {
        return BindingBuilder.bind((Queue)this.queueScada()).to(this.exchange()).with("hz.WindPlat.scada").noargs();
    }

    @Bean
    Binding bindingExchangeScadaWebSocket(@Qualifier(value="scada_webSocket") Queue queueScadaWebSocket, Exchange exchange) {
        return BindingBuilder.bind((Queue)queueScadaWebSocket).to(exchange).with("hz.WindPlat.scada.#").noargs();
    }

    @Bean
    Binding bindingExchangeScadaMsg() {
        return BindingBuilder.bind((Queue)this.queueScadaMsg()).to(this.exchange()).with("scada.point.msg").noargs();
    }

    @Bean
    Binding bindingExchangeCmsState() {
        return BindingBuilder.bind((Queue)this.queueCmsState()).to(this.exchange()).with("hz.WindPlat.cms.state").noargs();
    }

    @Bean
    Binding bindingExchangeCmsNow() {
        return BindingBuilder.bind((Queue)this.queueCmsNow()).to(this.exchange()).with("hz.WindPlat.cms.now").noargs();
    }

    @Bean(name={"messageConverter"})
    MessageConverter messageConverter() {
        return new Jackson2JsonMessageConverter();
    }

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory, @Qualifier(value="messageConverter") MessageConverter messageConverter) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMandatory(true);
        rabbitTemplate.setReturnCallback((RabbitTemplate.ReturnCallback)new RabbitMqReturnCallback());
        rabbitTemplate.setConfirmCallback((RabbitTemplate.ConfirmCallback)new RabbitMqConfirmCallback());
        rabbitTemplate.setMessageConverter(messageConverter);
        return rabbitTemplate;
    }
}

