/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.jms.impl;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.jms.JmsHandler;
import com.artfess.application.model.MsgTemplate;
import com.artfess.application.persistence.manager.MessageLogManager;
import com.artfess.application.persistence.manager.MsgTemplateManager;
import com.artfess.application.persistence.manager.SysMessageManager;
import com.artfess.application.service.impl.TemplateServiceImpl;
import com.artfess.application.util.WeiXinUtil;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.jms.JmsActor;
import com.artfess.base.jms.NoticeMessageType;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.integrate.model.SysExternalUnite;
import com.artfess.integrate.model.msg.WXTemplateParam;
import com.artfess.integrate.model.msg.WxBaseMessage;
import com.artfess.integrate.model.msg.impl.WxTextCardMessage;
import com.artfess.integrate.persistence.manager.SysExternalUniteManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WxEnterpriseHandler
implements JmsHandler {
    private static final Logger logger = LoggerFactory.getLogger(WxEnterpriseHandler.class);
    @Resource
    SysMessageManager sysMessageManager;
    @Resource
    MessageLogManager messageLogManager;
    @Resource
    SysExternalUniteManager sysExternalUniteManager;
    @Resource
    MsgTemplateManager msgTemplateManager;
    @Resource
    TemplateServiceImpl templateServiceImpl;
    @Resource
    UCFeignService uCFeignService;

    @Override
    public String getType() {
        return NoticeMessageType.WXENTERPRISE.key();
    }

    @Override
    public boolean send(JmsMessage jmsMessage) {
        try {
            SysExternalUnite wechatWork;
            String url;
            SysExternalUnite wechatOffAcc;
            List receivers = jmsMessage.getReceivers();
            String content = jmsMessage.getContent();
            content = content.replace("<p>", "");
            content = content.replace("</p>", "");
            jmsMessage.setContent(content);
            MsgTemplate msgTemplate = this.msgTemplateManager.getByKey(jmsMessage.getTemplateAlias());
            if (BeanUtils.isNotEmpty((Object)((Object)msgTemplate))) {
                jmsMessage.getExtendVars().put("templateType", msgTemplate.getTypeKey());
            }
            if (BeanUtils.isNotEmpty((Object)(wechatOffAcc = this.sysExternalUniteManager.getWeChatOfficialAccounts()))) {
                for (JmsActor receiver : receivers) {
                    HashMap map = new HashMap();
                    url = WeiXinUtil.renderOffAccUrl(jmsMessage);
                    String openIdsByUserIds = this.uCFeignService.getOpenIdsByUserIds(receiver.getId());
                    if (!BeanUtils.isNotEmpty((Object)openIdsByUserIds)) continue;
                    map.put("touser", openIdsByUserIds);
                    map.put("template_id", wechatOffAcc.getTempMsgId());
                    map.put("url", url);
                    HashMap<String, WXTemplateParam> params = new HashMap<String, WXTemplateParam>();
                    params.put("first", new WXTemplateParam(jmsMessage.getSubject(), "#173177"));
                    params.put("keyword1", new WXTemplateParam(jmsMessage.getExtendVars().get("bpmName").toString()));
                    params.put("keyword2", new WXTemplateParam(jmsMessage.getExtendVars().get("creator").toString()));
                    params.put("keyword3", new WXTemplateParam(jmsMessage.getExtendVars().get("date").toString()));
                    params.put("keyword4", new WXTemplateParam(jmsMessage.getExtendVars().get("instSubject").toString()));
                    params.put("remark", new WXTemplateParam("\u70b9\u51fb\u8be6\u60c5\u8df3\u8f6c\u3002", "#173177"));
                    map.put("data", params);
                    String msg = JsonUtil.toJson((Object)map);
                    WeiXinUtil.sendWeiXinMessage(msg);
                }
            }
            if (BeanUtils.isNotEmpty((Object)(wechatWork = this.sysExternalUniteManager.getWechatWork()))) {
                String wxWorkIds;
                ArrayList<String> users = new ArrayList<String>();
                for (JmsActor receiver : receivers) {
                    users.add(receiver.getId());
                }
                if (BeanUtils.isNotEmpty(users) && BeanUtils.isNotEmpty((Object)(wxWorkIds = this.uCFeignService.getWxWorkIdsByUserIds(String.join((CharSequence)",", users))))) {
                    url = WeiXinUtil.renderMobileUrl(jmsMessage);
                    String description2 = this.templateServiceImpl.parsePlainContent(msgTemplate, jmsMessage.getExtendVars());
                    String description3 = "";
                    if (BeanUtils.isNotEmpty(jmsMessage.getExtendVars().getOrDefault("nodeName", null))) {
                        description3 = "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u4e3a\uff1a" + jmsMessage.getExtendVars().getOrDefault("nodeName", null);
                    }
                    WxTextCardMessage wxMsg = new WxTextCardMessage(String.join((CharSequence)"|", wxWorkIds.split(",")), "@all", wechatWork.getAgentId(), msgTemplate.getSubject(), DateUtil.getCurrentTime((String)"yyyy\u5e74MM\u6708dd\u65e5"), description2, description3, url, "\u8be6\u60c5");
                    WeiXinUtil.sendTextMessage((WxBaseMessage)wxMsg);
                }
            }
            this.messageLogManager.handLogByMsgHander(jmsMessage, true, "");
            return true;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
            this.messageLogManager.handLogByMsgHander(jmsMessage, false, ex.getMessage());
            return false;
        }
    }

    @Override
    public String getTitle() {
        return "\u5fae\u4fe1\u6d88\u606f";
    }

    @Override
    public boolean getIsDefault() {
        return true;
    }

    @Override
    public boolean getSupportHtml() {
        return false;
    }
}

