/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.conf.TeijianConfig;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.dao.OrgJobDao;
import com.artfess.uc.dao.OrgParamsDao;
import com.artfess.uc.dao.OrgPostDao;
import com.artfess.uc.dao.OrgUserDao;
import com.artfess.uc.exception.HotentHttpStatus;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.DemensionManager;
import com.artfess.uc.manager.OrgAuthManager;
import com.artfess.uc.manager.OrgJobManager;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgParamsManager;
import com.artfess.uc.manager.OrgPostManager;
import com.artfess.uc.manager.OrgRoleManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.ParamsManager;
import com.artfess.uc.manager.PropertiesService;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.manager.UserUnderManager;
import com.artfess.uc.model.Demension;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgAuth;
import com.artfess.uc.model.OrgJob;
import com.artfess.uc.model.OrgParams;
import com.artfess.uc.model.OrgPost;
import com.artfess.uc.model.OrgRole;
import com.artfess.uc.model.OrgTree;
import com.artfess.uc.model.OrgUser;
import com.artfess.uc.model.Params;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserRole;
import com.artfess.uc.model.UserUnder;
import com.artfess.uc.params.common.OrgExportObject;
import com.artfess.uc.params.org.OrgAuthVo;
import com.artfess.uc.params.org.OrgPostVo;
import com.artfess.uc.params.org.OrgTreeVo;
import com.artfess.uc.params.org.OrgUserVo;
import com.artfess.uc.params.org.OrgVo;
import com.artfess.uc.params.org.TeamVo;
import com.artfess.uc.params.orgRole.OrgRoleVo;
import com.artfess.uc.params.post.PostDueVo;
import com.artfess.uc.params.user.UserUnderVo;
import com.artfess.uc.params.user.UserVo;
import com.artfess.uc.util.ContextUtil;
import com.artfess.uc.util.OrgUtil;
import com.artfess.uc.vo.TransPositionVo;
import com.artfess.uc.vo.YhOrgVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class OrgManagerImpl
extends BaseManagerImpl<OrgDao, Org>
implements OrgManager {
    protected static Logger logger = LoggerFactory.getLogger(OrgManagerImpl.class);
    @Autowired
    OrgParamsManager orgParamsService;
    @Autowired
    OrgUserManager orgUserService;
    @Autowired
    UserUnderManager userUnderService;
    @Autowired
    UserUnderManager userUnderManager;
    @Autowired
    UserManager userService;
    @Autowired
    OrgPostManager orgPostService;
    @Autowired
    UserRoleManager userRoleManager;
    @Autowired
    OrgPostDao orgPostDao;
    @Autowired
    OrgRoleManager orgRoleService;
    @Autowired
    DemensionManager demensionService;
    @Autowired
    ParamsManager paramsSerivce;
    @Autowired
    OrgAuthManager orgAuthService;
    @Autowired
    OrgJobManager orgJobService;
    @Autowired
    OrgJobDao orgJobDao;
    @Autowired
    OrgUserDao orgUserDao;
    @Autowired
    RoleManager roleService;
    @Autowired
    OrgRoleManager orgRoleManager;
    @Autowired
    DemensionManager DemensionManager;
    @Autowired
    PropertiesService propertiesService;
    @Autowired
    OrgParamsDao orgParamsDao;
    @Autowired
    private TeijianConfig teijianConfig;
    @Autowired
    private RestTemplate restTemplate;
    private static final Integer grade = 3;
    static List<Org> childOrg = new ArrayList<Org>();

    @Override
    public Org getByCode(String code) {
        return ((OrgDao)this.baseMapper).getByCode(code);
    }

    @Override
    public List<Org> getOrgListByUserId(String userId) {
        return ((OrgDao)this.baseMapper).getOrgListByUserId(userId);
    }

    @Override
    public List<Org> getOrgListByAccount(String account) throws Exception {
        User user = this.userService.getByAccount(account);
        return ((OrgDao)this.baseMapper).getOrgListByUserId(user.getId());
    }

    @Override
    @Cacheable(value={"bpm:uc:userMainOrg"}, key="#demId + '-' + #userId")
    public Org getMainGroup(String userId, String demId) {
        Demension sysDemension;
        if (BeanUtils.isNotEmpty((Object)demId)) {
            if (BeanUtils.isEmpty((Object)this.demensionService.get((Serializable)((Object)demId))) && BeanUtils.isNotEmpty((Object)(sysDemension = this.demensionService.getByCode(demId)))) {
                demId = sysDemension.getId();
            }
        } else {
            sysDemension = this.demensionService.getDefaultDemension();
            if (BeanUtils.isNotEmpty((Object)sysDemension)) {
                demId = sysDemension.getId();
            }
        }
        List<Org> list = ((OrgDao)this.baseMapper).getMainOrgListByUser(userId, StringUtil.isEmpty((String)demId) ? null : demId);
        if (BeanUtils.isEmpty(list)) {
            list = ((OrgDao)this.baseMapper).getOrgListByUserId(userId);
        }
        return BeanUtils.isEmpty(list) ? null : list.get(0);
    }

    @Transactional
    public void removeByIds(String ... ids) {
        super.removeByIds(ids);
        for (String id : ids) {
            this.orgParamsService.removeByOrgId(id);
            this.orgPostService.delByOrgId(id);
            this.orgUserService.delByOrgId(id);
            this.userUnderService.delByOrgId(id);
            this.orgAuthService.delByOrgId(id);
        }
        List allList = this.getAll();
        childOrg.removeAll(childOrg);
        for (String id : ids) {
            OrgManagerImpl.treeOrgList(allList, id);
        }
        String[] childIds = new String[childOrg.size()];
        for (int i = 0; i < childOrg.size(); ++i) {
            String id;
            childIds[i] = id = childOrg.get(i).getId();
            this.remove((Serializable)((Object)id));
        }
        for (String childId : childIds) {
            this.orgParamsService.removeByOrgId(childId);
            this.orgPostService.delByOrgId(childId);
            this.orgUserService.delByOrgId(childId);
            this.userUnderService.delByOrgId(childId);
            this.orgAuthService.delByOrgId(childId);
        }
    }

    @Override
    @Transactional
    public void updateByOrg(Org org) throws SQLException {
        String extName = org.getPathName().substring(0, org.getPathName().indexOf("/" + org.getName()));
        String extId = org.getPath().substring(0, org.getPath().indexOf("." + org.getId()));
        this.update((Model)org);
        String[] ids = new String[]{org.getId()};
        List allList = this.getAll();
        ArrayList<Org> cList = new ArrayList<Org>();
        for (String id : ids) {
            OrgManagerImpl.getChild(allList, id, cList);
        }
        String[] childIds = new String[cList.size()];
        for (int i = cList.size() - 1; i >= 0; --i) {
            String id;
            childIds[i] = id = ((Org)cList.get(i)).getId();
            Org c = this.get((Serializable)((Object)id));
            if (c.getParentId().equals(org.getId())) {
                c.setPathName(org.getPathName() + "/" + c.getName());
                c.setPath(org.getPath() + c.getId() + ".");
                c.setDemId(org.getDemId());
            } else {
                String pName = org.getName();
                String pId = org.getId();
                Org p = this.get((Serializable)((Object)c.getParentId()));
                String pathName = p.getPathName().substring(p.getPathName().indexOf("/" + pName)) + "/" + c.getName();
                String path = p.getPath().substring(p.getPath().indexOf("." + pId)) + c.getId() + ".";
                c.setPathName(extName + pathName);
                c.setPath(extId + path);
                c.setDemId(org.getDemId());
            }
            this.update((Model)c);
        }
    }

    public static List<Org> treeOrgList(List<Org> orgList, String parentId) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            OrgManagerImpl.treeOrgList(orgList, org.getId());
            childOrg.add(org);
        }
        return childOrg;
    }

    @Override
    public List<Org> getByParentId(String parentId) {
        ArrayList<Org> rtnList = new ArrayList<Org>();
        List allList = this.getAll();
        return OrgManagerImpl.getChild(allList, parentId, rtnList);
    }

    public static List<Org> getChild(List<Org> orgList, String parentId, List<Org> rtnList) {
        for (Org org : orgList) {
            if (!parentId.equals(org.getParentId())) continue;
            OrgManagerImpl.getChild(orgList, org.getId(), rtnList);
            rtnList.add(org);
        }
        return rtnList;
    }

    @Override
    public List<Org> getByOrgName(String orgName) {
        return ((OrgDao)this.baseMapper).getByOrgName(orgName);
    }

    @Override
    public List<Org> getByPathName(String pathName) {
        return ((OrgDao)this.baseMapper).getByPathName(pathName);
    }

    @Override
    public List<Org> getByParentAndDem(QueryFilter queryFilter) {
        return ((OrgDao)this.baseMapper).getByParentAndDem((Wrapper<Org>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    public Org getByDemIdAndSonId(String demId, String sonId) {
        return ((OrgDao)this.baseMapper).getByDemIdAndSonId(demId, sonId);
    }

    @Override
    public List<Org> getMainOrgListByUser(String userId, String demId) {
        return ((OrgDao)this.baseMapper).getMainOrgListByUser(userId, demId);
    }

    @Override
    public List<Org> getOrgListByDemId(String demId) {
        return ((OrgDao)this.baseMapper).getOrgListByDemId(demId);
    }

    @Override
    public List<Org> getUserOrg(String userId, String demId, Boolean isMain) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (BeanUtils.isNotEmpty((Object)isMain)) {
            if (isMain.booleanValue()) {
                params.put("isMain", "1");
            } else {
                params.put("isMain", "0");
            }
        }
        if (StringUtil.isNotEmpty((String)demId)) {
            params.put("demId", demId);
        }
        params.put("userId", userId);
        return ((OrgDao)this.baseMapper).getUserOrg(params);
    }

    @Override
    @Transactional
    public CommonResult<String> addOrg(OrgVo orgVo) throws Exception {
        if (StringUtil.isEmpty((String)orgVo.getName())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u540d\u79f0\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtil.isEmpty((String)orgVo.getCode())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010code\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (orgVo.getCode().contains(",")) {
            throw new RuntimeException("\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u80fd\u5305\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (StringUtil.isEmpty((String)orgVo.getDemId())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ef4\u5ea6id\u3010demId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (((OrgDao)this.baseMapper).getCountByCode(orgVo.getCode()) > 0) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801[" + orgVo.getCode() + "]\u5df2\u5b58\u5728\uff01");
        }
        Demension dem = (Demension)this.demensionService.get((Serializable)((Object)orgVo.getDemId()));
        if (BeanUtils.isEmpty((Object)dem)) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684demId[" + orgVo.getDemId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
        }
        Org pOrg = null;
        if (!"0".equals(orgVo.getParentId()) && StringUtil.isNotEmpty((String)orgVo.getParentId())) {
            pOrg = this.get((Serializable)((Object)orgVo.getParentId()));
            if (BeanUtils.isEmpty((Object)pOrg)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684parentId[" + orgVo.getParentId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            if (BeanUtils.isEmpty((Object)pOrg) && !pOrg.getDemId().equals(orgVo.getDemId())) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165demId\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6id\u4e0d\u4e00\u81f4\uff01");
            }
            String orgKind = orgVo.getOrgKind();
            if (StringUtil.isEmpty((String)orgKind)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u7ec4\u7ec7\u7c7b\u578b\uff01");
            }
            if (orgKind.equals("ogn") && pOrg.getOrgKind().equals("dept")) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u8be5\u7ec4\u7ec7\u7684\u7236\u7ea7\u7c7b\u578b\u662f\u3010\u90e8\u95e8\u3011\uff0c\u8be5\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u3010\u673a\u6784\u3011\uff01");
            }
        }
        Org o = new Org();
        o.setId(UniqueIdUtil.getSuid());
        o.setOrgKind(orgVo.getOrgKind());
        o.setCode(orgVo.getCode());
        o.setName(orgVo.getName());
        o.setDemId(orgVo.getDemId());
        if (StringUtils.isEmpty((CharSequence)orgVo.getParentId())) {
            o.setParentId("0");
        } else {
            o.setParentId(orgVo.getParentId());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getGrade())) {
            o.setGrade(orgVo.getGrade());
        }
        if (BeanUtils.isNotEmpty((Object)orgVo.getOrderNo())) {
            o.setOrderNo(orgVo.getOrderNo());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getAddvcd())) {
            o.setAddvcd(orgVo.getAddvcd());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getAddvcdName())) {
            o.setAddvcdName(orgVo.getAddvcdName());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getAddvcdFull())) {
            o.setAddvcdFull(orgVo.getAddvcdFull());
        }
        if (BeanUtils.isEmpty((Object)pOrg)) {
            o.setPathName("/" + orgVo.getName());
            o.setPath(orgVo.getDemId() + "." + o.getId() + ".");
        } else {
            o.setPath(pOrg.getPath() + o.getId() + ".");
            o.setPathName(pOrg.getPathName() + "/" + orgVo.getName());
        }
        o.setLimitNum((int)orgVo.getLimitNum());
        o.setExceedLimitNum((int)orgVo.getExceedLimitNum());
        this.create((Model)o);
        return new CommonResult(true, "\u6dfb\u52a0\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteOrg(String codes) throws Exception {
        String[] codeArr;
        if (StringUtils.isEmpty((CharSequence)codes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u4ee3\u7801\u5fc5\u586b\uff01");
        }
        String message = "";
        for (String code : codeArr = codes.split(",")) {
            Org o = this.getByCode(code);
            if (BeanUtils.isEmpty((Object)o)) {
                message = message + "\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff1b";
                continue;
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"PARENT_ID_", (Object)o.getId());
            int num = ((OrgDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            if (num > 0) {
                throw new RuntimeException("\u5220\u9664\u7ec4\u7ec7\u5931\u8d25\uff0c\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u7ec4\u7ec7\u4e0b\u8fd8\u6709\u5b50\u7ec4\u7ec7\uff01");
            }
            QueryWrapper queryUserWrapper = new QueryWrapper();
            queryUserWrapper.eq((Object)"ORG_ID_", (Object)o.getId());
            int usernum = this.orgUserDao.selectCount((Wrapper)queryUserWrapper);
            if (usernum > 0) {
                throw new RuntimeException("\u5220\u9664\u7ec4\u7ec7\u5931\u8d25\uff0c\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u7ec4\u7ec7\u4e0b\u8fd8\u6709\u4eba\u5458\uff01");
            }
            String[] ids = new String[]{o.getId()};
            this.removeByIds(ids);
        }
        message = StringUtils.isEmpty((CharSequence)message) ? "\u5220\u9664\u7ec4\u7ec7\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u6210\u529f\uff0c\u5176\u4e2d" + message;
        return new CommonResult(true, message, (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> updateOrg(OrgVo orgVo) throws Exception {
        int num;
        QueryWrapper queryWrapper;
        String orgKind;
        if (orgVo.getExceedLimitNum() == 1 && orgVo.getLimitNum() < orgVo.getNowNum()) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u5f53\u524d\u7ec4\u7ec7\u4eba\u6570\u8d85\u51fa\u9650\u7f16\u4eba\u6570\uff01");
        }
        if (StringUtil.isEmpty((String)orgVo.getCode())) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        Org o = this.getByCode(orgVo.getCode());
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u3010" + orgVo.getCode() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff01");
        }
        Demension dem = (Demension)this.demensionService.get((Serializable)((Object)orgVo.getDemId()));
        if (StringUtil.isNotEmpty((String)orgVo.getDemId()) && BeanUtils.isEmpty((Object)dem)) {
            throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684demId\u3010" + orgVo.getDemId() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
        }
        Org pOrg = null;
        if (StringUtil.isNotEmpty((String)orgVo.getParentId()) && !"0".equals(orgVo.getParentId())) {
            pOrg = this.get((Serializable)((Object)orgVo.getParentId()));
            if (BeanUtils.isEmpty((Object)pOrg)) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684parentId\u3010" + orgVo.getDemId() + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            if (StringUtil.isNotEmpty((String)orgVo.getDemId()) && BeanUtils.isNotEmpty((Object)pOrg) && !pOrg.getDemId().equals(orgVo.getDemId())) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165demId\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6id\u4e0d\u4e00\u81f4\uff01");
            }
        }
        if ((orgKind = orgVo.getOrgKind()).equals("ogn")) {
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"ORG_KIND_", (Object)"dept")).eq((Object)"ID_", (Object)orgVo.getParentId());
            num = ((OrgDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            if (num > 0) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u8be5\u7ec4\u7ec7\u7684\u7236\u7ea7\u662f\u90e8\u95e8\uff0c\u8be5\u7ec4\u7ec7\u4e0d\u80fd\u4fee\u6539\u4e3a\u673a\u6784\uff01");
            }
        }
        if (orgKind.equals("dept")) {
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"ORG_KIND_", (Object)"ogn")).eq((Object)"PARENT_ID_", (Object)o.getId());
            num = ((OrgDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
            if (num > 0) {
                throw new RuntimeException("\u66f4\u65b0\u7ec4\u7ec7\u5931\u8d25\uff0c\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u6709\u5b50\u7ec4\u7ec7\u4e86\uff0c\u4e0d\u80fd\u4fee\u6539\u4e3a\u90e8\u95e8\uff01");
            }
        }
        if (StringUtil.isNotEmpty((String)orgVo.getName())) {
            o.setName(orgVo.getName());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getGrade())) {
            o.setGrade(orgVo.getGrade());
        }
        if (BeanUtils.isNotEmpty((Object)orgVo.getOrderNo())) {
            o.setOrderNo(orgVo.getOrderNo());
        }
        if (BeanUtils.isNotEmpty((Object)orgVo.getOrgKind())) {
            o.setOrgKind(orgVo.getOrgKind());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getAddvcd())) {
            o.setAddvcd(orgVo.getAddvcd());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getAddvcdName())) {
            o.setAddvcdName(orgVo.getAddvcdName());
        }
        if (StringUtil.isNotEmpty((String)orgVo.getAddvcdFull())) {
            o.setAddvcdFull(orgVo.getAddvcdFull());
        }
        if (BeanUtils.isEmpty((Object)pOrg)) {
            if (StringUtil.isNotEmpty((String)orgVo.getName())) {
                o.setPathName("/" + orgVo.getName());
            }
            if (StringUtil.isNotEmpty((String)orgVo.getDemId())) {
                o.setPath(orgVo.getDemId() + "." + o.getId() + ".");
                o.setDemId(orgVo.getDemId());
            }
        } else {
            o.setPath(pOrg.getPath() + o.getId() + ".");
            o.setPathName(pOrg.getPathName() + "/" + orgVo.getName());
            o.setDemId(orgVo.getDemId());
            o.setParentId(pOrg.getId());
        }
        o.setLimitNum((int)orgVo.getLimitNum());
        o.setExceedLimitNum((int)orgVo.getExceedLimitNum());
        this.updateByOrg(o);
        return new CommonResult(true, "\u7ec4\u7ec7\u66f4\u65b0\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public Org getOrg(String code) throws Exception {
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u7f16\u7801code\u5fc5\u586b\uff01");
        }
        Org o = this.getByCode(code);
        if (BeanUtils.isEmpty((Object)o)) {
            return o;
        }
        o = this.get((Serializable)((Object)o.getId()));
        String pId = o.getParentId();
        String demId = o.getDemId();
        Demension d = (Demension)this.demensionService.get((Serializable)((Object)demId));
        if (d != null && !StringUtil.isEmpty((String)d.getDemCode())) {
            o.setDemCode(d.getDemCode());
        }
        if ("0".equals(pId) || StringUtil.isEmpty((String)pId)) {
            o.setParentOrgName(d.getDemName());
        } else {
            o.setParentOrgName(this.get((Serializable)((Object)pId)).getName());
        }
        List<OrgParams> params = this.getOrgParams(o.getCode());
        if (BeanUtils.isNotEmpty(params)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (OrgParams param : params) {
                map.put(param.getAlias(), param.getValue());
            }
            o.setParams(map);
        }
        return o;
    }

    @Override
    @Transactional
    public CommonResult<String> saveOrgParams(String orgCode, List<ObjectNode> params) throws Exception {
        if (StringUtils.isEmpty((CharSequence)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        this.orgParamsService.removeByOrgId(org.getId());
        for (ObjectNode o : params) {
            String key = o.get("alias").asText();
            Params p = this.paramsSerivce.getByAlias(key);
            if (BeanUtils.isEmpty((Object)p)) {
                throw new RuntimeException("\u3010" + key + "\u3011\u53c2\u6570key\u4e0d\u5b58\u5728\uff01");
            }
            if (p.getType().equals("2")) continue;
            throw new RuntimeException("\u3010" + key + "\u3011\u5bf9\u5e94\u7684\u3010\u7528\u6237\u7ec4\u7ec7\u6269\u5c55\u53c2\u6570\u3011\u7c7b\u578b\u4e0d\u662f\u3010\u7ec4\u7ec7\u53c2\u6570\u3011\u7c7b\u578b\uff01");
        }
        try {
            this.orgParamsService.saveParams(org.getId(), params);
        }
        catch (Exception e) {
            System.out.println(e);
            if (e.getMessage().indexOf("ORA-12899") > -1) {
                throw new RuntimeException("\u4fdd\u5b58\u5931\u8d25\uff0c\u53c2\u6570\u503c\u8fc7\u957f");
            }
            throw e;
        }
        return new CommonResult(true, "\u4fdd\u5b58\u7ec4\u7ec7\u53c2\u6570\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<OrgParams> getOrgParams(String orgCode) throws Exception {
        Org o = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        List<OrgParams> list = this.orgParamsService.getByOrgId(o.getId());
        return list;
    }

    @Override
    public CommonResult<OrgParams> getParamByAlias(String orgCode, String alias) throws Exception {
        Org o = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        OrgParams p = this.orgParamsService.getByOrgIdAndAlias(o.getId(), alias);
        if (BeanUtils.isEmpty((Object)p)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u53c2\u6570\u522b\u540d\u3010" + alias + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u4fe1\u606f");
        }
        return new CommonResult(true, "\u83b7\u53d6\u5b8c\u6bd5\uff01", (Object)p);
    }

    @Override
    @Transactional
    public CommonResult<String> addOrgUser(OrgUserVo orgUserVo) throws Exception {
        if (StringUtil.isEmpty((String)orgUserVo.getAccount())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7528\u6237\u5e10\u53f7account\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgUserVo.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        User u = this.userService.getByAccount(orgUserVo.getAccount());
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        if (BeanUtils.isNotEmpty((Object)orgUserVo.getIsCharge()) && orgUserVo.getIsCharge() == 1 && orgUserVo.getIsCharge() == 0) {
            throw new RuntimeException("isCharge\u53ea\u80fd\u4e3a0\u62161");
        }
        if (BeanUtils.isNotEmpty((Object)orgUserVo.getIsMaster()) && orgUserVo.getIsMaster() == 1 && orgUserVo.getIsMaster() == 0) {
            throw new RuntimeException("isMaster\u53ea\u80fd\u4e3a0\u62161");
        }
        Org o = this.getByCode(orgUserVo.getOrgCode());
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", u.getId());
        map.put("orgId", o.getId());
        List<OrgUser> list = this.orgUserService.getByParms(map);
        if (BeanUtils.isEmpty(list)) {
            OrgUser orgUser = new OrgUser();
            orgUser.setId(UniqueIdUtil.getSuid());
            orgUser.setUserId(u.getId());
            orgUser.setOrgId(o.getId());
            orgUser.setIsRelActive(1);
            if (BeanUtils.isEmpty((Object)orgUserVo.getIsCharge())) {
                orgUser.setIsCharge(0);
            } else {
                orgUser.setIsCharge(orgUserVo.getIsCharge());
            }
            if (BeanUtils.isEmpty((Object)orgUserVo.getIsMaster())) {
                orgUser.setIsMaster(0);
            } else {
                List<OrgUser> l;
                orgUser.setIsMaster(orgUserVo.getIsMaster());
                if (orgUserVo.getIsMaster() == 1 && BeanUtils.isNotEmpty(l = this.orgUserService.getOrgUserMaster(u.getId(), o.getDemId()))) {
                    OrgUser ou = l.get(0);
                    ou.setIsMaster(0);
                    this.orgUserService.update((Model)ou);
                }
            }
            this.orgUserService.create((Model)orgUser);
        } else {
            User user = this.userService.getByAccount(orgUserVo.getAccount());
            Org org = this.getByCode(orgUserVo.getOrgCode());
        }
        return new CommonResult(true, "\u52a0\u5165\u7528\u6237\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delOrgUser(String ids) throws Exception {
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException("id\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] orgUserIds = ids.split(",");
        Boolean isDele = false;
        StringBuilder str = new StringBuilder();
        for (String id : orgUserIds) {
            OrgUser obj = (OrgUser)this.orgUserService.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)obj)) {
                this.orgUserService.removeUserMainOrgCache(obj.getUserId());
                this.orgUserService.removeUserMainOrgCache("", obj.getUserId());
                this.userUnderService.delByUserIdAndOrgId(obj.getUserId(), obj.getOrgId());
                isDele = true;
                continue;
            }
            str.append(id);
            str.append("\uff0c");
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u7528\u6237\u53d6\u6d88\u52a0\u5165\u6210\u529f\uff01" : "\u90e8\u5206\u7528\u6237\u53d6\u6d88\u52a0\u5165\u6210\u529f\uff0cid\u4e3a\uff1a" + str + "\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01";
        this.orgUserService.removeByIds(orgUserIds);
        return new CommonResult(isDele.booleanValue(), msg, (Object)"");
    }

    @Override
    public CommonResult<Boolean> getUserIsMaster(String account, String demCode) throws Exception {
        if (StringUtils.isEmpty((CharSequence)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7528\u6237\u5e10\u53f7account\u5fc5\u586b\uff01");
        }
        User u = this.userService.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684account\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f");
        }
        if (StringUtils.isEmpty((CharSequence)demCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ef4\u5ea6\u7f16\u7801demCode\u5fc5\u586b\uff01");
        }
        Demension d = this.demensionService.getByCode(demCode);
        if (BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684demCode\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f");
        }
        List<OrgUser> orgUsers = this.orgUserService.getOrgUserMaster(u.getId(), d.getId());
        if (BeanUtils.isEmpty(orgUsers)) {
            return new CommonResult(true, "\u7528\u6237\u5728\u3010" + d.getDemCode() + "\u3011\u4e0b\u6ca1\u6709\u4e3b\u7ec4\u7ec7", (Object)false);
        }
        return new CommonResult(true, "\u7528\u6237\u5728\u3010" + d.getDemCode() + "\u3011\u4e0b\u5b58\u5728\u4e3b\u7ec4\u7ec7", (Object)true);
    }

    @Override
    @Transactional
    public CommonResult<String> setMaster(String account, String postCode) throws Exception {
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)post)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5c97\u4f4d\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f");
        }
        User u = this.userService.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
        }
        OrgUser orgUser = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
        if (BeanUtils.isEmpty((Object)orgUser)) {
            throw new RuntimeException("\u5bf9\u4e0d\u8d77\uff0c\u8be5\u7528\u6237\u76ee\u524d\u8fd8\u4e0d\u662f\u8be5\u5c97\u4f4d\u4e0b\u7684\u4eba\u5458\uff01");
        }
        this.orgUserService.setMaster(orgUser.getId());
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<OrgTree> getTreeDataByDem(String demCode, String pOrgCode, String orgKind) throws Exception {
        if (StringUtil.isEmpty((String)demCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ef4\u5ea6\u7f16\u7801demCode\u5fc5\u586b");
        }
        Demension d = this.demensionService.getByCode(demCode);
        if (BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684demCode\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6");
        }
        Org p = this.getByCode(pOrgCode);
        if (StringUtil.isNotEmpty((String)pOrgCode) && BeanUtils.isEmpty((Object)p)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684pOrgCode\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7");
        }
        ArrayList<OrgTree> orgTree = new ArrayList<OrgTree>();
        String pId = "0";
        if (BeanUtils.isNotEmpty((Object)p)) {
            pId = p.getId();
        }
        QueryFilter filter = QueryFilter.build();
        PageBean page = new PageBean();
        page.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        filter.setPageBean(page);
        filter.addParams("demId", (Object)d.getId());
        List<Org> groupList = this.getByParentAndDem(filter);
        ArrayList<Org> rtnList = new ArrayList<Org>();
        OrgManagerImpl.getChild(groupList, pId, rtnList);
        for (Org group : rtnList) {
            OrgTree groupTree = new OrgTree(group);
            orgTree.add(groupTree);
        }
        return orgTree;
    }

    @Override
    @Transactional
    public CommonResult<String> setOrgCharge(String account, String orgCode, Boolean isCharge) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        Org o = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u83b7\u53d6\u5230\u7528\u6237\uff01");
        }
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u5e94\u7ec4\u7ec7\uff01");
        }
        List<OrgUser> orgUserList = this.orgUserService.getListByOrgIdUserId(o.getId(), u.getId());
        if (BeanUtils.isEmpty(orgUserList)) {
            throw new RuntimeException("\u7528\u6237\u3010" + account + "\u3011\u4e0e\u7ec4\u7ec7\u3010" + orgCode + "\u3011\u4e0d\u5b58\u5728\u5173\u7cfb");
        }
        this.orgUserService.setCharge(u.getId(), isCharge, o.getId());
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> addUserUnders(UserUnderVo userUnderObj) throws Exception {
        String[] underAccounts;
        if (StringUtil.isEmpty((String)userUnderObj.getUnderAccounts())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u4e0b\u5c5e\u7528\u6237\u5e10\u53f7underAccounts\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)userUnderObj.getAccount())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)userUnderObj.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(userUnderObj.getAccount());
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684account\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = this.getByCode(userUnderObj.getOrgCode());
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684orgCode\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\uff01");
        }
        if (BeanUtils.isEmpty(this.orgUserService.getListByOrgIdUserId(o.getId(), u.getId()))) {
            return new CommonResult(false, "\u7528\u6237\u3010" + u.getFullname() + "\u3011\u4e0e\u7ec4\u7ec7\u3010" + o.getName() + "\u3011\u4e0d\u5b58\u5728\u5173\u7cfb", (Object)"");
        }
        for (String a : underAccounts = userUnderObj.getUnderAccounts().split(",")) {
            User under = this.userService.getByAccount(a);
            if (BeanUtils.isEmpty((Object)under)) {
                throw new RuntimeException("\u6839\u636e\u5e10\u53f7\u3010" + a + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
            }
            if (BeanUtils.isEmpty(this.orgUserService.getListByOrgIdUserId(o.getId(), under.getId()))) {
                return new CommonResult(false, "\u7528\u6237\u3010" + under.getFullname() + "\u3011\u4e0e\u7ec4\u7ec7\u3010" + o.getName() + "\u3011\u4e0d\u5b58\u5728\u5173\u7cfb", (Object)"");
            }
            if (userUnderObj.getAccount().equals(a)) {
                throw new RuntimeException("\u7528\u6237\u3010" + a + "\u3011\u4e0d\u80fd\u5c06\u81ea\u5df1\u6dfb\u52a0\u4e3a\u81ea\u5df1\u7684\u4e0b\u5c5e\uff01");
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("userId", under.getId());
            m.put("orgId", o.getId());
            m.put("underUserId", u.getId());
            List<UserUnder> list = this.userUnderService.getUserUnder(m);
            if (BeanUtils.isNotEmpty(list)) {
                throw new RuntimeException("\u7528\u6237\u3010" + under.getAccount() + "\u3011\u5728\u7ec4\u7ec7\u3010" + o.getCode() + "\u3011\u4e0b\u662f\u7528\u6237\u3010" + u.getAccount() + "\u3011\u7684\u4e0a\u7ea7");
            }
            HashMap<String, Object> m1 = new HashMap<String, Object>();
            m1.put("noUserId", u.getId());
            m1.put("orgId", o.getId());
            m1.put("underUserId", under.getId());
            List<UserUnder> list1 = this.userUnderService.getUserUnder(m1);
            if (BeanUtils.isNotEmpty(list1)) {
                User supperUser = (User)this.userService.get((Serializable)((Object)list1.get(0).getUserId()));
                throw new RuntimeException("\u7528\u6237\u3010" + a + "\u3011\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u5df2\u6709\u4e0a\u7ea7" + "\u3010" + supperUser.getFullname() + "\u3011\uff0c\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u80fd\u518d\u8bbe\u7f6e\u5176\u4ed6\u4e0a\u7ea7\u3002");
            }
            HashMap<String, Object> m2 = new HashMap<String, Object>();
            m2.put("userId", u.getId());
            m2.put("orgId", o.getId());
            m2.put("underUserId", under.getId());
            List<UserUnder> list2 = this.userUnderService.getUserUnder(m2);
            if (BeanUtils.isNotEmpty(list2)) continue;
            UserUnder userUnder = new UserUnder();
            userUnder.setId(UniqueIdUtil.getSuid());
            userUnder.setUserId(u.getId());
            userUnder.setUnderUserId(under.getId());
            userUnder.setUnderUserName(under.getFullname());
            userUnder.setOrgId(o.getId());
            this.userUnderService.create((Model)userUnder);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u4e0b\u5c5e\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delUserUnders(String account, String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684account\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684orgCode\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\uff01");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", u.getId());
        params.put("orgId", o.getId());
        List<UserUnder> l = this.userUnderService.getUserUnder(params);
        if (BeanUtils.isEmpty(l)) {
            return new CommonResult(false, "\u7528\u6237\u3010" + u.getFullname() + "\u3011\u5728\u7ec4\u7ec7\u3010" + o.getName() + "\u3011\u4e0b\u6ca1\u6709\u4e0b\u7ea7", (Object)"");
        }
        this.userUnderService.delByUserIdAndOrgId(u.getId(), o.getId());
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<UserVo> getUserUnders(String account, String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684account\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684orgCode\u6ca1\u6709\u627e\u5230\u7ec4\u7ec7\uff01");
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("userId", u.getId());
        m.put("orgId", o.getId());
        List<UserUnder> list = this.userUnderService.getUserUnder(m);
        ArrayList<User> userList = new ArrayList<User>();
        for (UserUnder under : list) {
            User user = (User)this.userService.get((Serializable)((Object)under.getUnderUserId()));
            userList.add(user);
        }
        return OrgUtil.convertToUserVoList(userList);
    }

    @Override
    @Transactional
    public CommonResult<String> saveOrgAuth(OrgAuthVo orgAuthVo) throws Exception {
        List<OrgAuth> list;
        OrgAuth a;
        if (StringUtil.isEmpty((String)orgAuthVo.getAccount())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7528\u6237\u5e10\u53f7\u5fc5\u586b\uff01");
        }
        User u = this.userService.getByAccount(orgAuthVo.getAccount());
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        if (StringUtil.isEmpty((String)orgAuthVo.getOrgCode())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ec4\u7ec7\u4ee3\u7801\u5fc5\u586b\uff01");
        }
        Org o = this.getByCode(orgAuthVo.getOrgCode());
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff01");
        }
        if (StringUtil.isEmpty((String)orgAuthVo.getDemCode())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1a\u7ef4\u5ea6\u7f16\u7801\u5fc5\u586b\uff01");
        }
        Demension d = this.demensionService.getByCode(orgAuthVo.getDemCode());
        if (BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u7ef4\u5ea6\uff01");
        }
        if (!o.getDemId().equals(d.getId())) {
            throw new RuntimeException("\u8f93\u5165\u7684\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4e0e\u8f93\u5165\u7684\u7ef4\u5ea6\u4e0d\u4e00\u81f4\uff01");
        }
        if (StringUtil.isEmpty((String)orgAuthVo.getId()) ? BeanUtils.isNotEmpty((Object)(a = this.orgAuthService.getByOrgIdAndUserId(o.getId(), u.getId()))) : (list = this.orgAuthService.getListByOrgIdAndUserId(o.getId(), u.getId())) != null && list.size() > 1) {
            throw new RuntimeException("\u7528\u6237\u5728\u8be5\u7ec4\u7ec7\u5df2\u7ecf\u662f\u5206\u7ea7\u7ba1\u7406\u5458\uff01");
        }
        OrgAuth auth = new OrgAuth();
        if (StringUtil.isEmpty((String)orgAuthVo.getId())) {
            boolean userRoleFlag;
            auth.setId(UniqueIdUtil.getSuid());
            auth.setOrgId(o.getId());
            auth.setUserId(u.getId());
            auth.setOrgPerms(orgAuthVo.getOrgPerms());
            auth.setUserPerms(orgAuthVo.getUserPerms());
            auth.setPosPerms(orgAuthVo.getPosPerms());
            auth.setOrgauthPerms(orgAuthVo.getOrgauthPerms());
            auth.setLayoutPerms(orgAuthVo.getLayoutPerms());
            auth.setDemId(d.getId());
            this.orgAuthService.create((Model)auth);
            Role role = this.roleService.getByAlias("fjRole");
            if (BeanUtils.isNotEmpty((Object)role) && !(userRoleFlag = this.userRoleManager.checkSameUserRole(u.getId(), role.getId()))) {
                UserRole userRole = new UserRole();
                userRole.setId(UniqueIdUtil.getSuid());
                userRole.setRoleId(role.getId());
                userRole.setUserId(u.getId());
                this.userRoleManager.save(userRole);
            }
            return new CommonResult(true, "\u6dfb\u52a0\u5206\u7ea7\u7ba1\u7406\u6210\u529f\uff01", (Object)"");
        }
        auth.setId(orgAuthVo.getId());
        auth.setOrgId(o.getId());
        auth.setUserId(u.getId());
        auth.setOrgPerms(orgAuthVo.getOrgPerms());
        auth.setUserPerms(orgAuthVo.getUserPerms());
        auth.setPosPerms(orgAuthVo.getPosPerms());
        auth.setOrgauthPerms(orgAuthVo.getOrgauthPerms());
        auth.setLayoutPerms(orgAuthVo.getLayoutPerms());
        auth.setDemId(d.getId());
        this.orgAuthService.update((Model)auth);
        return new CommonResult(true, "\u66f4\u65b0\u5206\u7ea7\u7ba1\u7406\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteOrgAuth(String ids) throws Exception {
        String[] idArr;
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u5206\u7ea7\u7ec4\u7ec7\u7ba1\u7406id\u5fc5\u586b");
        }
        for (String id : idArr = ids.split(",")) {
            if (BeanUtils.isEmpty((Object)this.orgAuthService.get((Serializable)((Object)id)))) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5206\u7ea7\u7ec4\u7ec7\u7ba1\u7406id\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff01");
            }
            this.orgAuthService.remove((Serializable)((Object)id));
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public Page<OrgAuth> getOrgAuthList(String account, String orgCode, String demCode) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Org o = null;
        if (StringUtil.isNotEmpty((String)orgCode)) {
            o = this.getByCode(orgCode);
        }
        if (StringUtil.isNotEmpty((String)orgCode) && BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff01");
        }
        Demension de = null;
        if (StringUtil.isNotEmpty((String)demCode)) {
            de = this.demensionService.getByCode(demCode);
        }
        if (StringUtil.isNotEmpty((String)demCode) && BeanUtils.isEmpty((Object)de)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\uff01");
        }
        QueryFilter filter = QueryFilter.build();
        filter.addParams("userId", (Object)u.getId());
        if (BeanUtils.isNotEmpty((Object)o)) {
            filter.addParams("orgId", (Object)o.getId());
        }
        if (BeanUtils.isNotEmpty((Object)de)) {
            filter.addParams("demId", (Object)de.getId());
        }
        Page list = (Page)this.orgAuthService.getAllOrgAuth((QueryFilter<OrgAuth>)filter);
        return list;
    }

    @Override
    public OrgAuth getOrgAuth(String id) throws Exception {
        if (StringUtil.isEmpty((String)id)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u5206\u7ea7\u7ec4\u7ec7\u7ba1\u7406id\u5fc5\u586b");
        }
        if (BeanUtils.isEmpty((Object)this.orgAuthService.get((Serializable)((Object)id)))) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684id\u6570\u636e\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4fe1\u606f");
        }
        OrgAuth orgAuth = (OrgAuth)this.orgAuthService.get((Serializable)((Object)id));
        User user = (User)this.userService.get((Serializable)((Object)orgAuth.getUserId()));
        orgAuth.setUserName(user.getFullname());
        orgAuth.setUserAccount(user.getAccount());
        return orgAuth;
    }

    @Override
    public List<Org> getUserOrgs(String account, String demCode, Boolean isMain) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        User u = this.userService.getByAccount(account);
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
        }
        Demension de = null;
        if (StringUtil.isNotEmpty((String)demCode)) {
            de = this.demensionService.getByCode(demCode);
        }
        if (StringUtil.isNotEmpty((String)demCode) && BeanUtils.isEmpty((Object)de)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ef4\u5ea6\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\uff01");
        }
        List<Org> list = null;
        String demId = null;
        if (BeanUtils.isNotEmpty((Object)de)) {
            demId = de.getId();
        }
        list = BeanUtils.isEmpty((Object)isMain) ? this.getUserOrg(u.getId(), demId, null) : this.getUserOrg(u.getId(), demId, isMain);
        return list;
    }

    @Override
    public List<UserVo> getUsersByOrgCodes(String orgCodes, Boolean isMain) throws Exception {
        String[] orgCodeArr;
        if (StringUtil.isEmpty((String)orgCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u4ee3\u7801orgCodes\u5fc5\u586b\uff01");
        }
        ArrayList<User> list = new ArrayList<User>();
        for (String orgCode : orgCodeArr = orgCodes.split(",")) {
            Org o = this.getByCode(orgCode);
            if (BeanUtils.isEmpty((Object)o)) {
                throw new RuntimeException("\u6839\u636e\u7ec4\u7ec7\u4ee3\u7801\u3010" + orgCode + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            List<User> l = this.userService.getOrgUsers(o.getId(), isMain);
            if (!BeanUtils.isNotEmpty(l)) continue;
            list.addAll(l);
        }
        return OrgUtil.convertToUserVoList(list);
    }

    @Override
    public List<OrgPost> getPostsByOrgCodes(String orgCodes, Boolean isMain) throws Exception {
        String[] orgCodeArr;
        if (StringUtil.isEmpty((String)orgCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u4ee3\u7801orgCodes\u5fc5\u586b\uff01");
        }
        ArrayList<OrgPost> list = new ArrayList<OrgPost>();
        for (String orgCode : orgCodeArr = orgCodes.split(",")) {
            Org o = this.getByCode(orgCode);
            if (BeanUtils.isEmpty((Object)o)) {
                throw new RuntimeException("\u6839\u636e\u7ec4\u7ec7\u4ee3\u7801\u3010" + orgCode + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            List<OrgPost> l = this.orgPostService.getRelCharge(o.getId(), isMain);
            if (!BeanUtils.isNotEmpty(l)) continue;
            list.addAll(l);
        }
        return list;
    }

    @Override
    public List<Org> getByLevel(String level, String demCode) throws Exception {
        if (StringUtil.isEmpty((String)level)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7ea7\u522blevel\u5fc5\u586b\uff01");
        }
        Demension d = null;
        if (StringUtil.isNotEmpty((String)demCode)) {
            d = this.demensionService.getByCode(demCode);
        }
        if (StringUtil.isNotEmpty((String)demCode) && BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u8f93\u5165\u7684\u7ef4\u5ea6\u7f16\u7801demCode\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\uff01");
        }
        QueryFilter filter = QueryFilter.build();
        filter.addParams("grade_", (Object)level);
        if (BeanUtils.isNotEmpty((Object)d)) {
            filter.addParams("dem_id_", (Object)d.getId());
        }
        return this.query(filter).getRows();
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserPost(String accounts, String postCode) throws Exception {
        if (StringUtil.isEmpty((String)accounts)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7528\u6237\u5e10\u53f7accounts\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801postCode\u5fc5\u586b\uff01");
        }
        String[] postCodeArr = postCode.split(",");
        String[] accountArr = accounts.split(",");
        for (String str : postCodeArr) {
            OrgPost post = this.orgPostService.getByCode(str);
            if (BeanUtils.isEmpty((Object)post)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u5c97\u4f4d\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
            }
            Org org = this.get((Serializable)((Object)post.getOrgId()));
            if (postCode.indexOf(",") < 0 && org.getExceedLimitNum() == 1 && org.getLimitNum() != 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgCode", org.getCode());
                map.put("group", "true");
                List<Map<String, Object>> list = this.orgUserService.getUserNumByOrgCode(map);
                if (org.getLimitNum() < list.size() + accountArr.length) {
                    return new CommonResult(false, "\u4eba\u6570\u8d85\u51fa\u7ec4\u7ec7\u4e0a\u9650\uff0c\u4e0d\u4e88\u6dfb\u52a0", null);
                }
            }
            for (String account : accountArr) {
                User u = this.userService.getByAccount(account);
                if (BeanUtils.isEmpty((Object)u)) {
                    throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
                }
                OrgUser ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
                if (BeanUtils.isNotEmpty((Object)ou)) continue;
                ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), "");
                if (BeanUtils.isNotEmpty((Object)ou)) {
                    ou.setRelId(post.getId());
                    this.orgUserService.update((Model)ou);
                    continue;
                }
                ou = new OrgUser();
                ou.setId(UniqueIdUtil.getSuid());
                ou.setUserId(u.getId());
                ou.setIsCharge(0);
                ou.setIsMaster(0);
                ou.setIsRelActive(1);
                ou.setOrgId(post.getOrgId());
                ou.setRelId(post.getId());
                this.orgUserService.create((Model)ou);
            }
        }
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> saveUserPosts(String account, String postCodes) throws Exception {
        String[] postCodesArr;
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7528\u6237\u5e10\u53f7accounts\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)postCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801postCode\u5fc5\u586b\uff01");
        }
        for (String postCode : postCodesArr = postCodes.split(",")) {
            User u;
            OrgPost post = this.orgPostService.getByCode(postCode);
            if (BeanUtils.isEmpty((Object)post)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u5c97\u4f4d\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
            }
            Org org = this.get((Serializable)((Object)post.getOrgId()));
            if (org.getExceedLimitNum() == 1 && org.getLimitNum() != 0) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgCode", org.getCode());
                map.put("group", "true");
                List<Map<String, Object>> list = this.orgUserService.getUserNumByOrgCode(map);
                if (org.getLimitNum() <= list.size()) {
                    return new CommonResult(false, "\u4eba\u6570\u8d85\u51fa\u7ec4\u7ec7\u4e0a\u9650\uff0c\u4e0d\u4e88\u6dfb\u52a0", null);
                }
            }
            if (BeanUtils.isEmpty((Object)(u = this.userService.getByAccount(account)))) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
            }
            OrgUser ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"ORG_ID_", (Object)post.getOrgId());
            queryWrapper.eq((Object)"USER_ID_", (Object)u.getId());
            List list = this.orgUserService.listMaps((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)ou)) {
                throw new BaseException("\u5f53\u524d\u7528\u6237\u5df2\u5728\u3010" + post.getName() + "\u3011\u7684\u5c97\u4f4d\u4e0a\uff01");
            }
            for (int i = 0; i < list.size(); ++i) {
                if (!ObjectUtils.isEmpty(((Map)list.get(i)).get("relId"))) continue;
                if (BeanUtils.isNotEmpty(((Map)list.get(i)).get("ID_"))) {
                    this.delOrgUser(((Map)list.get(i)).get("ID_").toString());
                    break;
                }
                this.delOrgUser(((Map)list.get(i)).get("id_").toString());
                break;
            }
            ou = new OrgUser();
            ou.setId(UniqueIdUtil.getSuid());
            ou.setUserId(u.getId());
            ou.setIsCharge(0);
            ou.setIsMaster(0);
            ou.setIsRelActive(1);
            ou.setOrgId(post.getOrgId());
            ou.setRelId(post.getId());
            this.orgUserService.create((Model)ou);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> delUserPost(String accounts, String postCode) throws Exception {
        String[] accountArr;
        if (StringUtil.isEmpty((String)accounts)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7528\u6237\u5e10\u53f7accounts\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801postCode\u5fc5\u586b\uff01");
        }
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)post)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u5c97\u4f4d\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
        }
        for (String account : accountArr = accounts.split(",")) {
            User u = this.userService.getByAccount(account);
            if (BeanUtils.isEmpty((Object)u)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u3010" + account + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237");
            }
            OrgUser ou = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
            if (BeanUtils.isEmpty((Object)ou)) {
                throw new RuntimeException("\u7528\u6237\u3010" + account + "\u3011\u4e0d\u5728\u5c97\u4f4d\u3010" + post.getCode() + "\u3011\u4e0b");
            }
            this.orgUserService.remove((Serializable)((Object)ou.getId()));
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> saveOrgPost(OrgPostVo orgPostVo) throws Exception {
        List<OrgPost> l;
        if (StringUtil.isEmpty((String)orgPostVo.getCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801code\u5fc5\u586b\uff01");
        }
        if (orgPostVo.getCode().contains(",")) {
            throw new RuntimeException("\u6dfb\u52a0\u5c97\u4f4d\u5931\u8d25\uff0c\u5c97\u4f4d\u7f16\u7801\u4e0d\u5141\u8bb8\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getName())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u540d\u79f0name\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getJobCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u804c\u52a1\u4ee3\u7801jobCode\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u4ee3\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org o = this.getByCode(orgPostVo.getOrgCode());
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        OrgJob job = this.orgJobService.getByCode(orgPostVo.getJobCode());
        if (BeanUtils.isEmpty((Object)job)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u804c\u52a1\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u804c\u52a1\u4fe1\u606f\uff01");
        }
        if (this.orgPostService.getCountByCode(orgPostVo.getCode()) > 0) {
            throw new RuntimeException("\u5c97\u4f4d\u7f16\u7801\u3010" + orgPostVo.getCode() + "\u3011\u5df2\u7ecf\u5b58\u5728\u7cfb\u7edf\u4e2d\uff01");
        }
        OrgPost rel = new OrgPost();
        rel.setId(UniqueIdUtil.getSuid());
        rel.setName(orgPostVo.getName());
        rel.setCode(orgPostVo.getCode());
        rel.setRelDefId(job.getId());
        rel.setOrgId(o.getId());
        rel.setOrgCode(o.getCode());
        rel.setOrgName(o.getName());
        rel.setIsCharge(orgPostVo.getIsCharge());
        if (orgPostVo.getIsCharge() == 1 && BeanUtils.isNotEmpty(l = this.orgPostService.getRelCharge(o.getId(), true))) {
            OrgPost p = l.get(0);
            p.setIsCharge(0);
            this.orgPostService.update((Model)p);
        }
        this.orgPostService.create((Model)rel);
        return new CommonResult(true, "\u6dfb\u52a0\u5c97\u4f4d\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> deleteOrgPost(String postCodes) throws Exception {
        String[] codeArr;
        if (StringUtil.isEmpty((String)postCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u7f16\u7801postCodes\u5fc5\u586b\uff01");
        }
        for (String code : codeArr = postCodes.split(",")) {
            OrgPost rel = this.orgPostService.getByCode(code);
            if (BeanUtils.isEmpty((Object)rel)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5c97\u4f4d\u7f16\u7801\u3010" + code + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgId", rel.getOrgId());
            map.put("relId", rel.getId());
            List<OrgUser> orgUsers = this.orgUserService.getByParms(map);
            if (BeanUtils.isNotEmpty(orgUsers)) {
                throw new RuntimeException("\u5c97\u4f4d\u3010" + rel.getName() + "\u3011\u4e0b\u8fd8\u5b58\u5728\u5206\u914d\u7528\u6237\uff0c\u8bf7\u5220\u9664\u7528\u6237\u5728\u8fdb\u884c\u64cd\u4f5c\uff01");
            }
            String[] ids = new String[]{rel.getId()};
            this.orgPostService.removeByIds(ids);
        }
        return new CommonResult(true, "\u5220\u9664\u5c97\u4f4d\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> setPostMaster(String postCode, Boolean isMain) throws Exception {
        if (StringUtil.isEmpty((String)postCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u7f16\u7801postCode\u5fc5\u586b\uff01");
        }
        if (BeanUtils.isEmpty((Object)isMain)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u662f\u5426\u8d23\u4efb\u5c97\u4f4disMain\u5fc5\u586b\uff01");
        }
        OrgPost post = this.orgPostService.getByCode(postCode);
        if (BeanUtils.isEmpty((Object)post)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5c97\u4f4d\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\uff01");
        }
        if (isMain.booleanValue()) {
            this.orgPostService.cancelRelCharge(post.getOrgId());
        }
        this.orgPostService.setRelCharge(post.getId(), isMain);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> setUserPostDueTime(PostDueVo postDueVo) throws Exception {
        LocalDateTime endDate;
        LocalDateTime startDate;
        if (StringUtil.isEmpty((String)postDueVo.getCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u7f16\u7801code\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)postDueVo.getAccount())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7528\u6237\u5e10\u53f7account\u5fc5\u586b\uff01");
        }
        if (BeanUtils.isEmpty((Object)postDueVo.getEndDate()) && BeanUtils.isEmpty((Object)postDueVo.getStartDate())) {
            throw new RuntimeException("\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\uff01");
        }
        OrgPost post = this.orgPostService.getByCode(postDueVo.getCode());
        if (BeanUtils.isEmpty((Object)post)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u5c97\u4f4d\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d\u4fe1\u606f\uff01");
        }
        User u = this.userService.getByAccount(postDueVo.getAccount());
        if (BeanUtils.isEmpty((Object)u)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7528\u6237\u5e10\u53f7\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f\uff01");
        }
        OrgUser orgUser = this.orgUserService.getOrgUser(post.getOrgId(), u.getId(), post.getId());
        if (BeanUtils.isEmpty((Object)orgUser)) {
            throw new RuntimeException("\u7528\u6237\u4e0e\u8be5\u5c97\u4f4d\u6ca1\u5173\u7cfb\uff0c\u4e0d\u80fd\u8bbe\u7f6e\uff01");
        }
        if (StringUtil.isNotEmpty((String)postDueVo.getStartDate()) && StringUtil.isNotEmpty((String)postDueVo.getEndDate()) && DateUtil.getTime((LocalDateTime)(startDate = DateFormatUtil.parse((String)postDueVo.getStartDate())), (LocalDateTime)(endDate = DateFormatUtil.parse((String)postDueVo.getEndDate()))) < 0L) {
            throw new RuntimeException("\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff01");
        }
        if (StringUtil.isNotEmpty((String)postDueVo.getStartDate())) {
            orgUser.setStartDate(DateFormatUtil.parse((String)postDueVo.getStartDate()));
        } else {
            orgUser.setStartDate(null);
        }
        if (StringUtil.isNotEmpty((String)postDueVo.getEndDate())) {
            orgUser.setEndDate(DateFormatUtil.parse((String)postDueVo.getEndDate()));
        } else {
            orgUser.setEndDate(null);
        }
        this.orgUserService.update((Model)orgUser);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> validOrgUser() throws Exception {
        this.orgUserService.syncValidOrgUser();
        return new CommonResult(true, "\u6821\u9a8c\u6210\u529f\uff01", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> addOrgRole(OrgRoleVo orgRoleVo) throws Exception {
        String[] roleCodes;
        if (StringUtil.isEmpty((String)orgRoleVo.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgRoleVo.getOrgCode());
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        if (StringUtil.isEmpty((String)orgRoleVo.getRoleCodes())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u89d2\u8272\u7f16\u7801roleCodes\u5fc5\u586b\uff01");
        }
        for (String rCode : roleCodes = orgRoleVo.getRoleCodes().split(",")) {
            Role r = this.roleService.getByAlias(rCode);
            if (BeanUtils.isEmpty((Object)r) && BeanUtils.isEmpty((Object)(r = (Role)this.roleService.get((Serializable)((Object)rCode))))) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u89d2\u8272\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
            }
            if (orgRoleVo.getIsInherit() > 0) {
                this.orgRoleService.addOrgRole(org.getId(), r, 1);
                continue;
            }
            this.orgRoleService.addOrgRole(org.getId(), r, 0);
        }
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public void delOrgRoleByCode(String orgCode, String roleCodes) throws Exception {
        String[] roleCodeArr;
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        if (StringUtil.isEmpty((String)roleCodes)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u89d2\u8272\u7f16\u7801roleCodes\u5fc5\u586b\uff01");
        }
        for (String rCode : roleCodeArr = roleCodes.split(",")) {
            Role r = this.roleService.getByAlias(rCode);
            if (BeanUtils.isEmpty((Object)r)) {
                throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u89d2\u8272\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u89d2\u8272\u4fe1\u606f\uff01");
            }
            this.orgRoleService.delByOrgIdAndRoleId(org.getId(), r.getId());
        }
    }

    @Override
    @Transactional
    public CommonResult<String> delOrgRoleById(String ids) throws Exception {
        String[] roleId;
        if (StringUtil.isEmpty((String)ids)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u89d2\u8272ID\u5fc5\u586b\uff01");
        }
        for (String id : roleId = ids.split(",")) {
            this.orgRoleService.remove((Serializable)((Object)id));
        }
        return new CommonResult(true, "\u5220\u9664\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public void delAllOrgRole(String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        this.orgRoleService.delByOrgIdAndRoleId(org.getId(), null);
    }

    @Override
    public List<Role> getOrgRoleByCode(String orgCode) throws Exception {
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u7f16\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org org = this.getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u7f16\u7801\uff0c\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        return this.getRolesByOrgId(org.getId());
    }

    public List<Role> getRolesByOrgId(String orgId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        List<Role> roleList = this.roleService.getOrgRoleList(map);
        if (BeanUtils.isNotEmpty(roleList)) {
            return roleList;
        }
        roleList = new ArrayList<Role>();
        String path = this.getPathByOrgId(orgId);
        if (StringUtil.isEmpty((String)path)) {
            return roleList;
        }
        String[] aryPath = path.split("[.]");
        for (int i = aryPath.length - 1; i >= 0; --i) {
            String tmpOrgId = aryPath[i];
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("orgId", tmpOrgId);
            m.put("isInherit", 1);
            roleList = this.roleService.getOrgRoleList(m);
            if (BeanUtils.isNotEmpty(roleList)) break;
        }
        return roleList;
    }

    private String getPathByOrgId(String orgId) {
        Org sysOrg = this.get((Serializable)((Object)orgId));
        if (sysOrg == null) {
            return "";
        }
        String path = sysOrg.getPath();
        if (StringUtil.isEmpty((String)path)) {
            return "";
        }
        path = path.replace("." + orgId + ".", "");
        int pos = path.indexOf(".");
        path = path.substring(pos + 1);
        return path;
    }

    @Override
    @Transactional
    public CommonResult<String> updateOrgPost(OrgPostVo postVo) throws Exception {
        if (StringUtils.isEmpty((CharSequence)postVo.getCode())) {
            return new CommonResult(false, "\u5c97\u4f4d\u7f16\u7801\u5fc5\u586b", (Object)"");
        }
        if (StringUtils.isEmpty((CharSequence)postVo.getName())) {
            return new CommonResult(false, "\u5c97\u4f4d\u540d\u79f0\u5fc5\u586b", (Object)"");
        }
        OrgPost p = this.orgPostService.getByCode(postVo.getCode());
        if (BeanUtils.isEmpty((Object)p)) {
            return new CommonResult(false, "\u6839\u636e\u8f93\u5165\u7684\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5c97\u4f4d", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)postVo.getOrgCode())) {
            Org o = this.getByCode(postVo.getOrgCode());
            if (!p.getOrgId().equals(o.getId())) {
                p.setOrgId(o.getId());
                if (o.getExceedLimitNum() == 1 && o.getLimitNum() != 0) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("orgCode", o.getCode());
                    map.put("group", "true");
                    List<Map<String, Object>> list = this.orgUserService.getUserNumByOrgCode(map);
                    if (o.getLimitNum() <= list.size()) {
                        return new CommonResult(false, "\u5c97\u4f4d\u7ec4\u7ec7\u6240\u5c5e\u4eba\u6570\u8d85\u51fa\u4e0a\u9650\uff0c\u4fee\u6539\u5931\u8d25", null);
                    }
                    HashSet<String> userIds = new HashSet<String>();
                    for (Map<String, Object> l : list) {
                        userIds.add((String)l.get("userId"));
                    }
                    QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
                    queryFilter.addFilter("pos_id_", (Object)p.getId(), QueryOP.EQUAL);
                    IPage<HashMap<String, Object>> userByGroup = this.orgUserService.getUserByGroup(queryFilter);
                    HashSet<String> addUserIds = new HashSet<String>();
                    if (BeanUtils.isNotEmpty(userByGroup)) {
                        for (Map orgUser : userByGroup.getRecords()) {
                            if (userIds.contains(orgUser.get("userId"))) continue;
                            addUserIds.add((String)orgUser.get("userId"));
                        }
                    }
                    if (o.getLimitNum() <= list.size() + addUserIds.size()) {
                        return new CommonResult(false, "\u5c97\u4f4d\u6240\u5c5e\u7ec4\u7ec7\u4eba\u6570\u8d85\u51fa\u4e0a\u9650\uff0c\u4fee\u6539\u5931\u8d25", null);
                    }
                }
                this.orgUserService.updateUserOrgByPostId(p.getId(), p.getOrgId());
            }
        }
        if (postVo.getIsCharge() == 1) {
            p.setIsCharge(1);
            this.setPostMaster(p.getCode(), true);
        }
        p.setName(postVo.getName());
        this.orgPostService.update((Model)p);
        return new CommonResult(true, "\u66f4\u65b0\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> setUnderUsers(String orgId, String account, String underAccounts) throws Exception {
        String[] underAccountArr;
        User u = this.userService.getByAccount(account);
        Org o = this.get((Serializable)((Object)orgId));
        for (String a : underAccountArr = underAccounts.split(",")) {
            User under = this.userService.getByAccount(a);
            if (BeanUtils.isEmpty((Object)under)) {
                throw new BaseException("\u6839\u636e\u5e10\u53f7\u3010" + a + "\u3011\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\uff01");
            }
            if (account.equals(a)) {
                throw new BaseException("\u7528\u6237\u3010" + under.getFullname() + "\u3011\u4e0d\u80fd\u5c06\u81ea\u5df1\u6dfb\u52a0\u4e3a\u81ea\u5df1\u7684\u4e0b\u5c5e\uff01");
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("userId", under.getId());
            m.put("orgId", o.getId());
            m.put("underUserId", u.getId());
            List<UserUnder> list = this.userUnderService.getUserUnder(m);
            if (BeanUtils.isNotEmpty(list)) {
                throw new BaseException("\u7528\u6237\u3010" + under.getFullname() + "\u3011\u5728\u7ec4\u7ec7\u3010" + o.getCode() + "\u3011\u4e0b\u662f\u7528\u6237\u3010" + u.getFullname() + "\u3011\u7684\u4e0a\u7ea7");
            }
            HashMap<String, Object> m1 = new HashMap<String, Object>();
            m1.put("noUserId", u.getId());
            m1.put("orgId", o.getId());
            m1.put("underUserId", under.getId());
            List<UserUnder> list1 = this.userUnderService.getUserUnder(m1);
            if (BeanUtils.isNotEmpty(list1)) {
                User supperUser = (User)this.userService.get((Serializable)((Object)list1.get(0).getUserId()));
                throw new BaseException("\u7528\u6237\u3010" + under.getFullname() + "\u3011\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u5df2\u6709\u4e0a\u7ea7" + "\u3010" + supperUser.getFullname() + "\u3011\uff0c\u5728\u5f53\u524d\u7ec4\u7ec7\u4e2d\u4e0d\u80fd\u518d\u8bbe\u7f6e\u5176\u4ed6\u4e0a\u7ea7\u3002");
            }
            HashMap<String, Object> m2 = new HashMap<String, Object>();
            m2.put("userId", u.getId());
            m2.put("orgId", o.getId());
            m2.put("underUserId", under.getId());
            List<UserUnder> list2 = this.userUnderService.getUserUnder(m2);
            if (BeanUtils.isNotEmpty(list2)) continue;
            UserUnder userUnder = new UserUnder();
            userUnder.setId(UniqueIdUtil.getSuid());
            userUnder.setUserId(u.getId());
            userUnder.setUnderUserId(under.getId());
            userUnder.setUnderUserName(under.getFullname());
            userUnder.setOrgId(o.getId());
            this.userUnderService.create((Model)userUnder);
            if (!BeanUtils.isEmpty(this.orgUserService.getListByOrgIdUserId(o.getId(), under.getId()))) continue;
            OrgUser ou = new OrgUser();
            ou.setId(UniqueIdUtil.getSuid());
            ou.setUserId(under.getId());
            ou.setOrgId(orgId);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u4e0b\u5c5e\u6210\u529f", (Object)"");
    }

    @Override
    @Transactional
    public CommonResult<String> addUsersForOrg(String orgCode, String accounts) throws Exception {
        String[] accountArr = accounts.split(",");
        Org o = this.getByCode(orgCode);
        for (String a : accountArr) {
            User u = this.userService.getByAccount(a);
            if (BeanUtils.isEmpty((Object)u)) {
                return new CommonResult(false, "\u5e10\u53f7\u3010" + a + "\u3011\u4e0d\u5b58\u5728", (Object)"");
            }
            List<OrgUser> l = this.orgUserService.getListByOrgIdUserId(o.getId(), u.getId());
            if (BeanUtils.isNotEmpty(l)) continue;
            OrgUser ou = new OrgUser();
            ou.setId(UniqueIdUtil.getSuid());
            ou.setIsCharge(0);
            ou.setIsMaster(0);
            ou.setOrgId(o.getId());
            ou.setUserId(u.getId());
            ou.setVersion(1);
            ou.setIsRelActive(1);
            this.orgUserService.create((Model)ou);
        }
        return new CommonResult(true, "\u52a0\u5165\u6210\u529f", (Object)"");
    }

    @Override
    public List<Org> getOrgByTime(OrgExportObject exportObject) throws Exception {
        List<String> ids;
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        List list = new ArrayList();
        if (StringUtil.isNotEmpty((String)exportObject.getDemCodes())) {
            QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            filter.addFilter("CODE_", (Object)exportObject.getDemCodes(), QueryOP.IN, FieldRelation.AND);
            list = this.DemensionManager.queryNoPage(filter);
        }
        if (BeanUtils.isNotEmpty(list)) {
            HashSet<String> demIds = new HashSet<String>();
            for (Demension demension : list) {
                demIds.add(demension.getId());
            }
            queryFilter.addFilter("DEM_ID_", new ArrayList(demIds), QueryOP.IN, FieldRelation.AND);
        }
        if (StringUtil.isNotEmpty((String)exportObject.getOrgCodes()) && BeanUtils.isNotEmpty(ids = this.getOrgAndChildrens(exportObject.getOrgCodes()))) {
            queryFilter.addFilter("ID_", ids, QueryOP.IN, FieldRelation.AND);
        }
        return this.queryNoPage(queryFilter);
    }

    private List<String> getOrgAndChildrens(String orgCodes) {
        QueryFilter filter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        filter.addFilter("CODE_", (Object)orgCodes, QueryOP.IN, FieldRelation.AND);
        List porgs = this.queryNoPage(filter);
        if (BeanUtils.isNotEmpty((Object)porgs)) {
            QueryFilter filter2 = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            filter2.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
            for (Org org : porgs) {
                filter2.addFilter("PATH_", (Object)org.getPath(), QueryOP.RIGHT_LIKE, FieldRelation.OR);
            }
            List childrens = this.queryNoPage(filter2);
            if (BeanUtils.isNotEmpty((Object)childrens)) {
                HashSet<String> ids = new HashSet<String>();
                for (Org org : childrens) {
                    ids.add(org.getId());
                }
                ArrayList<String> list = new ArrayList<String>();
                list.addAll(ids);
                return list;
            }
        }
        return new ArrayList<String>();
    }

    private void addOrgFilter(QueryFilter queryFilter, OrgExportObject exportObject) throws Exception {
        List<Org> orgs;
        if ((StringUtil.isNotEmpty((String)exportObject.getDemCodes()) || StringUtil.isNotEmpty((String)exportObject.getOrgCodes())) && BeanUtils.isNotEmpty(orgs = this.getOrgByTime(exportObject))) {
            ArrayList<String> orgIds = new ArrayList<String>();
            for (Org org : orgs) {
                orgIds.add(org.getId());
            }
            queryFilter.addFilter("ORG_ID_", orgIds, QueryOP.IN, FieldRelation.AND);
        }
    }

    @Override
    public List<OrgParams> getOrgParamByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        return this.orgParamsService.queryNoPage(queryFilter);
    }

    @Override
    public List<OrgPost> getOrgPostByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        return this.orgPostService.queryNoPage(queryFilter);
    }

    @Override
    public List<OrgRole> getOrgRoleByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        this.addOrgFilter(queryFilter, exportObject);
        return this.orgRoleManager.queryNoPage(queryFilter);
    }

    @Override
    public List<OrgUser> getOrgUserByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        this.addOrgFilter(queryFilter, exportObject);
        return this.orgUserService.queryNoPage(queryFilter);
    }

    @Override
    public List<UserUnder> getUserUnderByTime(OrgExportObject exportObject) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(exportObject.getBtime(), exportObject.getEtime());
        this.addOrgFilter(queryFilter, exportObject);
        return this.userUnderManager.queryNoPage(queryFilter);
    }

    @Override
    public List<Org> getOrgsByAccount(String account) throws Exception {
        if (StringUtil.isEmpty((String)account)) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + ":\u7528\u6237\u5e10\u53f7account\u5fc5\u586b");
        }
        List<Org> list = ((OrgDao)this.baseMapper).getOrgsByAccount(account);
        for (Org org : list) {
            Demension dem = (Demension)this.demensionService.get((Serializable)((Object)org.getDemId()));
            if (!BeanUtils.isNotEmpty((Object)dem)) continue;
            org.setDemName(dem.getDemName());
        }
        OrgUtil.removeDuplicate(list, "id");
        return list;
    }

    @Override
    @Transactional
    public Integer removePostPhysical() {
        return this.orgPostDao.removePhysical();
    }

    @Override
    @Transactional
    public Integer removeOrgUserPhysical() {
        return this.orgUserService.removePhysical();
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        Org org = ((OrgDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)org)) ? "\u8be5\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    public CommonResult<Boolean> isPostCodeExist(String code) throws Exception {
        boolean isExist;
        OrgPost post = this.orgPostDao.getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)post)) ? "\u8be5\u5c97\u4f4d\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    @Transactional
    public CommonResult<String> updateOrgPos(String orgId, String parentId) throws Exception {
        Org parentOrg;
        if (StringUtil.isEmpty((String)orgId) || StringUtil.isEmpty((String)parentId)) {
            throw new RequiredException("\u79fb\u52a8\u8282\u70b9\u6216\u76ee\u6807\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Org org = this.get((Serializable)((Object)orgId));
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u6839\u636e\u79fb\u52a8\u8282\u70b9id\u3010" + orgId + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u7ec4\u7ec7\uff01");
        }
        org.setParentId(parentId);
        if ("0".equals(parentId)) {
            parentId = org.getDemId();
        }
        if (BeanUtils.isEmpty((Object)(parentOrg = this.get((Serializable)((Object)parentId))))) {
            org.setPath(parentId + "." + orgId + ".");
            org.setPathName("/" + org.getName());
        } else {
            org.setPath(parentOrg.getPath() + orgId + ".");
            org.setPathName(parentOrg.getPathName() + "/" + org.getName());
        }
        this.update((Model)org);
        this.updateChildrenOrg(org);
        return new CommonResult(true, "\u66f4\u65b0\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    private void updateChildrenOrg(Org parentOrg) throws SQLException {
        List<Org> childrens = this.getByParentId(parentOrg.getId());
        for (Org org : childrens) {
            org.setPath(parentOrg.getPath() + org.getId() + ".");
            org.setPathName(parentOrg.getPathName() + "/" + org.getName());
            this.update((Model)org);
            this.updateChildrenOrg(org);
        }
    }

    @Override
    public String exportData(String orgCode, boolean isChildre) throws Exception {
        if (StringUtil.isEmpty((String)orgCode)) {
            throw new RequiredException("\u7ec4\u7ec7\u7f16\u7801\u3010orgCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Org org = ((OrgDao)this.baseMapper).getByCode(orgCode);
        if (BeanUtils.isEmpty((Object)org)) {
            throw new RequiredException("\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u3010" + orgCode + "\u3011\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\uff01");
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.getPageBean().setPageSize(PageBean.WITHOUT_PAGE.intValue());
        if (isChildre) {
            queryFilter.getParams().put("whereSql", " org.path_ like '" + org.getPath() + "%'");
        } else {
            queryFilter.getParams().put("orgId", org.getId());
        }
        String orgName = org.getName();
        String times = DateUtil.getCurrentTime((String)"yyyymmddhhmmss");
        List list = this.orgUserService.getOrgUserData(queryFilter);
        String path = (FileUtil.getIoTmpdir() + "/attachFiles/tempZip/" + orgName + "/" + times).replace("/", File.separator);
        String excelPath = path + File.separator;
        String excelName = "\u7ec4\u7ec7\u3010" + orgName + "\u3011\u76f8\u5173\u6570\u636e";
        this.exportExcel(list, orgName, excelName, excelPath);
        String filePath = excelPath + excelName;
        return filePath;
    }

    private <E> void exportExcel(List<E> list, String sheetName, String excelName, String excelPath) throws Exception {
        LinkedHashMap<String, String> exportMaps = new LinkedHashMap<String, String>();
        exportMaps.put("fullName", "\u7528\u6237\u59d3\u540d");
        exportMaps.put("account", "\u7528\u6237\u8d26\u53f7");
        exportMaps.put("userNumber", "\u5de5\u53f7");
        exportMaps.put("userId", "\u7528\u6237ID");
        exportMaps.put("status", "\u7528\u6237\u72b6\u6001");
        exportMaps.put("mobile", "\u624b\u673a\u53f7\u7801");
        exportMaps.put("email", "\u90ae\u7bb1");
        exportMaps.put("orgName", "\u7ec4\u7ec7\u540d\u79f0");
        exportMaps.put("orgCode", "\u7ec4\u7ec7\u7f16\u7801");
        exportMaps.put("orgId", "\u7ec4\u7ec7ID");
        exportMaps.put("orgPath", "\u7ec4\u7ec7\u8def\u5f84");
        exportMaps.put("orgPathName", "\u8def\u5f84\u540d\u79f0");
        exportMaps.put("isMaster", "\u4e3b\u5c97\u4f4d");
        exportMaps.put("isCharge", "\u8d1f\u8d23\u4eba");
        exportMaps.put("relName", "\u5c97\u4f4d\u540d\u79f0");
        exportMaps.put("postCode", "\u5c97\u4f4d\u7f16\u7801");
        exportMaps.put("relId", "\u5c97\u4f4dID");
        exportMaps.put("isRelActive", "\u5c97\u4f4d\u662f\u5426\u6709\u6548");
        HSSFWorkbook book = ExcelUtil.exportExcel((String)sheetName, (int)16, exportMaps, list);
        ExcelUtil.saveExcel((HSSFWorkbook)book, (String)excelName, (String)excelPath);
    }

    @Override
    public List<Map<String, String>> getPathNames(List<String> userIds) {
        return ((OrgDao)this.baseMapper).getPathNames(userIds);
    }

    @Override
    public Map<String, Set<String>> getChildrenIds(Map<String, String> ids) {
        HashMap<String, Set<String>> resultMap = new HashMap<String, Set<String>>();
        if (BeanUtils.isNotEmpty(ids)) {
            for (String key : ids.keySet()) {
                String idStr = ids.get(key);
                if (StringUtil.isEmpty((String)idStr)) continue;
                String[] idArray = idStr.split(",");
                QueryFilter filter1 = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
                filter1.addFilter("ID_", (Object)idArray, QueryOP.IN);
                List orgs = this.queryNoPage(filter1);
                if (!BeanUtils.isNotEmpty((Object)orgs)) continue;
                HashMap<String, String> pathMap = new HashMap<String, String>();
                for (int i = 0; i < orgs.size(); ++i) {
                    pathMap.put(String.valueOf(i + 1), ((Org)orgs.get(i)).getPath());
                }
                List<String> childrenIds = ((OrgDao)this.baseMapper).getChildrenIds(pathMap);
                resultMap.put(key, new HashSet<String>(childrenIds));
            }
        }
        return resultMap;
    }

    @Override
    public Org getOrgMaster(String account) {
        List<Org> orglist = ((OrgDao)this.baseMapper).getOrgMaster(account);
        if (BeanUtils.isNotEmpty(orglist)) {
            return orglist.get(0);
        }
        return null;
    }

    @Override
    @Transactional
    public CommonResult<String> addOrgFromExterUni(Org orgVo) {
        if (BeanUtils.isEmpty((Object)orgVo.getName())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u540d\u79f0\u3010name\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (BeanUtils.isEmpty((Object)orgVo.getCode())) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801\u3010code\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (orgVo.getCode().contains(",")) {
            throw new RuntimeException("\u7ec4\u7ec7\u7f16\u7801\u4e2d\u4e0d\u80fd\u5305\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (BeanUtils.isEmpty((Object)orgVo.getDemId())) {
            Demension defaultDem = this.demensionService.getDefaultDemension();
            if (BeanUtils.isEmpty((Object)defaultDem)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u672c\u7cfb\u7edf\u65e0\u9ed8\u8ba4\u7ef4\u5ea6");
            }
            orgVo.setDemId(defaultDem.getId());
        } else {
            Demension dem = (Demension)this.demensionService.get((Serializable)((Object)orgVo.getDemId()));
            if (BeanUtils.isEmpty((Object)dem)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684demId[" + orgVo.getDemId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u4fe1\u606f\uff01");
            }
        }
        Org o = this.getByCode(orgVo.getCode());
        if (BeanUtils.isNotEmpty((Object)o)) {
            throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u7ec4\u7ec7\u7f16\u7801[" + orgVo.getCode() + "]\u5df2\u5b58\u5728\uff01");
        }
        Org pOrg = null;
        if (!"0".equals(orgVo.getParentId()) && BeanUtils.isNotEmpty((Object)orgVo.getParentId())) {
            pOrg = this.get((Serializable)((Object)orgVo.getParentId()));
            if (BeanUtils.isEmpty((Object)pOrg)) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165\u7684parentId[" + orgVo.getParentId() + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
            }
            if (BeanUtils.isEmpty((Object)pOrg) && !pOrg.getDemId().equals(orgVo.getDemId())) {
                throw new RuntimeException("\u6dfb\u52a0\u7ec4\u7ec7[" + orgVo.getName() + "]\u5931\u8d25\uff0c\u6839\u636e\u8f93\u5165demId\u4e0e\u6240\u8f93\u5165\u7684\u7236\u7ec4\u7ec7\u6240\u5bf9\u5e94\u7684\u7ef4\u5ea6id\u4e0d\u4e00\u81f4\uff01");
            }
        }
        o = new Org();
        o.setId(orgVo.getId());
        o.setCode(orgVo.getCode());
        o.setName(orgVo.getName());
        o.setDemId(orgVo.getDemId());
        o.setOrderNo(orgVo.getOrderNo());
        if (StringUtils.isEmpty((CharSequence)orgVo.getParentId())) {
            o.setParentId("0");
        } else {
            o.setParentId(orgVo.getParentId());
        }
        if (BeanUtils.isEmpty((Object)pOrg)) {
            o.setPathName("/" + orgVo.getName());
            o.setPath(orgVo.getDemId() + "." + o.getId() + ".");
        } else {
            o.setPath(pOrg.getPath() + o.getId() + ".");
            o.setPathName(pOrg.getPathName() + "/" + orgVo.getName());
        }
        this.create((Model)o);
        return new CommonResult(true, "\u6dfb\u52a0\u7ec4\u7ec7\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public List<Org> getOrgsByparentId(String parentId) {
        return ((OrgDao)this.baseMapper).getByParentId(parentId);
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((OrgDao)this.baseMapper).removePhysical();
    }

    public Org get(Serializable id) {
        return ((OrgDao)this.baseMapper).get(id);
    }

    @Override
    public List<String> getSubOrgByIds(Set<String> parentIds) {
        if (parentIds.isEmpty()) {
            return new ArrayList<String>();
        }
        return ((OrgDao)this.baseMapper).getSubOrgByIds(parentIds);
    }

    @Override
    public List<Map<String, Object>> getOrgIdMapByUserId(String userId) {
        return ((OrgDao)this.baseMapper).getOrgIdMapByUserId(userId);
    }

    @Override
    public CommonResult<Org> getFillOrg(String demId, String grade) {
        String userId = ContextUtil.getCurrentUserId();
        Org curOrg = this.getMainGroup(userId, demId);
        Org gradeOrg = null;
        if (BeanUtils.isNotEmpty((Object)curOrg)) {
            gradeOrg = grade.equals(curOrg.getGrade()) ? curOrg : this.getPOrgByGread(curOrg.getParentId(), grade);
        } else {
            return new CommonResult(false, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4e3b\u7ec4\u7ec7\u5931\u8d25\uff01");
        }
        if (BeanUtils.isEmpty((Object)gradeOrg)) {
            return new CommonResult(false, "\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u586b\u5236\u5355\u4f4d\uff01");
        }
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)gradeOrg);
    }

    private Org getPOrgByGread(String orgId, String grade) {
        Org org = this.get((Serializable)((Object)orgId));
        if (BeanUtils.isNotEmpty((Object)org) && !grade.equals(org.getGrade())) {
            return this.getPOrgByGread(org.getParentId(), grade);
        }
        return org;
    }

    @Override
    public Map<String, Org> getParentMainOrg(String userId) {
        String path;
        List ids;
        List list;
        HashMap<String, Org> map = new HashMap<String, Org>();
        Org org = this.getMainGroup(userId, "");
        if (BeanUtils.isNotEmpty((Object)org) && BeanUtils.isNotEmpty((Object)(list = ((OrgDao)this.baseMapper).selectList((Wrapper)new QueryWrapper().in((Object)"ID_", ids = Arrays.asList((path = org.getPath()).split("\\.")).stream().map(s -> s.trim()).collect(Collectors.toList())))))) {
            list.forEach(item -> map.put(item.getGrade(), (Org)item));
        }
        return map;
    }

    @Override
    public OrgParams getParamById(String orgId, String alias) {
        return this.orgParamsService.getByOrgIdAndAlias(orgId, alias);
    }

    @Override
    public boolean isOrgHasParamKey(String orgId, String alias) {
        OrgParams byOrgIdAndAlias = this.orgParamsDao.getByOrgIdAndAlias(orgId, alias);
        return !BeanUtils.isEmpty((Object)byOrgIdAndAlias);
    }

    @Override
    public boolean hasOrgParamKey(String grade, String userId, String alias) throws Exception {
        Map<String, Org> map = this.getParentMainOrg(userId);
        if (map.containsKey(grade)) {
            OrgParams p = this.orgParamsService.getByOrgIdAndAlias(map.get(grade).getId(), alias);
            return BeanUtils.isNotEmpty((Object)p);
        }
        return false;
    }

    @Override
    public List<Org> getOrgListByCodes(List<String> list) {
        return ((OrgDao)this.baseMapper).getOrgListByCodes(list);
    }

    @Override
    public List<Org> getByPathNames(List<String> pathNames) {
        return ((OrgDao)this.baseMapper).getPathNameList(pathNames);
    }

    @Override
    public boolean insertBatch(List<Org> list) {
        return this.saveBatch(list);
    }

    @Override
    public List<Org> getParantMainOrgAll(String userId) throws IOException {
        String orgStr = this.orgUserService.getCacheByKeyOrgPost(userId);
        Org org = null;
        if (StringUtil.isNotEmpty((String)orgStr)) {
            Map stringObjectMap = JsonUtil.toMap((String)orgStr);
            Map postMap = (Map)stringObjectMap.get("postCharge");
            if (BeanUtils.isNotEmpty((Object)postMap)) {
                org = this.getByCode(postMap.get("orgcode").toString());
            }
        } else {
            org = this.getMainGroup(userId, "");
        }
        if (BeanUtils.isNotEmpty((Object)org)) {
            String path = org.getPath();
            List ids = Arrays.asList(path.split("\\.")).stream().map(s -> s.trim()).collect(Collectors.toList());
            List list = ((OrgDao)this.baseMapper).selectList((Wrapper)new QueryWrapper().in((Object)"ID_", ids));
            return list;
        }
        return new ArrayList<Org>();
    }

    @Override
    public List<Org> getOrgListByCodes(String code) {
        QueryWrapper orgQueryWrapper = new QueryWrapper();
        String[] split = code.split(",");
        List<String> strings = Arrays.asList(split);
        orgQueryWrapper.in(strings.size() > 0, (Object)"code_", strings);
        return ((OrgDao)this.baseMapper).selectList((Wrapper)orgQueryWrapper);
    }

    @Override
    public boolean syncOrg() throws Exception {
        String url = this.teijianConfig.getUrl() + "/user/org/findDeptByOrg?companyCode=10";
        ResponseEntity forEntity = this.restTemplate.getForEntity(url, JSONObject.class, new Object[0]);
        if (null == forEntity || null == forEntity.getBody() || StringUtil.isEmpty((String)((JSONObject)forEntity.getBody()).getString("code")) || !"0".equals(((JSONObject)forEntity.getBody()).getString("code"))) {
            this.log.error("\u7ec4\u7ec7\u6570\u636e\u83b7\u53d6\u5931\u8d25");
            return false;
        }
        JSONArray dataList = ((JSONObject)forEntity.getBody()).getJSONArray("dataList");
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            this.log.error("\u7ec4\u7ec7\u6570\u636e\u83b7\u53d6\u5931\u8d25");
            return false;
        }
        List orgVoList = JSON.parseArray((String)JSON.toJSONString((Object)dataList), YhOrgVo.class);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        List orgList = this.list((Wrapper)queryWrapper);
        Map<Object, Object> orgMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty((Collection)orgList)) {
            orgMap = orgList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        }
        String demId = "1726849603896352768";
        AtomicReference<Integer> grade = new AtomicReference<Integer>(0);
        grade.getAndSet(grade.get() + 1);
        this.saveOrgVo(orgVoList, orgMap, demId);
        return true;
    }

    @Override
    public List<OrgTree> getOrgTreeVoList(String demCode, String pOrgCode, String orgKind) {
        Demension d = this.demensionService.getByCode(demCode);
        if (BeanUtils.isEmpty((Object)d)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684demCode\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6");
        }
        return ((OrgDao)this.baseMapper).getOrgTreeVoList(d.getId(), pOrgCode, orgKind);
    }

    @Override
    public boolean updateUserPosition(List<TransPositionVo> transPositionVos) {
        if (CollectionUtils.isEmpty(transPositionVos)) {
            return false;
        }
        TransPositionVo transPositionVo = transPositionVos.get(0);
        List userIds = transPositionVos.stream().map(TransPositionVo::getUserId).collect(Collectors.toList());
        List positionIds = transPositionVos.stream().map(TransPositionVo::getSourcePosId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"user_id_", userIds);
        queryWrapper.in((Object)"pos_id_", positionIds);
        List list = this.orgUserService.list((Wrapper)queryWrapper);
        list.forEach(orgUser -> orgUser.setRelId(transPositionVo.getTargetPosId()));
        boolean b = this.orgUserService.updateBatchById(list);
        return b;
    }

    @Override
    public List<OrgTreeVo> getOrgTreeByUser(String demCode, String pOrgCode) throws Exception {
        String currentOrgId = ContextUtil.getCurrentDeptId(grade);
        ArrayList<OrgTreeVo> groupTreeList = new ArrayList<OrgTreeVo>();
        ArrayList<OrgTreeVo> userOrgTreeList = new ArrayList<OrgTreeVo>();
        List<OrgTree> list = this.getTreeDataByDem(demCode, pOrgCode, "ogn");
        if (StringUtil.isNotEmpty((String)currentOrgId)) {
            for (OrgTree group : list) {
                if (!group.getPath().contains(currentOrgId)) continue;
                OrgTreeVo groupTree = new OrgTreeVo(group);
                groupTreeList.add(groupTree);
            }
            userOrgTreeList = new ArrayList(groupTreeList);
            block1: for (OrgTreeVo orgTree : groupTreeList) {
                String parentId = orgTree.getParentId();
                while (parentId != null) {
                    boolean foundParent = false;
                    for (OrgTree tree : list) {
                        if (!tree.getId().equals(parentId)) continue;
                        OrgTreeVo parentTreeVo = new OrgTreeVo(tree);
                        if (!userOrgTreeList.contains(parentTreeVo)) {
                            userOrgTreeList.add(parentTreeVo);
                        }
                        parentId = tree.getParentId();
                        foundParent = true;
                        break;
                    }
                    if (foundParent) continue;
                    continue block1;
                }
            }
        } else {
            for (OrgTree group : list) {
                OrgTreeVo groupTree = new OrgTreeVo(group);
                userOrgTreeList.add(groupTree);
            }
        }
        return BeanUtils.listToTree(userOrgTreeList);
    }

    @Override
    public TeamVo getTeamByUserId(String userId) {
        return ((OrgDao)this.baseMapper).getTeamById(userId);
    }

    private void saveOrgVo(List<YhOrgVo> orgVoList, Map<String, Org> finalOrgMap, String demId) {
        orgVoList.stream().forEach(yhOrgVo -> {
            OrgVo orgVo = new OrgVo();
            orgVo.setDemId(demId);
            orgVo.setCode(yhOrgVo.getCode());
            orgVo.setName(yhOrgVo.getName());
            if (yhOrgVo.getType().equals("1")) {
                orgVo.setOrgKind("ogn");
            } else {
                orgVo.setOrgKind("dept");
            }
            try {
                String parentId = null;
                if (StringUtil.isEmpty((String)yhOrgVo.getParentCode())) {
                    parentId = "0";
                    orgVo.setGrade("1");
                } else {
                    Org orgParent = (Org)finalOrgMap.get(yhOrgVo.getParentCode().replaceAll("\\t\\r\\n", ""));
                    if (null != orgParent) {
                        parentId = orgParent.getId();
                        if (!StringUtil.isEmpty((String)orgParent.getPathName())) {
                            orgVo.setGrade(String.valueOf(orgParent.getPathName().split("/").length));
                        }
                    }
                }
                orgVo.setParentId(parentId);
                if (!finalOrgMap.containsKey(yhOrgVo.getCode())) {
                    this.addOrg(orgVo);
                } else {
                    this.updateOrg(orgVo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BaseException("\u540c\u6b65\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff1a\u7ec4\u7ec7\u7f16\u53f7\u4e3a:" + yhOrgVo.getCode() + ",\u9519\u8bef\u4fe1\u606f:" + e.getMessage());
            }
            if (CollectionUtils.isEmpty(yhOrgVo.getChildren())) {
                return;
            }
            this.saveOrgVo(yhOrgVo.getChildren(), finalOrgMap, demId);
        });
    }

    @Override
    @Transactional
    public CommonResult<String> addOrgPostFromExterUni(OrgPost orgPostVo) throws Exception {
        List<OrgPost> l;
        if (StringUtil.isEmpty((String)orgPostVo.getCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u4ee3\u7801code\u5fc5\u586b\uff01");
        }
        if (orgPostVo.getCode().contains(",")) {
            throw new RuntimeException("\u6dfb\u52a0\u5c97\u4f4d\u5931\u8d25\uff0c\u5c97\u4f4d\u7f16\u7801\u4e0d\u5141\u8bb8\u542b\u82f1\u6587\u9017\u53f7\u2018,\u2019");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getName())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u5c97\u4f4d\u540d\u79f0name\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getJobCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u804c\u52a1\u4ee3\u7801jobCode\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)orgPostVo.getOrgCode())) {
            throw new RuntimeException(HotentHttpStatus.REUIRED.description() + "\u7ec4\u7ec7\u4ee3\u7801orgCode\u5fc5\u586b\uff01");
        }
        Org o = this.getByCode(orgPostVo.getOrgCode());
        if (BeanUtils.isEmpty((Object)o)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u7ec4\u7ec7\u4ee3\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec4\u7ec7\u4fe1\u606f\uff01");
        }
        OrgJob job = this.orgJobService.getByCode(orgPostVo.getJobCode());
        if (BeanUtils.isEmpty((Object)job)) {
            throw new RuntimeException("\u6839\u636e\u8f93\u5165\u7684\u804c\u52a1\u7f16\u7801\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u804c\u52a1\u4fe1\u606f\uff01");
        }
        if (this.orgPostService.getCountByCode(orgPostVo.getCode()) > 0) {
            throw new RuntimeException("\u5c97\u4f4d\u7f16\u7801\u3010" + orgPostVo.getCode() + "\u3011\u5df2\u7ecf\u5b58\u5728\u7cfb\u7edf\u4e2d\uff01");
        }
        OrgPost rel = new OrgPost();
        if (BeanUtils.isEmpty((Object)orgPostVo.getId())) {
            rel.setId(UniqueIdUtil.getSuid());
        } else {
            if (BeanUtils.isNotEmpty((Object)this.orgPostService.get((Serializable)((Object)orgPostVo.getId())))) {
                throw new RuntimeException("\u6dfb\u52a0\u5c97\u4f4d\u3010" + orgPostVo.getName() + "\u3011\u5931\u8d25\uff0c\u5c97\u4f4dID\u3010" + orgPostVo.getId() + "\u3011\u5df2\u7ecf\u5b58\u5728\u7cfb\u7edf\u4e2d\uff01");
            }
            rel.setId(orgPostVo.getId());
        }
        rel.setName(orgPostVo.getName());
        rel.setCode(orgPostVo.getCode());
        rel.setRelDefId(job.getId());
        rel.setOrgId(o.getId());
        rel.setIsCharge(orgPostVo.getIsCharge());
        if (orgPostVo.getIsCharge() == 1 && BeanUtils.isNotEmpty(l = this.orgPostService.getRelCharge(o.getId(), true))) {
            OrgPost p = l.get(0);
            p.setIsCharge(0);
            this.orgPostService.update((Model)p);
        }
        this.orgPostService.create((Model)rel);
        return new CommonResult(true, "\u6dfb\u52a0\u5c97\u4f4d\u6210\u529f\uff01", (Object)"");
    }
}

