/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.graph;

import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.bpm.api.service.FlowStatusService;
import com.artfess.bpm.persistence.manager.BpmProStatusManager;
import com.artfess.bpm.persistence.model.DefaultBpmProStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class DefaultFlowStatusService
implements FlowStatusService {
    @Resource
    BpmProStatusManager bpmProStatusManager;
    private Map<String, String> statusColorMap = new HashMap<String, String>();

    public void setStatusColor(Map<String, String> statusColorMap) {
        this.statusColorMap = statusColorMap;
    }

    @Override
    public Map<String, String> getProcessInstanceStatus(String bpmnInstId) {
        QueryFilter filter = QueryFilter.build().withDefaultPage();
        filter.addFilter("proc_inst_id_", (Object)bpmnInstId, QueryOP.EQUAL);
        List<DefaultBpmProStatus> statusList = this.bpmProStatusManager.query(filter).getRows();
        if (BeanUtils.isEmpty((Object)statusList)) {
            statusList = this.bpmProStatusManager.queryHistorys(bpmnInstId);
        }
        HashMap<String, String> colourMap = new HashMap<String, String>();
        if (BeanUtils.isEmpty(statusList)) {
            return colourMap;
        }
        for (DefaultBpmProStatus bpmProStatus : statusList) {
            String nodeId = bpmProStatus.getNodeId();
            String status = bpmProStatus.getStatus();
            String color = this.statusColorMap.get(status);
            colourMap.put(nodeId, color);
        }
        return colourMap;
    }
}

