/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.execution.sign.handler;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.constant.DecideType;
import com.artfess.bpm.api.constant.FollowMode;
import com.artfess.bpm.api.constant.MultiInstanceType;
import com.artfess.bpm.api.constant.NodeStatus;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.api.constant.PrivilegeMode;
import com.artfess.bpm.api.constant.VoteResult;
import com.artfess.bpm.api.constant.VoteType;
import com.artfess.bpm.api.model.delegate.BpmDelegateExecution;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.CustomSignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.SignRule;
import com.artfess.bpm.api.plugin.core.execution.sign.SignResult;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.SignService;
import com.artfess.bpm.engine.execution.sign.handler.AbstractSignActionHandler;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.manager.BpmCheckOpinionManager;
import com.artfess.bpm.persistence.manager.BpmCustomSignDataManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.model.BpmCustomSignData;
import com.artfess.bpm.persistence.model.BpmSignData;
import com.artfess.bpm.persistence.util.BpmUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

public class ApproveSignActionHandler
extends AbstractSignActionHandler {
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmCheckOpinionManager bpmCheckOpinionManager;
    @Resource
    SignService signService;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmCustomSignDataManager bpmCustomSignDataManager;
    @Resource
    NatTaskService natTaskService;

    @Override
    public SignResult handByActionType(TaskFinishCmd cmd, BpmDelegateExecution bpmDelegateExecution) throws Exception {
        BpmProcessInstance instance = (BpmProcessInstance)cmd.getTransitVars("processInstance");
        String nodeId = bpmDelegateExecution.getNodeId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(instance.getProcDefId(), nodeId);
        if (bpmNodeDef instanceof SignNodeDef) {
            SignNodeDef nodeDef = (SignNodeDef)bpmNodeDef;
            String actionName = cmd.getActionName();
            String direct = (String)cmd.getTransitVars("signDirect");
            if (StringUtil.isNotEmpty((String)direct) && "1".equals(direct)) {
                SignResult result = this.handDirect(actionName);
                return result;
            }
            SignResult result = this.handByRule(cmd, nodeDef, bpmDelegateExecution, instance);
            if (result.isComplete()) {
                cmd.addTransitVars("task_sign_result", result);
                BpmUtil.autoTrans(bpmNodeDef, instance.getId(), cmd.getTaskId());
            }
            return result;
        }
        return this.handCustomSignResult(cmd, instance, bpmNodeDef);
    }

    private SignResult handCustomSignResult(TaskFinishCmd cmd, BpmProcessInstance instance, BpmNodeDef bpmNodeDef) {
        Object signStatus;
        boolean isComplete = false;
        CustomSignNodeDef nodeDef = (CustomSignNodeDef)bpmNodeDef;
        String signType = nodeDef.getSignType();
        Object IsDoneUnused = cmd.getTransitVars("IsDoneUnused");
        String newStatus = "complete";
        if (IsDoneUnused != null) {
            newStatus = "retracted";
        }
        if (BeanUtils.isNotEmpty((Object)(signStatus = cmd.getTransitVars("custom_sign_status")))) {
            newStatus = String.valueOf(signStatus);
        }
        this.bpmCustomSignDataManager.updateStatusByTaskId(cmd.getTaskId(), Arrays.asList("approval", "withdrawApproval"), newStatus, null);
        if ("Sequential".equals(signType)) {
            String varName = "signUsers_" + bpmNodeDef.getNodeId();
            Integer loopCounter = (Integer)this.natTaskService.getVariable(cmd.getTaskId(), "loopCounter");
            List list = (List)this.natTaskService.getVariable(cmd.getTaskId(), varName);
            if (loopCounter + 1 == list.size()) {
                isComplete = true;
            }
        } else {
            List<BpmCustomSignData> byInstIdAndStatus = this.bpmCustomSignDataManager.getByInstIdAndStatus(instance.getId(), Arrays.asList("approval", "withdrawApproval"));
            if (BeanUtils.isEmpty(byInstIdAndStatus)) {
                isComplete = true;
            }
        }
        SignResult result = new SignResult(isComplete, NodeStatus.AGREE, OpinionStatus.AGREE);
        if (result.isComplete()) {
            cmd.addTransitVars("task_sign_result", result);
        }
        return result;
    }

    private SignResult handDirect(String actionName) {
        SignResult result = new SignResult(true, NodeStatus.AGREE, OpinionStatus.SIGN_PASS_CANCEL);
        if (!actionName.equals(OpinionStatus.AGREE.getKey())) {
            result = new SignResult(true, NodeStatus.OPPOSE, OpinionStatus.SIGN_NOPASS_CANCEL);
        }
        return result;
    }

    private SignResult handByRule(TaskFinishCmd cmd, SignNodeDef nodeDef, BpmDelegateExecution bpmDelegteExecution, BpmProcessInstance processInstance) throws Exception {
        String nodeId = bpmDelegteExecution.getNodeId();
        boolean isParallel = !MultiInstanceType.SEQUENTIAL.equals((Object)bpmDelegteExecution.multiInstanceType());
        String executeId = isParallel ? bpmDelegteExecution.getParentExecution().getParentExecution().getId() : bpmDelegteExecution.getParentId();
        List<BpmSignData> list = this.bpmSignDataManager.getVoteByExecuteNode(executeId, nodeId, 1);
        int signSize = list.size();
        int aggreeCount = this.getAmount(list, VoteResult.AGREE);
        int opposeCount = this.getAmount(list, VoteResult.OPPOSE);
        int notVoteAmount = this.getAmount(list, VoteResult.NO);
        boolean isFinished = notVoteAmount == 0;
        SignRule rule = nodeDef.getSignRule();
        SignResult result = this.getByOneTicket(cmd, nodeDef, bpmDelegteExecution, processInstance);
        if (result != null) {
            return result;
        }
        result = this.getResult(rule, aggreeCount, opposeCount, signSize, isFinished);
        if (FollowMode.WAIT.equals((Object)rule.getFollowMode()) && !isFinished && result.isComplete()) {
            result.setComplete(false);
        }
        if (cmd.getTransitVars("b_tasks_revoke") != null) {
            result.setComplete(true);
            result.setNodeStatus(NodeStatus.BACK);
            result.setOpinionStatus(OpinionStatus.RETRACTED);
        }
        return result;
    }

    private SignResult getByOneTicket(TaskFinishCmd cmd, SignNodeDef nodeDef, BpmDelegateExecution bpmDelegteExecution, BpmProcessInstance bpmProcessInstance) throws Exception {
        String actionName = cmd.getActionName();
        if (!OpinionStatus.AGREE.getKey().equals(actionName) && !OpinionStatus.OPPOSE.getKey().equals(actionName)) {
            return null;
        }
        boolean hasOneTicket = this.getHasOneTicket(bpmDelegteExecution, nodeDef, bpmProcessInstance);
        if (!hasOneTicket) {
            return null;
        }
        String resultVarName = "signResult_" + bpmDelegteExecution.getNodeId();
        String resultVar = (String)bpmDelegteExecution.getVariable(resultVarName);
        if (hasOneTicket && StringUtil.isEmpty((String)resultVar)) {
            bpmDelegteExecution.setVariable(resultVarName, actionName);
        }
        if (StringUtil.isNotEmpty((String)(resultVar = (String)bpmDelegteExecution.getVariable(resultVarName)))) {
            SignResult result = new SignResult(true, NodeStatus.AGREE, OpinionStatus.SIGN_PASS_CANCEL);
            if (OpinionStatus.OPPOSE.getKey().equals(resultVar)) {
                result = new SignResult(true, NodeStatus.OPPOSE, OpinionStatus.SIGN_NOPASS_CANCEL);
                return result;
            }
            return result;
        }
        return null;
    }

    private SignResult getResult(SignRule rule, int agreeAmount, int opposeAmount, int totalAmount, boolean isFinished) {
        SignResult result = new SignResult();
        DecideType decideType = rule.getDecideType();
        int voteAmount = rule.getVoteAmount();
        if (DecideType.AGREE.getKey().equals(decideType.getKey())) {
            if (VoteType.PERCENT.getKey().equals(rule.getVoteType().getKey())) {
                agreeAmount = (int)((float)agreeAmount / (float)totalAmount * 100.0f);
            }
            if (agreeAmount >= voteAmount) {
                result.setComplete(true);
                result.setNodeStatus(NodeStatus.AGREE);
                result.setOpinionStatus(OpinionStatus.SIGN_PASS_CANCEL);
            } else if (isFinished) {
                result.setComplete(true);
                result.setNodeStatus(NodeStatus.OPPOSE);
                result.setOpinionStatus(OpinionStatus.SIGN_NOPASS_CANCEL);
            }
        } else {
            if (VoteType.PERCENT.getKey().equals(rule.getVoteType().getKey())) {
                opposeAmount = (int)((float)opposeAmount / (float)totalAmount * 100.0f);
            }
            if (opposeAmount >= voteAmount) {
                result.setComplete(true);
                result.setNodeStatus(NodeStatus.OPPOSE);
                result.setOpinionStatus(OpinionStatus.SIGN_NOPASS_CANCEL);
            } else if (isFinished) {
                result.setComplete(true);
                result.setNodeStatus(NodeStatus.AGREE);
                result.setOpinionStatus(OpinionStatus.SIGN_PASS_CANCEL);
            }
        }
        return result;
    }

    private int getAmount(List<BpmSignData> list, VoteResult voteResult) {
        int count = 0;
        for (BpmSignData signData : list) {
            if (!voteResult.getKey().equals(signData.getVoteResult())) continue;
            ++count;
        }
        return count;
    }

    private boolean getHasOneTicket(BpmDelegateExecution bpmDelegteExecution, SignNodeDef nodeDef, BpmProcessInstance bpmProcessInstance) throws Exception {
        Map<String, Object> vars;
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        List<PrivilegeMode> list = this.signService.getPrivilege(userId, nodeDef, vars = bpmDelegteExecution.getVariables());
        return list.contains((Object)PrivilegeMode.ALL) || list.contains((Object)PrivilegeMode.ONETICKET);
    }
}

