/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.UserRelDao;
import com.artfess.uc.exception.HotentHttpStatus;
import com.artfess.uc.exception.RequiredException;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgPostManager;
import com.artfess.uc.manager.RelAuthManager;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserGroupManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.manager.UserRelManager;
import com.artfess.uc.manager.UserRoleManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgPost;
import com.artfess.uc.model.RelAuth;
import com.artfess.uc.model.Role;
import com.artfess.uc.model.User;
import com.artfess.uc.model.UserGroup;
import com.artfess.uc.model.UserRel;
import com.artfess.uc.model.UserRole;
import com.artfess.uc.params.user.UserRelFilterObject;
import com.artfess.uc.params.user.UserRelVo;
import com.artfess.uc.util.ContextUtil;
import com.artfess.uc.util.OrgUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserRelManagerImpl
extends BaseManagerImpl<UserRelDao, UserRel>
implements UserRelManager {
    @Autowired
    UserRoleManager userRoleService;
    @Autowired
    UserManager userService;
    @Autowired
    OrgManager orgService;
    @Autowired
    RoleManager roleService;
    @Autowired
    OrgPostManager orgPostService;
    @Autowired
    UserGroupManager userGroupService;
    @Autowired
    RelAuthManager relAuthService;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    BaseContext baseContext;

    @Override
    public List<UserRel> getByTypeId(String typeId) throws Exception {
        String authSql = this.getAuthSql(typeId);
        return ((UserRelDao)this.baseMapper).getByTypeId(typeId, authSql);
    }

    @Override
    public UserRel getByUserIdAndParentId(String typeId, String value, String parentId) {
        return ((UserRelDao)this.baseMapper).getByUserIdAndParentId(typeId, parentId, value);
    }

    @Override
    public UserRel getByAlias(String alias) {
        return ((UserRelDao)this.baseMapper).getByAlias(alias);
    }

    @Override
    public List<User> getSuperUser(String account, String typeId) throws Exception {
        List<UserRel> rels = this.getSuperUserRel(account, typeId);
        List<User> users = new ArrayList<User>();
        if (BeanUtils.isNotEmpty(rels)) {
            users = this.convertRelToUser(rels);
            OrgUtil.removeDuplicate(users);
        }
        return users;
    }

    @Override
    public String getRelTypeId(UserRelFilterObject userRelFilterObject) throws Exception {
        if (StringUtil.isEmpty((String)userRelFilterObject.getAccount()) && StringUtil.isEmpty((String)userRelFilterObject.getUserId())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1aaccount\u3001userId\u7528\u6237\u8d26\u53f7\u6216id\u4efb\u586b\u4e00\u4e2a\uff01");
        }
        User user = null;
        if (StringUtil.isNotEmpty((String)userRelFilterObject.getAccount())) {
            user = this.userService.getByAccount(userRelFilterObject.getAccount());
        }
        if (BeanUtils.isEmpty(user)) {
            user = (User)this.userService.get((Serializable)((Object)userRelFilterObject.getUserId()));
            if (BeanUtils.isEmpty((Object)user)) {
                throw new RequiredException("\u672a\u83b7\u53d6\u5230\u7528\u6237\uff01");
            }
            userRelFilterObject.setAccount(user.getAccount());
        }
        if (StringUtil.isEmpty((String)userRelFilterObject.getTypeCode())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1atypeCode\u6c47\u62a5\u7ebf\u5206\u7c7b\u7f16\u7801\uff01");
        }
        ObjectNode proType = this.systemConfigFeignService.getSysTypeByType("REPORT_LINE", userRelFilterObject.getTypeCode());
        if (BeanUtils.isEmpty((Object)proType)) {
            throw new RequiredException("\u6c47\u62a5\u7ebf\u5206\u7c7b\u7f16\u7801\u3010" + userRelFilterObject.getTypeCode() + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        return proType.get("id").asText();
    }

    @Override
    public List<User> getAllSuperUser(String account, String typeId) throws Exception {
        List<UserRel> rels = this.getSuperUserRel(account, typeId);
        List<User> users = new ArrayList<User>();
        if (BeanUtils.isNotEmpty(rels)) {
            ArrayList<UserRel> list = new ArrayList<UserRel>();
            list.addAll(rels);
            for (UserRel rel : rels) {
                this.getParentsToTop(list, rel);
            }
            users = this.convertRelToUser(list);
            OrgUtil.removeDuplicate(users);
        }
        return users;
    }

    @Override
    public List<User> getLowerUser(String account, String typeId) throws Exception {
        List<UserRel> rels = this.getUserRels(account, typeId);
        List<User> users = new ArrayList<User>();
        if (BeanUtils.isNotEmpty(rels)) {
            ArrayList<UserRel> sysUserRels = new ArrayList<UserRel>();
            for (UserRel rel : rels) {
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("STATUS_", (Object)1, QueryOP.EQUAL, FieldRelation.AND);
                if (StringUtil.isNotEmpty((String)typeId)) {
                    queryFilter.addFilter("TYPE_ID_", (Object)typeId, QueryOP.EQUAL, FieldRelation.AND);
                }
                queryFilter.addFilter("PARENT_ID_", (Object)rel.getId(), QueryOP.EQUAL, FieldRelation.AND);
                List childs = this.queryNoPage(queryFilter);
                if (!BeanUtils.isNotEmpty((Object)childs)) continue;
                sysUserRels.addAll(childs);
            }
            BeanUtils.removeDuplicate(sysUserRels);
            users = this.convertRelToUser(sysUserRels);
            OrgUtil.removeDuplicate(users);
        }
        return users;
    }

    @Override
    public List<User> getAllLowerUser(String account, String typeId) throws Exception {
        List<UserRel> rels = this.getUserRels(account, typeId);
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<UserRel> allRel = new ArrayList<UserRel>();
        if (BeanUtils.isNotEmpty(rels)) {
            for (UserRel rel : rels) {
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("STATUS_", (Object)1, QueryOP.EQUAL, FieldRelation.AND);
                if (StringUtil.isNotEmpty((String)typeId)) {
                    queryFilter.addFilter("TYPE_ID_", (Object)typeId, QueryOP.EQUAL, FieldRelation.AND);
                }
                queryFilter.addFilter("ID_", (Object)rel.getId(), QueryOP.NOT_EQUAL, FieldRelation.AND);
                queryFilter.addFilter("PATH_", (Object)rel.getPath(), QueryOP.RIGHT_LIKE, FieldRelation.AND);
                List childs = this.queryNoPage(queryFilter);
                if (!BeanUtils.isNotEmpty((Object)childs)) continue;
                allRel.addAll(childs);
            }
            BeanUtils.removeDuplicate(allRel);
            users.addAll(this.convertRelToUser(allRel));
        }
        if (BeanUtils.isNotEmpty(users)) {
            OrgUtil.removeDuplicate(users);
        }
        return users;
    }

    private List<UserRel> getSuperUserRel(String account, String typeId) throws Exception {
        StringBuilder initSql;
        ArrayNode array = this.getUserGroupInfo(account);
        String sql = this.getUserRelCommonSql(array, typeId, (initSql = new StringBuilder()).toString());
        List<UserRel> list = ((UserRelDao)this.baseMapper).getSuperUserRelBySql(sql);
        if (BeanUtils.isNotEmpty(list)) {
            UserRel topRel = list.get(0);
            for (UserRel userRel : list) {
                if (topRel.getPath().indexOf(userRel.getPath()) <= -1) continue;
                topRel = userRel;
            }
            list.clear();
            list.add(topRel);
        }
        return list;
    }

    @Override
    public List<UserRel> getUserRels(String account, String typeId) throws Exception {
        ArrayNode array = this.getUserGroupInfo(account);
        StringBuilder initSql = new StringBuilder();
        String sql = this.getUserRelCommonSql(array, typeId, initSql.toString());
        List<UserRel> list = ((UserRelDao)this.baseMapper).getByWhereSql(sql);
        return list;
    }

    private String getUserRelCommonSql(ArrayNode array, String typeId, String initSql) throws IOException {
        String userGroupWhereSql;
        StringBuilder sql = new StringBuilder();
        sql.append(initSql);
        if (StringUtil.isNotEmpty((String)typeId)) {
            sql.append(" and rela.type_id_='" + typeId + "'");
        }
        if (StringUtil.isNotEmpty((String)(userGroupWhereSql = this.getUserGroupWhereSql(array)))) {
            sql.append(" and ( ");
            if (StringUtil.isNotEmpty((String)userGroupWhereSql)) {
                sql.append(userGroupWhereSql);
            }
            sql.append(" ) ");
        }
        return sql.toString();
    }

    private String getUserGroupWhereSql(ArrayNode array) throws IOException {
        StringBuffer sql = new StringBuffer();
        boolean isFirst = true;
        for (Object object : array) {
            String typeSql;
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(object);
            String type = obj.get("type").asText();
            if (!StringUtil.isNotEmpty((String)type) || !StringUtil.isNotEmpty((String)(typeSql = this.getInSqlByType(array, type)))) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append(" or ");
            }
            sql.append(" (rela.value_ in (" + typeSql + ") and rela.group_type_='" + type + "' )");
        }
        return sql.toString();
    }

    private String getInSqlByType(ArrayNode array, String type) throws IOException {
        StringBuffer sql = new StringBuffer();
        boolean isEmpty = true;
        for (Object object : array) {
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(object);
            if (!type.equals(obj.get("type").asText())) continue;
            if (isEmpty) {
                isEmpty = false;
            } else {
                sql.append(",");
            }
            sql.append("'" + obj.get("id").asText() + "'");
        }
        return isEmpty ? "" : sql.toString();
    }

    private String getLikeSqlByType(ArrayNode array) throws IOException {
        StringBuffer sql = new StringBuffer();
        boolean isEmpty = true;
        for (Object object : array) {
            ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(object);
            String type = obj.get("type").asText();
            if (isEmpty) {
                isEmpty = false;
            } else {
                sql.append(" or ");
            }
            sql.append(" " + type.replace("\"", "") + "_id_ like '%" + obj.get("id").asText().replace("\"", "") + "%' ");
        }
        return isEmpty ? "" : sql.toString();
    }

    private ArrayNode getUserGroupInfo(String account) throws Exception {
        User user;
        ArrayNode array = JsonUtil.getMapper().createArrayNode();
        if (StringUtil.isNotEmpty((String)account) && BeanUtils.isNotEmpty((Object)(user = this.userService.getByAccount(account)))) {
            List<UserRole> roles;
            this.convertObj(array, "user", user.getId());
            QueryFilter queryFilter = QueryFilter.build();
            queryFilter.addFilter("orguser.user_id_", (Object)user.getId(), QueryOP.EQUAL, FieldRelation.AND);
            List orgUserList = this.userService.queryOrgUserRel(queryFilter);
            if (BeanUtils.isNotEmpty((Object)orgUserList)) {
                for (Object object : orgUserList) {
                    ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode(object);
                    this.convertObj(array, "org", obj.get("orgId").asText());
                    if (obj.findValue("relId") == null || !StringUtil.isNotEmpty((String)obj.get("relId").asText())) continue;
                    this.convertObj(array, "pos", obj.get("relId").asText());
                }
            }
            if (BeanUtils.isNotEmpty(roles = this.userRoleService.getListByUserId(user.getId()))) {
                for (UserRole userRole : roles) {
                    this.convertObj(array, "role", userRole.getRoleId());
                }
            }
        }
        return array;
    }

    private void convertObj(ArrayNode array, String type, String id) {
        ObjectNode userMap = JsonUtil.getMapper().createObjectNode();
        userMap.put("type", type);
        userMap.put("id", id);
        array.add((JsonNode)userMap);
    }

    private List<User> convertRelToUser(List<UserRel> list) throws Exception {
        ArrayList<User> userList = new ArrayList<User>();
        if (BeanUtils.isNotEmpty(list)) {
            for (UserRel rel : list) {
                String groupType = rel.getGroupType();
                String value = rel.getValue();
                if ("group".equals(groupType)) {
                    List<User> listPos;
                    List<User> listRole;
                    List<User> listOrg;
                    UserGroup sysUserGroup = (UserGroup)this.userGroupService.get((Serializable)((Object)value));
                    if (!BeanUtils.isNotEmpty((Object)sysUserGroup)) continue;
                    List<User> listUser = OrgUtil.getUserListByTypeId("user", sysUserGroup.getUserId());
                    if (BeanUtils.isNotEmpty(listUser)) {
                        userList.addAll(listUser);
                    }
                    if (BeanUtils.isNotEmpty(listOrg = OrgUtil.getUserListByTypeId("org", sysUserGroup.getOrgId()))) {
                        userList.addAll(listOrg);
                    }
                    if (BeanUtils.isNotEmpty(listRole = OrgUtil.getUserListByTypeId("role", sysUserGroup.getRoleId()))) {
                        userList.addAll(listRole);
                    }
                    if (!BeanUtils.isNotEmpty(listPos = OrgUtil.getUserListByTypeId("pos", sysUserGroup.getPosId()))) continue;
                    userList.addAll(listPos);
                    continue;
                }
                List<User> lists = OrgUtil.getUserListByTypeId(groupType, value);
                if (!BeanUtils.isNotEmpty(lists)) continue;
                userList.addAll(lists);
            }
        }
        return userList;
    }

    private void getParentsToTop(List<UserRel> list, UserRel sysUserRel) {
        UserRel pSysUserRel;
        if (!sysUserRel.getParentId().equals(sysUserRel.getTypeId()) && BeanUtils.isNotEmpty((Object)(pSysUserRel = (UserRel)this.get((Serializable)((Object)sysUserRel.getParentId()))))) {
            list.add(pSysUserRel);
            this.getParentsToTop(list, pSysUserRel);
        }
    }

    @Override
    @Transactional
    public CommonResult<String> addUserRel(List<UserRelVo> list) throws Exception {
        ArrayList<UserRel> relList = new ArrayList<UserRel>();
        for (UserRelVo userRelVo : list) {
            UserRel userRel = this.buildUserRel(userRelVo);
            if (!BeanUtils.isNotEmpty((Object)userRel)) continue;
            relList.add(userRel);
        }
        for (UserRel userRel : relList) {
            this.create((Model)userRel);
        }
        return new CommonResult(true, "\u6dfb\u52a0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u6210\u529f\uff01", (Object)"");
    }

    private String isExitInparentAndBrother(UserRel parentUserRel, UserRel userRel, Boolean isAdd) {
        String errMsg = "";
        if (parentUserRel.getValue().equals(userRel.getValue())) {
            errMsg = "\u6240\u9009\u7528\u6237\u7ec4\u542b\u6709\u548c\u7236\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u76f8\u540c\u7684\u7528\u6237\u7ec4\u3010" + userRel.getName() + "\u3011\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01";
        }
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("PARENT_ID_", (Object)parentUserRel.getId(), QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("VALUE_", (Object)userRel.getValue(), QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("GROUP_TYPE_", (Object)userRel.getGroupType(), QueryOP.EQUAL, FieldRelation.AND);
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL, FieldRelation.AND);
        PageList<UserRel> pageList = this.query((QueryFilter<UserRel>)queryFilter);
        if (pageList.getTotal() > 0L) {
            if (isAdd.booleanValue()) {
                errMsg = "\u6240\u9009\u7528\u6237\u7ec4\u3010" + userRel.getName() + "\u3011\u5728\u5f53\u524d\u7236\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u4e0b\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01";
            } else if (!((UserRel)pageList.getRows().get(0)).getId().equals(userRel.getId())) {
                errMsg = "\u6240\u9009\u7528\u6237\u7ec4\u3010" + userRel.getName() + "\u3011\u5728\u5f53\u524d\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u4e0b\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01";
            }
        }
        if (!isAdd.booleanValue()) {
            QueryFilter queryFilter1 = QueryFilter.build();
            queryFilter1.addFilter("PARENT_ID_", (Object)userRel.getId(), QueryOP.EQUAL, FieldRelation.AND);
            queryFilter1.addFilter("VALUE_", (Object)userRel.getValue(), QueryOP.EQUAL, FieldRelation.AND);
            queryFilter1.addFilter("GROUP_TYPE_", (Object)userRel.getGroupType(), QueryOP.EQUAL, FieldRelation.AND);
            PageList<UserRel> query = this.query((QueryFilter<UserRel>)queryFilter1);
            if (query.getTotal() > 0L) {
                errMsg = "\u6240\u9009\u7528\u6237\u7ec4\u3010" + userRel.getName() + "\u3011\u5728\u5f53\u524d\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u4e0b\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01";
            }
        }
        return errMsg;
    }

    private UserRel buildUserRel(UserRelVo userRelVo) throws Exception {
        if (StringUtil.isEmpty((String)userRelVo.getValue())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1avalue\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u503c\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)userRelVo.getType())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1atype\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7c7b\u578b\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)userRelVo.getParentAlias())) {
            throw new RequiredException(HotentHttpStatus.REUIRED.description() + "\uff1aparentAlias\u7236\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u522b\u540d\u5fc5\u586b\uff01");
        }
        UserRel parentUserRel = this.getByAlias(userRelVo.getParentAlias());
        ObjectNode proType = null;
        String serchKey = BeanUtils.isEmpty((Object)parentUserRel) ? userRelVo.getParentAlias() : parentUserRel.getTypeId();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("typeGroupKey", (Object)"REPORT_LINE", QueryOP.EQUAL, FieldRelation.AND, "typeGroup");
        queryFilter.addFilter("typeKey", (Object)serchKey, QueryOP.EQUAL, FieldRelation.OR, "keyGroup");
        queryFilter.addFilter("id", (Object)serchKey, QueryOP.EQUAL, FieldRelation.OR, "keyGroup");
        ObjectNode allSysType = this.systemConfigFeignService.getAllSysType(queryFilter);
        if (BeanUtils.isNotEmpty((Object)allSysType) && allSysType.hasNonNull("rows") && allSysType.get("rows") instanceof ArrayNode) {
            proType = (ObjectNode)allSysType.get("rows").get(0);
        }
        if (BeanUtils.isEmpty((Object)parentUserRel)) {
            if (BeanUtils.isEmpty(proType)) {
                throw new RequiredException("\u7236\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u522b\u540d\u3010" + userRelVo.getParentAlias() + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            parentUserRel = new UserRel();
            String typeId = proType.get("id").asText();
            parentUserRel.setTypeId(typeId);
            parentUserRel.setValue(typeId);
            parentUserRel.setId(typeId);
            parentUserRel.setPath(typeId + ".");
        }
        UserRel userRel = UserRelVo.parse(userRelVo);
        userRel.setId(UniqueIdUtil.getSuid());
        userRel.setAlias(proType.get("typeKey").asText() + userRel.getGroupType() + userRel.getValue());
        userRel.setTypeId(parentUserRel.getTypeId());
        userRel.setPath(parentUserRel.getPath() + userRel.getId() + ".");
        userRel.setParentId(parentUserRel.getId());
        this.setUserRelNameAndValue(userRel);
        userRelVo.setValue(userRel.getValue());
        if (BeanUtils.isNotEmpty((Object)this.isExitInparentAndBrother(parentUserRel, userRel, true))) {
            return null;
        }
        UserRel uRel = this.getByAlias(userRel.getAlias());
        if (BeanUtils.isNotEmpty((Object)uRel)) {
            userRel.setAlias(userRel.getAlias() + userRel.getId().substring(userRel.getId().length() - 3, userRel.getId().length()));
        }
        return userRel;
    }

    @Override
    @Transactional
    public CommonResult<String> deleteUserRel(String codes) throws Exception {
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        boolean isTrue = false;
        for (String code : codeArray) {
            UserRel userRel = this.getByAlias(code);
            if (BeanUtils.isNotEmpty((Object)userRel)) {
                this.removeByPath(userRel.getPath() + "%");
                isTrue = true;
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u6237\u5173\u7cfb\u5b9a\u4e49\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u6237\u5173\u7cfb\u5b9a\u4e49\u522b\u540d\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> updateUserRel(UserRelVo userRelVo) throws Exception {
        String errMsg;
        UserRel parentUserRel;
        UserRel userRel = (UserRel)this.get((Serializable)((Object)userRelVo.getId()));
        if (StringUtil.isEmpty((String)userRelVo.getAlias())) {
            throw new RequiredException("\u66f4\u65b0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u5931\u8d25\uff0c\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u522b\u540d\u3010alias\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)userRelVo.getValue())) {
            throw new RequiredException("\u66f4\u65b0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u5931\u8d25\uff0c\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u503c\u3010value\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)userRelVo.getType())) {
            throw new RequiredException("\u66f4\u65b0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u5931\u8d25\uff0c\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u7c7b\u578b\u3010type\u3011\u5fc5\u586b\uff01");
        }
        userRel.setValue(userRelVo.getValue());
        userRel.setGroupType(userRelVo.getType());
        this.setUserRelNameAndValue(userRel);
        if (BeanUtils.isNotEmpty((Object)userRelVo.getStatus())) {
            userRel.setStatus(userRelVo.getStatus());
        }
        if (BeanUtils.isEmpty((Object)(parentUserRel = (UserRel)this.get((Serializable)((Object)userRel.getParentId()))))) {
            ObjectNode proType = this.systemConfigFeignService.getSysTypeById(userRelVo.getParentAlias());
            if (BeanUtils.isEmpty((Object)proType)) {
                throw new RequiredException("\u66f4\u65b0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u5931\u8d25\uff0c\u7236\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u522b\u540d\u3010" + parentUserRel.getAlias() + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            parentUserRel = new UserRel();
            String typeId = proType.get("id").asText();
            parentUserRel.setTypeId(typeId);
            parentUserRel.setValue(typeId);
            parentUserRel.setId(typeId);
            parentUserRel.setPath(typeId + ".");
        }
        if (BeanUtils.isNotEmpty((Object)(errMsg = this.isExitInparentAndBrother(parentUserRel, userRel, false)))) {
            throw new Exception(errMsg);
        }
        this.update((Model)userRel);
        return new CommonResult(true, "\u66f4\u65b0\u7528\u6237\u5173\u7cfb\u5b9a\u4e49\u6210\u529f\uff01", (Object)"");
    }

    @Transactional
    private UserRel setUserRelNameAndValue(UserRel userRel) throws Exception {
        UserGroup group;
        String type = userRel.getGroupType();
        String id = userRel.getValue();
        if ("user".equals(type)) {
            User user = (User)this.userService.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)user)) {
                userRel.setValue(user.getId());
                userRel.setName(user.getFullname());
            }
        } else if ("org".equals(type)) {
            Org org = (Org)this.orgService.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)org)) {
                userRel.setValue(org.getId());
                userRel.setName(org.getName());
            }
        } else if ("pos".equals(type)) {
            OrgPost post = (OrgPost)this.orgPostService.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)post)) {
                userRel.setValue(post.getId());
                userRel.setName(post.getName());
            }
        } else if ("role".equals(type)) {
            Role role = (Role)this.roleService.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)role)) {
                userRel.setValue(role.getId());
                userRel.setName(role.getName());
            }
        } else if ("group".equals(type) && BeanUtils.isNotEmpty((Object)(group = (UserGroup)this.userGroupService.get((Serializable)((Object)id))))) {
            userRel.setValue(group.getId());
            userRel.setName(group.getName());
        }
        return userRel;
    }

    @Override
    public List<UserRel> getUserRelByTypeId(String typeId) throws Exception {
        ObjectNode proType = this.systemConfigFeignService.getSysTypeById(typeId, this.baseContext.getCurrentTenantId());
        List<Object> list = new ArrayList();
        if (BeanUtils.isNotEmpty((Object)proType)) {
            UserRel userRel = new UserRel();
            userRel.setId(typeId);
            userRel.setValue(typeId);
            userRel.setAlias(proType.get("typeKey").asText());
            userRel.setParentId("-1");
            userRel.setName(proType.get("name").asText());
            userRel.setTypeId(typeId);
            String authSql = this.getAuthSql(typeId);
            list = ((UserRelDao)this.baseMapper).getByTypeId(typeId, authSql);
            if (StringUtil.isEmpty((String)authSql)) {
                list.add(userRel);
            }
        } else {
            throw new RequiredException("\u6839\u636e\u6c47\u62a5\u7ebf\u5206\u7c7bID\u3010" + typeId + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6c47\u62a5\u7ebf\uff01");
        }
        return list;
    }

    @Override
    public PageList<UserRel> getChildRelByAilas(String code) {
        String parentId = "";
        UserRel userRel = this.getByAlias(code);
        if (BeanUtils.isEmpty((Object)userRel)) {
            ObjectNode proType = this.systemConfigFeignService.getSysTypeById(code);
            if (BeanUtils.isEmpty((Object)proType)) {
                throw new RequiredException("\u6839\u636e\u6c47\u62a5\u7ebf\u522b\u540d\u3010" + code + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u6c47\u62a5\u7ebf\uff01");
            }
            parentId = proType.get("id").asText();
        } else {
            parentId = userRel.getId();
        }
        QueryFilter queryFilter = QueryFilter.build();
        PageBean page = new PageBean(Integer.valueOf(1), Integer.valueOf(1000));
        queryFilter.setPageBean(page);
        queryFilter.addFilter("PARENT_ID_", (Object)parentId, QueryOP.EQUAL, FieldRelation.AND);
        PageList<UserRel> list = this.query((QueryFilter<UserRel>)queryFilter);
        return list;
    }

    @Override
    public List<UserRel> getUserRelByTime(String btime, String etime) throws Exception {
        QueryFilter queryFilter = OrgUtil.getDataByTimeFilter(btime, etime);
        return this.queryNoPage(queryFilter);
    }

    @Override
    public List<User> getUsersByRel(String alias) throws Exception {
        UserRel rel = this.getByAlias(alias);
        if (BeanUtils.isEmpty((Object)rel)) {
            throw new RequiredException("\u6c47\u62a5\u7ebf\u522b\u540d\u3010" + alias + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        ArrayList<UserRel> rels = new ArrayList<UserRel>();
        rels.add(rel);
        return this.convertRelToUser(rels);
    }

    @Override
    @Transactional
    public void removeByPath(String path) {
        ((UserRelDao)this.baseMapper).removeByPath(path, LocalDateTime.now());
    }

    private String getAuthSql(String typeId) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("");
        User user = ContextUtil.getCurrentUser();
        if (BeanUtils.isNotEmpty((Object)user) && !user.isAdmin()) {
            List<RelAuth> auths = this.relAuthService.getRelAuthsByTypeAndUser(typeId, user.getId());
            sql.append(" AND ");
            if (BeanUtils.isNotEmpty(auths)) {
                sql.append(" ( ");
                boolean isFirst = true;
                for (RelAuth relAuth : auths) {
                    sql.append(isFirst ? "" : " OR ");
                    sql.append(" PATH_ LIKE '" + relAuth.getRelPath() + "%' ");
                    isFirst = false;
                }
                sql.append(" ) ");
            } else {
                sql.append(" ID_='0' ");
            }
        }
        return sql.toString();
    }

    @Override
    public List<UserRel> getByParentId(String parentId) throws Exception {
        if (StringUtil.isEmpty((String)parentId)) {
            throw new RequiredException("\u7236\u8282\u70b9id\u201cparentId\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return ((UserRelDao)this.baseMapper).getByParentId(parentId);
    }

    @Override
    @Transactional
    public CommonResult<String> updateRelPos(String relId, String parentId) throws Exception {
        if (StringUtil.isEmpty((String)relId) || StringUtil.isEmpty((String)parentId)) {
            throw new RequiredException("\u79fb\u52a8\u8282\u70b9\u6216\u76ee\u6807\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        UserRel rel = (UserRel)this.get((Serializable)((Object)relId));
        if (BeanUtils.isEmpty((Object)rel)) {
            throw new RequiredException("\u6839\u636e\u79fb\u52a8\u8282\u70b9id\u3010" + relId + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u8282\u70b9\uff01");
        }
        if (parentId.equals(rel.getParentId())) {
            return new CommonResult(true, "\u8282\u70b9\u3010" + rel.getName() + "\u3011\u5df2\u7ecf\u662f\u5176\u5b50\u8282\u70b9\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\uff01", (Object)"");
        }
        if (parentId.equals(rel.getTypeId())) {
            throw new RequiredException("\u4e0d\u80fd\u5c06\u8282\u70b9\u3010" + rel.getName() + "\u3011\u79fb\u81f3\u5206\u7c7b\u4e0b\uff0c\u4e00\u6761\u6c47\u62a5\u7ebf\u53ea\u80fd\u6709\u4e00\u4e2a\u6839\u8282\u70b9\uff01");
        }
        UserRel parentRel = (UserRel)this.get((Serializable)((Object)parentId));
        List<UserRel> childrens = this.getByParentId(parentRel.getId());
        for (UserRel userRel : childrens) {
            if (userRel.getId().equals(rel.getId()) || !userRel.getValue().equals(rel.getValue()) || !userRel.getGroupType().equals(rel.getGroupType())) continue;
            throw new RequiredException("\u6c47\u62a5\u7ebf\u8282\u70b9\u3010" + parentRel.getName() + "\u3011\u4e0b\u5df2\u5b58\u5728\u8282\u70b9\u3010" + rel.getName() + "\u3011\uff0c\u4e0d\u80fd\u6dfb\u52a0\u591a\u4e2a!");
        }
        if (BeanUtils.isEmpty((Object)parentRel)) {
            throw new RequiredException("\u6839\u636e\u76ee\u6807\u8282\u70b9id\u3010" + parentId + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u8282\u70b9\uff01");
        }
        rel.setPath(parentRel.getPath() + relId + ".");
        rel.setParentId(parentId);
        this.update((Model)rel);
        this.updateChildrenRel(rel);
        return new CommonResult(true, "\u66f4\u65b0\u6c47\u62a5\u7ebf\u6210\u529f\uff01", (Object)"");
    }

    @Transactional
    private void updateChildrenRel(UserRel parentRel) throws Exception {
        List<UserRel> childrens = this.getByParentId(parentRel.getId());
        for (UserRel rel : childrens) {
            rel.setPath(parentRel.getPath() + rel.getId() + ".");
            this.update((Model)rel);
            this.updateChildrenRel(rel);
        }
    }

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((UserRelDao)this.baseMapper).removePhysical();
    }

    @Transactional(readOnly=true)
    public PageList<UserRel> query(QueryFilter<UserRel> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Map params = queryFilter.getParams();
        if (BeanUtils.isNotEmpty(params.get("typeId"))) {
            queryFilter.addFilter("TYPE_ID_", params.get("typeId"), QueryOP.EQUAL);
        }
        if (BeanUtils.isNotEmpty(params.get("parentId"))) {
            queryFilter.addFilter("PARENT_ID_", params.get("parentId"), QueryOP.EQUAL);
        }
        IPage<UserRel> result = ((UserRelDao)this.baseMapper).query((IPage<UserRel>)this.convert2IPage(pageBean), (Wrapper<UserRel>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }
}

