/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.uc.dao.HolidayDao;
import com.artfess.uc.manager.HolidayManager;
import com.artfess.uc.manager.HolidayTimeManager;
import com.artfess.uc.manager.ShiftRuleManager;
import com.artfess.uc.model.Holiday;
import com.artfess.uc.model.HolidayTime;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="holidayManager")
public class HolidayManagerImpl
extends BaseManagerImpl<HolidayDao, Holiday>
implements HolidayManager {
    @Resource
    HolidayTimeManager holidayTimeManager;
    @Resource
    ShiftRuleManager shiftRuleManager;

    public Holiday get(Serializable id) {
        Holiday holiday = (Holiday)super.get(id);
        List<HolidayTime> time = this.holidayTimeManager.getByHolidayId(id);
        holiday.setTime(time);
        return holiday;
    }

    public Holiday getById(Serializable id) {
        Holiday holiday = (Holiday)super.getById(id);
        List<HolidayTime> time = this.holidayTimeManager.getByHolidayId(id);
        holiday.setTime(time);
        return holiday;
    }

    @Transactional
    public void create(Holiday holiday) {
        String id = UniqueIdUtil.getSuid();
        holiday.setId(id);
        holiday.getTime().forEach(item -> {
            item.setHolidayId(id);
            this.holidayTimeManager.create((Model)item);
        });
        super.create((Model)holiday);
    }

    @Transactional
    public void update(Holiday holiday) {
        List<HolidayTime> times = this.holidayTimeManager.getByHolidayId((Serializable)((Object)holiday.getId()));
        Map<String, HolidayTime> existTimes = times.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        for (HolidayTime time : holiday.getTime()) {
            if (!existTimes.containsKey(time.getId())) {
                time.setHolidayId(holiday.getId());
                this.holidayTimeManager.create((Model)time);
                continue;
            }
            this.holidayTimeManager.update((Model)time);
            existTimes.remove(time.getId());
        }
        existTimes.forEach((key, value) -> this.holidayTimeManager.remove((Serializable)((Object)key)));
        super.update((Model)holiday);
    }

    @Override
    public String removeWithCheck(String ... ids) {
        ArrayList<String> failRemoveIds = new ArrayList<String>();
        for (String id : ids) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"holiday_id_", (Object)id);
            List rules = this.shiftRuleManager.list((Wrapper)queryWrapper);
            if (BeanUtils.isNotEmpty((Object)rules)) {
                failRemoveIds.add("[" + id + "]");
                continue;
            }
            this.remove((Serializable)((Object)id));
        }
        return String.join((CharSequence)"\u3001", failRemoveIds);
    }
}

