/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.calendar.ICalendarService;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.portal.params.CalendarVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/calendar/v1"})
@Api(tags={"\u5de5\u4f5c\u65e5\u5386\u8bbe\u7f6e"})
@ApiGroup(group={"group_system"})
public class CalendarController {
    @Resource
    ICalendarService iCalendarService;

    @RequestMapping(value={"getWorkTimeByUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6709\u6548\u5de5\u65f6", httpMethod="POST", notes="\u6839\u636e\u7528\u6237\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\uff0c\u83b7\u53d6\u8fd9\u6bb5\u65f6\u95f4\u7684\u6709\u6548\u5de5\u65f6")
    public String getWorkTimeByUser(@ApiParam(name="calendarVo", value="\u65e5\u5386\u64cd\u4f5c\u53c2\u6570") @RequestBody CalendarVo calendarVo) throws Exception {
        Long workTime = this.iCalendarService.getWorkTimeByUser(calendarVo.getUserId(), DateFormatUtil.parse((String)calendarVo.getStartTime()), DateFormatUtil.parse((String)calendarVo.getEndTime()));
        return String.valueOf(workTime);
    }

    @RequestMapping(value={"getEndTimeByUser"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6709\u6548\u5de5\u65f6", httpMethod="POST", notes="\u6839\u636e\u7528\u6237\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\uff0c\u83b7\u53d6\u8fd9\u6bb5\u65f6\u95f4\u7684\u6709\u6548\u5de5\u65f6")
    public String getEndTimeByUser(@ApiParam(name="calendarVo", value="\u65e5\u5386\u64cd\u4f5c\u53c2\u6570") @RequestBody CalendarVo calendarVo) throws Exception {
        String sTime = calendarVo.getStartTime();
        LocalDateTime endTime = StringUtil.isEmpty((String)sTime) ? this.iCalendarService.getEndTimeByUser(calendarVo.getUserId(), Long.valueOf(calendarVo.getTime()).longValue()) : this.iCalendarService.getEndTimeByUser(calendarVo.getUserId(), DateFormatUtil.parse((String)sTime), Long.valueOf(calendarVo.getTime()).longValue());
        return DateFormatUtil.formaDatetTime((LocalDateTime)endTime);
    }
}

