/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.constants.CategoryConstants;
import com.artfess.sysConfig.persistence.manager.BpmApprovalItemManager;
import com.artfess.sysConfig.persistence.model.BpmApprovalItem;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flow/approvalItem/v1/"})
@Api(tags={"\u5e38\u7528\u8bed\u7ba1\u7406"})
@ApiGroup(group={"group_system"})
public class ApprovalItemController
extends BaseController<BpmApprovalItemManager, BpmApprovalItem> {
    @Resource
    SystemConfigFeignService systemConfigFeignService;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5e38\u7528\u8bed\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u4ee3\u7406\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<BpmApprovalItem> listJson(@ApiParam(name="isPersonal", value="\u662f\u5426\u4e2a\u4eba\u5e38\u7528\u8bed", defaultValue="false") @RequestParam boolean isPersonal, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BpmApprovalItem> queryFilter) throws Exception {
        PageList bpmApprovalItemts = null;
        if (!isPersonal) {
            queryFilter.addFilter("TYPE_", (Object)4, QueryOP.NOT_EQUAL, FieldRelation.AND, "a");
            bpmApprovalItemts = ((BpmApprovalItemManager)this.baseService).query(queryFilter);
        } else {
            String currUserId = ContextUtil.getCurrentUserId();
            queryFilter.addFilter("TYPE_", (Object)4, QueryOP.EQUAL, FieldRelation.AND, "a");
            queryFilter.addFilter("USER_ID_", (Object)currUserId, QueryOP.EQUAL, FieldRelation.AND, "a");
            bpmApprovalItemts = ((BpmApprovalItemManager)this.baseService).query(queryFilter);
        }
        QueryFilter queryFilter2 = QueryFilter.build();
        queryFilter.withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter2.addFilter("type_group_key_", (Object)CategoryConstants.CAT_FLOW.key(), QueryOP.EQUAL);
        ObjectNode result = this.systemConfigFeignService.getAllSysType(queryFilter2);
        List sysTypeList = (List)JsonUtil.toBean((String)JsonUtil.toJson((Object)result.get("rows")), (TypeReference)new TypeReference<List<ObjectNode>>(){});
        for (BpmApprovalItem approvalItem : bpmApprovalItemts.getRows()) {
            if (approvalItem.getType() == BpmApprovalItem.TYPE_FLOWTYPE) {
                for (ObjectNode ISysType : sysTypeList) {
                    if (!approvalItem.getTypeId().equals(ISysType.get("id").asText())) continue;
                    approvalItem.setTypeId(ISysType.get("name").asText());
                }
                continue;
            }
            approvalItem.setDefKey("\u6240\u6709\u6d41\u7a0b");
        }
        return bpmApprovalItemts;
    }

    @RequestMapping(value={"approvalItemGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u5e38\u7528\u8bed\u7ba1\u7406\u4fe1\u606f\u9875\u9762", httpMethod="GET", notes="\u7f16\u8f91\u5e38\u7528\u8bed\u7ba1\u7406\u4fe1\u606f\u9875\u9762")
    public Object approvalItemGet(@ApiParam(name="id", value="\u5e38\u7528\u8bedid") @RequestParam String id) throws Exception {
        BpmApprovalItem bpmApprovalItem = null;
        if (StringUtil.isNotEmpty((String)id)) {
            bpmApprovalItem = (BpmApprovalItem)((BpmApprovalItemManager)this.baseService).get((Serializable)((Object)id));
        }
        return bpmApprovalItem;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5e38\u7528\u8bed\u7ba1\u7406\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u5e38\u7528\u8bed\u7ba1\u7406\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="bpmApprovalItem", value="\u5e38\u7528\u8bed\u5bf9\u8c61", required=true) @RequestBody BpmApprovalItem bpmApprovalItem) throws Exception {
        String resultMsg = null;
        try {
            String dealType = StringUtil.isNotEmpty((String)bpmApprovalItem.getId()) ? "\u7f16\u8f91" : "\u6dfb\u52a0";
            ((BpmApprovalItemManager)this.baseService).addTaskApproval(bpmApprovalItem);
            resultMsg = dealType + "\u5e38\u7528\u8bed\u6210\u529f";
            return new CommonResult(true, resultMsg, (Object)"");
        }
        catch (Exception e) {
            resultMsg = "\u5bf9\u5e38\u7528\u8bed\u64cd\u4f5c\u5931\u8d25";
            return new CommonResult(false, e.getMessage(), (Object)"");
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5e38\u7528\u8bed\u7ba1\u7406\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5e38\u7528\u8bed\u7ba1\u7406\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u5e38\u7528\u8bedid\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = ids.split(",");
            ((BpmApprovalItemManager)this.baseService).removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u5e38\u7528\u8bed\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5e38\u7528\u8bed\u5931\u8d25", (Object)"");
        }
    }

    @RequestMapping(value={"getApprovalByDefKeyAndTypeId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5e38\u7528\u8bed", httpMethod="GET", notes="\u83b7\u53d6\u5e38\u7528\u8bed")
    public List<String> getApprovalByDefKeyAndTypeId(@ApiParam(name="defKey", value="\u6d41\u7a0b\u5b9a\u4e49key", required=true) @RequestParam String defKey, @ApiParam(name="typeId", value="\u6d41\u7a0b\u5206\u7c7bid", required=true) @RequestParam Optional<String> typeId, @ApiParam(name="userId", value="\u5f53\u524d\u7528\u6237id") @RequestParam Optional<String> userId) throws Exception {
        return ((BpmApprovalItemManager)this.baseService).getApprovalByDefKeyAndTypeId(defKey, (String)typeId.orElse(null), (String)userId.orElse(null));
    }
}

