/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.el;

import com.artfess.base.exception.WorkFlowException;
import com.artfess.base.groovy.GroovyScriptEngine;
import com.artfess.base.model.HtJsonNodeFactory;
import com.artfess.base.model.HtObjectNode;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.cmd.ActionCmd;
import com.artfess.bpm.api.cmd.ProcessInstCmd;
import com.artfess.bpm.api.cmd.TaskFinishCmd;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.plugin.core.execution.sign.SignResult;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.exception.BusinessException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.Condition;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroovyCondition
implements Condition {
    protected static final Logger logger = LoggerFactory.getLogger(GroovyCondition.class);
    private static final long serialVersionUID = -5577703954744892854L;
    private String script = "";

    public GroovyCondition(String condition) {
        this.script = condition;
    }

    public boolean evaluate(DelegateExecution execution) {
        Map boMap;
        Map maps = execution.getVariables();
        maps.put("execution", execution);
        ActionCmd cmd = ContextThreadUtil.getActionCmd();
        if (cmd instanceof TaskFinishCmd) {
            TaskFinishCmd taskCmd = (TaskFinishCmd)cmd;
            SignResult signResult = (SignResult)cmd.getTransitVars("task_sign_result");
            if (BeanUtils.isEmpty((Object)signResult) || taskCmd.getActionName().equals(signResult.getNodeStatus().getKey())) {
                maps.put("taskCmd", taskCmd);
            } else {
                try {
                    DefaultTaskFinishCmd defaultTaskFinishCmd = (DefaultTaskFinishCmd)taskCmd;
                    DefaultTaskFinishCmd clone = defaultTaskFinishCmd.clone();
                    clone.setActionName(signResult.getNodeStatus().getKey());
                    maps.put("taskCmd", clone);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    maps.put("taskCmd", taskCmd);
                }
            }
        } else if (cmd instanceof ProcessInstCmd) {
            maps.put("taskCmd", cmd);
        }
        if (BeanUtils.isNotEmpty((Object)(boMap = BpmContextUtil.getBoFromContext()))) {
            HashMap newMap = new HashMap();
            for (Map.Entry next : boMap.entrySet()) {
                ObjectNode obj = (ObjectNode)next.getValue();
                if (obj.hasNonNull("data") && obj.get("data") instanceof ObjectNode) {
                    obj = (ObjectNode)obj.get("data");
                }
                HtObjectNode htObjectNode = HtJsonNodeFactory.build().htObjectNode(obj);
                newMap.put(next.getKey(), htObjectNode);
                maps.put(next.getKey(), htObjectNode);
            }
            maps.putAll(newMap);
        }
        maps.put("boMap", boMap);
        GroovyScriptEngine engine = (GroovyScriptEngine)AppUtil.getBean(GroovyScriptEngine.class);
        String newScript = this.replaceSpecialChar(this.script);
        try {
            return engine.executeBoolean(newScript, maps);
        }
        catch (BusinessException e) {
            throw new WorkFlowException(ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer("\u6761\u4ef6\u811a\u672c\u89e3\u6790\u5f02\u5e38\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002");
            message.append("<br/><br/>\u8282\u70b9\uff1a" + execution.getCurrentActivityName() + "\u2014\u2014" + execution.getCurrentActivityId());
            message.append("<br/><br/>\u811a\u672c\uff1a" + this.script);
            logger.error("WorkFlowException : ", (Throwable)e);
            logger.error("WorkFlowException \u6d41\u7a0b\u53d8\u91cf: " + maps.toString());
            throw new WorkFlowException(message.toString());
        }
    }

    private String replaceSpecialChar(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        if ((str = str.trim()).startsWith("${")) {
            return str.substring(2, str.length() - 1);
        }
        return str;
    }

    public boolean evaluate(String arg0, DelegateExecution arg1) {
        return this.evaluate(arg1);
    }
}

