'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var vue = require('vue');
var hooks = require('../hooks');

let id = 0;
var script = vue.defineComponent({
  name: "ImgEmpty",
  setup() {
    return {
      id: ++id
    };
  }
});

const _hoisted_1 = {
  viewBox: "0 0 79 86",
  version: "1.1",
  xmlns: "http://www.w3.org/2000/svg",
  "xmlns:xlink": "http://www.w3.org/1999/xlink"
};
const _hoisted_2 = /* @__PURE__ */ vue.createVNode("stop", {
  "stop-color": "#FCFCFD",
  offset: "0%"
}, null, -1);
const _hoisted_3 = /* @__PURE__ */ vue.createVNode("stop", {
  "stop-color": "#EEEFF3",
  offset: "100%"
}, null, -1);
const _hoisted_4 = /* @__PURE__ */ vue.createVNode("stop", {
  "stop-color": "#FCFCFD",
  offset: "0%"
}, null, -1);
const _hoisted_5 = /* @__PURE__ */ vue.createVNode("stop", {
  "stop-color": "#E9EBEF",
  offset: "100%"
}, null, -1);
const _hoisted_6 = {
  id: "Illustrations",
  stroke: "none",
  "stroke-width": "1",
  fill: "none",
  "fill-rule": "evenodd"
};
const _hoisted_7 = {
  id: "B-type",
  transform: "translate(-1268.000000, -535.000000)"
};
const _hoisted_8 = {
  id: "Group-2",
  transform: "translate(1268.000000, 535.000000)"
};
const _hoisted_9 = /* @__PURE__ */ vue.createVNode("path", {
  id: "Oval-Copy-2",
  d: "M39.5,86 C61.3152476,86 79,83.9106622 79,81.3333333 C79,78.7560045 57.3152476,78 35.5,78 C13.6847524,78 0,78.7560045 0,81.3333333 C0,83.9106622 17.6847524,86 39.5,86 Z",
  fill: "#F7F8FC"
}, null, -1);
const _hoisted_10 = /* @__PURE__ */ vue.createVNode("polygon", {
  id: "Rectangle-Copy-14",
  fill: "#E5E7E9",
  transform: "translate(27.500000, 51.500000) scale(1, -1) translate(-27.500000, -51.500000) ",
  points: "13 58 53 58 42 45 2 45"
}, null, -1);
const _hoisted_11 = {
  id: "Group-Copy",
  transform: "translate(34.500000, 31.500000) scale(-1, 1) rotate(-25.000000) translate(-34.500000, -31.500000) translate(7.000000, 10.000000)"
};
const _hoisted_12 = /* @__PURE__ */ vue.createVNode("polygon", {
  id: "Rectangle-Copy-10",
  fill: "#E5E7E9",
  transform: "translate(11.500000, 5.000000) scale(1, -1) translate(-11.500000, -5.000000) ",
  points: "2.84078316e-14 3 18 3 23 7 5 7"
}, null, -1);
const _hoisted_13 = /* @__PURE__ */ vue.createVNode("polygon", {
  id: "Rectangle-Copy-11",
  fill: "#EDEEF2",
  points: "-3.69149156e-15 7 38 7 38 43 -3.69149156e-15 43"
}, null, -1);
const _hoisted_14 = /* @__PURE__ */ vue.createVNode("polygon", {
  id: "Rectangle-Copy-13",
  fill: "#F8F9FB",
  transform: "translate(39.500000, 3.500000) scale(-1, 1) translate(-39.500000, -3.500000) ",
  points: "24 7 41 7 55 -3.63806207e-12 38 -3.63806207e-12"
}, null, -1);
const _hoisted_15 = {
  id: "Rectangle-Copy-17",
  transform: "translate(53.000000, 45.000000)"
};
const _hoisted_16 = /* @__PURE__ */ vue.createVNode("polygon", {
  id: "Rectangle-Copy-18",
  fill: "#F8F9FB",
  transform: "translate(66.000000, 51.500000) scale(-1, 1) translate(-66.000000, -51.500000) ",
  points: "62 45 79 45 70 58 53 58"
}, null, -1);
function render(_ctx, _cache, $props, $setup, $data, $options) {
  return vue.openBlock(), vue.createBlock("svg", _hoisted_1, [
    vue.createVNode("defs", null, [
      vue.createVNode("linearGradient", {
        id: `linearGradient-1-${_ctx.id}`,
        x1: "38.8503086%",
        y1: "0%",
        x2: "61.1496914%",
        y2: "100%"
      }, [
        _hoisted_2,
        _hoisted_3
      ], 8, ["id"]),
      vue.createVNode("linearGradient", {
        id: `linearGradient-2-${_ctx.id}`,
        x1: "0%",
        y1: "9.5%",
        x2: "100%",
        y2: "90.5%"
      }, [
        _hoisted_4,
        _hoisted_5
      ], 8, ["id"]),
      vue.createVNode("rect", {
        id: `path-3-${_ctx.id}`,
        x: "0",
        y: "0",
        width: "17",
        height: "36"
      }, null, 8, ["id"])
    ]),
    vue.createVNode("g", _hoisted_6, [
      vue.createVNode("g", _hoisted_7, [
        vue.createVNode("g", _hoisted_8, [
          _hoisted_9,
          _hoisted_10,
          vue.createVNode("g", _hoisted_11, [
            _hoisted_12,
            _hoisted_13,
            vue.createVNode("rect", {
              id: "Rectangle-Copy-12",
              fill: `url(#linearGradient-1-${_ctx.id})`,
              transform: "translate(46.500000, 25.000000) scale(-1, 1) translate(-46.500000, -25.000000) ",
              x: "38",
              y: "7",
              width: "17",
              height: "36"
            }, null, 8, ["fill"]),
            _hoisted_14
          ]),
          vue.createVNode("rect", {
            id: "Rectangle-Copy-15",
            fill: `url(#linearGradient-2-${_ctx.id})`,
            x: "13",
            y: "45",
            width: "40",
            height: "36"
          }, null, 8, ["fill"]),
          vue.createVNode("g", _hoisted_15, [
            vue.createVNode("mask", {
              id: `mask-4-${_ctx.id}`,
              fill: "white"
            }, [
              vue.createVNode("use", {
                "xlink:href": `#path-3-${_ctx.id}`
              }, null, 8, ["xlink:href"])
            ], 8, ["id"]),
            vue.createVNode("use", {
              id: "Mask",
              fill: "#E0E3E9",
              transform: "translate(8.500000, 18.000000) scale(-1, 1) translate(-8.500000, -18.000000) ",
              "xlink:href": `#path-3-${_ctx.id}`
            }, null, 8, ["xlink:href"]),
            vue.createVNode("polygon", {
              id: "Rectangle-Copy",
              fill: "#D5D7DE",
              mask: `url(#mask-4-${_ctx.id})`,
              transform: "translate(12.000000, 9.000000) scale(-1, 1) translate(-12.000000, -9.000000) ",
              points: "7 0 24 0 20 18 -1.70530257e-13 16"
            }, null, 8, ["mask"])
          ]),
          _hoisted_16
        ])
      ])
    ])
  ]);
}

script.render = render;
script.__file = "packages/empty/src/img-empty.vue";

var script$1 = vue.defineComponent({
  name: "ElEmpty",
  components: {
    [script.name]: script
  },
  props: {
    image: {
      type: String,
      default: ""
    },
    imageSize: Number,
    description: {
      type: String,
      default: ""
    }
  },
  setup(props) {
    const { t } = hooks.useLocaleInject();
    const emptyDescription = vue.computed(() => props.description || t("el.table.emptyText"));
    const imageStyle = vue.computed(() => {
      return {
        width: props.imageSize ? `${props.imageSize}px` : ""
      };
    });
    return {
      emptyDescription,
      imageStyle
    };
  }
});

const _hoisted_1$1 = { class: "el-empty" };
const _hoisted_2$1 = { class: "el-empty__description" };
const _hoisted_3$1 = { key: 1 };
const _hoisted_4$1 = {
  key: 0,
  class: "el-empty__bottom"
};
function render$1(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_img_empty = vue.resolveComponent("img-empty");
  return vue.openBlock(), vue.createBlock("div", _hoisted_1$1, [
    vue.createVNode("div", {
      class: "el-empty__image",
      style: _ctx.imageStyle
    }, [
      _ctx.image ? (vue.openBlock(), vue.createBlock("img", {
        key: 0,
        src: _ctx.image,
        ondragstart: "return false"
      }, null, 8, ["src"])) : vue.renderSlot(_ctx.$slots, "image", { key: 1 }, () => [
        vue.createVNode(_component_img_empty)
      ])
    ], 4),
    vue.createVNode("div", _hoisted_2$1, [
      _ctx.$slots.description ? vue.renderSlot(_ctx.$slots, "description", { key: 0 }) : (vue.openBlock(), vue.createBlock("p", _hoisted_3$1, vue.toDisplayString(_ctx.emptyDescription), 1))
    ]),
    _ctx.$slots.default ? (vue.openBlock(), vue.createBlock("div", _hoisted_4$1, [
      vue.renderSlot(_ctx.$slots, "default")
    ])) : vue.createCommentVNode("v-if", true)
  ]);
}

script$1.render = render$1;
script$1.__file = "packages/empty/src/index.vue";

script$1.install = (app) => {
  app.component(script$1.name, script$1);
};
const _Empty = script$1;

exports.default = _Empty;
