package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 *  水库水源地
 */
@Getter
public enum WaterSourceEnum {
    /**
     * 删除
     */
    ONE("0", "非水源"),

    TWO("1", "饮用水源"),

    THREE("2", "备用水源"),


    ;

    WaterSourceEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;


    public static String getDesc(String level){
        if(StringUtils.isEmpty(level)){
            return null;
        }
        WaterSourceEnum[] values = values();
        for (WaterSourceEnum state : values) {
            if (state.getType().equals(level)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
