package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 科目类型
 */
@Getter
public enum SubjectTypeEnum {
    ZC("BS1","资产类"),

    SYZQY("BS2", "所有者权益类"),

    FZ("BS3", "负债类"),

    THREE("PL1", "收入类"),

    CBFY("PL2", "成本费用类"),

    LRJG("PL3", "利润结果类"),

    XJL("CF1", "现金流类"),

    HGSJ("OP1", "宏观数据类"),

    CXGJ("OP2", "持续改进类"),

    ZL("IN1", "专利类"),

    RYSL("HR1", "人员数量类"),

    ;

    SubjectTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        SubjectTypeEnum[] values = values();
        for (SubjectTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
