package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 *工程等别
 */
@Getter
public enum EngGradTypeEnum {
    ONE("1", "Ⅰ"),

    TWO("2", "Ⅱ"),

    THREE("3", "Ⅲ"),

    FOUR("4", "Ⅳ"),

    FIVE("5","Ⅴ"),
    ;

    EngGradTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        EngGradTypeEnum[] values = values();
        for (EngGradTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
