package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 堤防级别
 */
@Getter
public enum DikeGradEnum {
    ZERO("0","未知"),

    ONE("1", "1级"),

    TWO("2", "2级"),

    THREE("3", "3级"),

    FOUR("4", "4级"),

    FIVE("5", "5级"),

    SIX("6", "5级以下"),

    ;

    DikeGradEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        DikeGradEnum[] values = values();
        for (DikeGradEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
