package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 删除枚举
 */
@Getter
public enum BasGardEnum {
    /**
     * 删除
     */
    one("1", "一级流域 "),

    two("2", "二级流域 "),

    three("3", "三级流域 "),

    four("4", "四级流域 "),

    five("5", "五级流域 "),

    six("6", "六级流域 "),

    seven("7", "七级流域 "),

    ;

    BasGardEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        BasGardEnum[] values = values();
        for (BasGardEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
