import req from '@/request.js'
const portal = window.context.portal
export default {
  // 从服务器查询当前时间
  getNowDate(cb) {
    req
      .get(portal + `/portal/calendar/v1/getLocalDateTime`)
      .then(res => {
        cb(res.data)
      })
  },
  // 判断更新数据时间是否已过时间节点
  setFillingTime(data, cb) {
    let { projectId, fillDate, flowType, nowDate } = data
    req
      .post(portal + `/majorProjects/bizPilotProjectFill/v1/fillPermission?projectId=${projectId}&fillDate=${fillDate}&flowType=${flowType}&nowDate=${nowDate}`)
      .then(res => {
        cb(res.data)
      })
  },

  // 根据后端获取时间
  getFillDate(cb) {
    req
      .get(portal + `/portal/calendar/v1/getFillDate`)
      .then(res => {
        cb(res.data)
      })
  },
}
