import req from '@/request.js'
const portal = window.context.portal
export default {
    // 添加
    addData(data, cb) {
        req.post(portal + `/qf/hr/person/`, data).then(res => {
            cb(res.data)
        })
    },
    //修改
    editData(data, cb) {
        req.put(portal + `/qf/hr/person/`, data).then(res => {
            cb(res.data)
        })
    },
    //删除
    delDate(ids, cb) {
        req.remove(portal + `/qf/hr/person/?ids=` + ids).then(res => {
            cb(res.data)
        })
    },
    //查询
    pageQuery(data, cb) {
        req.post(portal + `/qf/hr/person/query`, data).then(res => {
            cb(res.data)
        })
    },

    // id查询
    detailId(id, cb) {
        req.get(portal + `/qf/hr/person/` + id).then(rep => {
            cb(rep.data)
        })
    },
    //修改状态
    editStatus(data, cb) {
        req.put(portal + `/qf/hr/person/updateStatus`, data).then(res => {
            cb(res.data)
        })
    },
    //导入
    importExcel(data, cb) {
        req.post(portal + `/qf/hr/person/importExcel`, data).then(res => {
            cb(res.data)
        })
    },
    //导出
    export(data, cb) {
        req.post(portal + `/qf/hr/person/export`, data, 'blob').then(res => {
            cb(res.data)
        })
    },
    /*二级页面*/
    //批量添加
    batchSaveData(data, cb) {
        req.post(portal + `/qf/hr/person/detail/batchSave`, data).then(res => {
            cb(res.data)
        })
    },
    batchUpdateData(data, cb) {
        req.put(portal + `/qf/hr/person/detail/batchUpdate`, data).then(res => {
            cb(res.data)
        })
    },
    //表格查询
    detailQuery(data, cb) {
        req.post(portal + `/qf/hr/person/detail/query`, data).then(res => {
            cb(res.data)
        })
    },
    //表头表格查询
    headerDetailQuery(data, cb) {
        req.post(portal + `/qf/hr/person/detail/detailQuery`, data).then(res => {
            cb(res.data)
        })
    },
    //批量删除
    dleDetail(ids, cb) {
        req.remove(portal + `/qf/hr/person/detail/?ids=` + ids).then(res => {
            cb(res.data)
        })
    },

}
