import req from '@/request.js'
const portal = window.context.portal
const headers = {
    'Content-type': 'application/x-www-form-urlencoded'
}
export default {
    // 月度计划清单
    getMonthList(data, cb) {
        req.post(portal + `/project/largeScreen/v1/schedulePlanInfo?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 成果榜
    getResultTrend(data, cb) {
        let { year, month, projectId } = data
        req.post(portal + `/project/largeScreen/v1/achievementCount?year=${year}&month=${month}&projectId=${projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 推动数字重庆建设
    // 主要举措
    getBattleChart(data, cb) {
        let { year, month, projectId } = data
        req.post(portal + `/project/largeScreen/v1/monthPlanNum?year=${year}&month=${month}&projectId=${projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 量化目标
    getIndexLibrary(data, cb) {
        req.post(portal + `/project/largeScreen/v1/complianceRateCount?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 迭代榜
    getIteration(data, cb) {
        req.post(portal + `/project/largeScreen/v1/queryIterationForProjectInfo?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 经验复制推广
    experienceReplication(data, cb) {
        req.post(portal + `/project/largeScreen/v1/pilotExperiencePushInfo?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 品牌榜
    getProjectBrand(data, cb) {
        req.post(portal + `/project/largeScreen/v1/queryBrandForProject?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 品牌榜 月统计
    getBrandMonthDate(data, cb) {
        req.post(portal + `/project/largeScreen/v1/brandLineChart?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 品牌详情
    getBrandXQ(data,cb) {
        req.post(portal + `/majorProjects/bizPilotBrandPush/v1/findById?id=${data.id}&year=${data.year}&month=${data.month}`).then(res => {
            cb(res.data)
        })
    },
    // 量化目标
    quantifiedGoal(data, cb) {
        req.post(portal + `/project/largeScreen/v1/indexYearPlanDetailsData?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 指标库达标率
    complianceRateCount(data, cb) {
        req.post(portal + `/project/largeScreen/v1/reachRateCount?year=${data.year}&month=${data.month}&projectId=${data.projectId}`).then(res => {
            cb(res.data)
        })
    },
    // 分驾驶舱获取成果榜
    getResultList(data, cb) {
        req.post(portal + `/project/largeScreen/v1/achievementInfo`, data).then(res => {
            cb(res.data)
        })
    },
    // 核心指标趋势图数据查询
    getTrendChartData(data, cb) {
        req.post(portal + `/project/largeScreen/v1/indexCoreDetailsLineChart?year=${data.year}&month=${data.month}&projectId=${data.projectId}`, data).then(res => {
            cb(res.data)
        })
    },
    // 趋势图两率查询
    getTwoRate(data, cb) {
        req.post(portal + `/project/largeScreen/v1/indexCoreRate?year=${data.year}&month=${data.month}&projectId=${data.projectId}`, data).then(res => {
            cb(res.data)
        })
    },
}