import req from '@/request.js'
const portal = window.context.portal
export default {
  // 查询列表数据
  getTableData(data, isAffirm, cb) {
    return req.post(portal + `/majorProjects/bizPilotProjectFill/v1/queryPageFillList?flowType=4&isAffirm=${isAffirm}`, data).then(res => {
      cb(res.data)
    })
  },
  // 品牌显示度推进更新
  addBrandUpdate(data, cb) {
    return req.post(portal + `/majorProjects/bizPilotBrandPush/v1/save`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据项目id查询品牌推荐信息
  getBrandInfoById(id, cb) {
    return req.post(portal + `/majorProjects/bizPilotBrandPush/v1/findByHis?id=${id}`).then(res => {
      cb(res.data)
    })
  },
  // 修改品牌信息
  updateById(data, cb) {
    return req.post(portal + `/majorProjects/bizPilotBrandPush/v1/update`, data).then(res => {
      cb(res.data)
    })
  },
  // 根据id修改状态

  updateStatusById(data, cb) {
    return req.post(portal + `/majorProjects/bizPilotBrandPush/v1/updateByStatus`, data).then(res => {
      cb(res.data)
    })
  },
  // 历史数据查询
  getHistoryData(data, cb) {
    return req.post(portal + `/majorProjects/bizPilotBrandPush/v1/queryHisByPage`, data).then(res => {
      cb(res.data)
    })
  },
  // 附件查询
  getFilesById(data, cb) {
    req.post(portal + `/file/v1/query`, data).then(res => {
      cb(res.data)
    })
  },
  // 历史数据修改
  updateHistoryData(data, cb) {
    req.put(portal + `/majorProjects/bizPilotBrandPush/v1/`, data).then(res => {
      cb(res.data)
    })
  }
}