/**
 * 获取设备热点信息
 *
 * \ **API目录**：设备
 *
 * @apiName 获取设备热点信息
 *
 * @returns
 * ssid string 热点ssid;
 * macIp string 热点mac地址
 *
 * @support
 *  - IOS v1.3.5
 *  - Android v1.3.5
 *
 * @example
 * ```typescript
 *  getHotspotInfo()
 *   .then(res => {
 *     console.log(res);
 *   })
 *   .catch(err => {
 *     console.log(err);
 *   });
 * ```
 */
declare function getHotspotInfo(): Promise<{
    ssid: string;
    macIp: string;
}>;
declare namespace getHotspotInfo {
    var version: {
        android: string;
        ios: string;
    };
}
export default getHotspotInfo;
