"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.registerTickMethod = exports.getTickMethod = exports.registerScale = exports.getScale = exports.Scale = exports.Quantize = exports.Quantile = exports.TimeCat = exports.Time = exports.Pow = exports.Log = exports.Linear = exports.Identity = exports.Category = void 0;
var base_1 = require("./base");
exports.Scale = base_1.default;
var base_2 = require("./category/base");
exports.Category = base_2.default;
var time_1 = require("./category/time");
exports.TimeCat = time_1.default;
var linear_1 = require("./continuous/linear");
exports.Linear = linear_1.default;
var log_1 = require("./continuous/log");
exports.Log = log_1.default;
var pow_1 = require("./continuous/pow");
exports.Pow = pow_1.default;
var time_2 = require("./continuous/time");
exports.Time = time_2.default;
var quantize_1 = require("./continuous/quantize");
exports.Quantize = quantize_1.default;
var quantile_1 = require("./continuous/quantile");
exports.Quantile = quantile_1.default;
var factory_1 = require("./factory");
Object.defineProperty(exports, "getScale", { enumerable: true, get: function () { return factory_1.getScale; } });
Object.defineProperty(exports, "registerScale", { enumerable: true, get: function () { return factory_1.registerScale; } });
var index_1 = require("./identity/index");
exports.Identity = index_1.default;
var index_2 = require("./tick-method/index");
Object.defineProperty(exports, "getTickMethod", { enumerable: true, get: function () { return index_2.getTickMethod; } });
Object.defineProperty(exports, "registerTickMethod", { enumerable: true, get: function () { return index_2.registerTickMethod; } });
factory_1.registerScale('cat', base_2.default);
factory_1.registerScale('category', base_2.default);
factory_1.registerScale('identity', index_1.default);
factory_1.registerScale('linear', linear_1.default);
factory_1.registerScale('log', log_1.default);
factory_1.registerScale('pow', pow_1.default);
factory_1.registerScale('time', time_2.default);
factory_1.registerScale('timeCat', time_1.default);
factory_1.registerScale('quantize', quantize_1.default);
factory_1.registerScale('quantile', quantile_1.default);
//# sourceMappingURL=index.js.map