"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var base_1 = tslib_1.__importDefault(require("./base"));
require("./shape/edge");
/**
 * Edge 几何标记，用于绘制关系图中的**边**图形，如：
 * 1. 流程图
 * 2. 树
 * 3. 弧长连接图
 * 4. 和弦图
 * 5. 桑基图
 */
var Edge = /** @class */ (function (_super) {
    tslib_1.__extends(Edge, _super);
    function Edge() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.type = 'edge';
        _this.shapeType = 'edge';
        _this.generatePoints = true;
        return _this;
    }
    return Edge;
}(base_1.default));
exports.default = Edge;
//# sourceMappingURL=edge.js.map