"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.growInXY = exports.growInY = exports.growInX = void 0;
var util_1 = require("./util");
/**
 * @ignore
 * 入场动画
 * x 方向的生长
 * @param element 执行动画的元素
 * @param animateCfg 动画配置
 * @param cfg 额外信息
 */
function growInX(element, animateCfg, cfg) {
    var coordinate = cfg.coordinate, minYPoint = cfg.minYPoint;
    (0, util_1.doScaleAnimate)(element, animateCfg, coordinate, minYPoint, 'x');
}
exports.growInX = growInX;
/**
 * @ignore
 * 入场动画
 * y 轴方向上的生长
 * @param element 执行动画的元素
 * @param animateCfg 动画配置
 * @param cfg 额外信息
 */
function growInY(element, animateCfg, cfg) {
    var coordinate = cfg.coordinate, minYPoint = cfg.minYPoint;
    (0, util_1.doScaleAnimate)(element, animateCfg, coordinate, minYPoint, 'y');
}
exports.growInY = growInY;
/**
 * @ignore
 * 入场
 * 中心点的向四周的生长动画
 * @param element 执行动画的元素
 * @param animateCfg 动画配置
 * @param cfg 额外信息
 */
function growInXY(element, animateCfg, cfg) {
    var coordinate = cfg.coordinate, minYPoint = cfg.minYPoint;
    (0, util_1.doScaleAnimate)(element, animateCfg, coordinate, minYPoint, 'xy');
}
exports.growInXY = growInXY;
//# sourceMappingURL=grow-in.js.map