import { Point } from './types';
/**
 * 使用牛顿切割法求最近的点
 * @param {number[]} xArr      点的 x 数组
 * @param {number[]} yArr      点的 y 数组
 * @param {number}   x         指定的点 x
 * @param {number}   y         指定的点 y
 * @param {Function} tCallback 差值函数
 */
export declare function nearestPoint(xArr: number[], yArr: number[], x: number, y: number, tCallback: (...arr: number[]) => number, length?: number): Point;
export declare function snapLength(xArr: number[], yArr: number[]): number;
