package com.artfess.security.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.security.manager.BackupDatasourceManager;
import com.artfess.security.manager.BackupLogManager;
import com.artfess.security.model.BackupDatasource;
import com.artfess.security.model.BackupLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * 数据库备份管理 前端控制器
 *
 * @company wh
 * @author wh
 * @since 2021-04-22
 */
@Api(tags="数据库备份管理")
@RestController
@ApiGroup(group= {ApiGroupConsts.GROUP_UC})
@RequestMapping("/uc/backupDatasource/v1/")
public class BackupDatasourceController extends BaseController<BackupDatasourceManager, BackupDatasource> {
    @Autowired
    private BackupDatasourceManager backupService;

    @Autowired
    private BackupLogManager logService;

    @PostMapping(value = "/insertBackupDatasource")
    @ApiOperation("新增数据保备份配置")
    //@RequiresPermissions("BackupDatasource:add")
    public CommonResult<String> insertBackupDatasource(@RequestBody BackupDatasource configEntity) {
        try {
            backupService.save(configEntity);
            return new CommonResult<String>(true,"新增数据保备份配置成功",null);
        } catch (Exception e) {
            return new CommonResult<String>(false,"新增数据保备份配置失败",e.getMessage());
        }
    }

    @PostMapping(value = "/updateBackupDatasource")
    @ApiOperation("修改数据保备份配置")
    public CommonResult<String> updateBackupDatasource(@RequestBody BackupDatasource configEntity) {
        try {
            backupService.saveOrUpdate(configEntity);
            return new CommonResult<String>(true,"修改数据保备份配置成功",null);
        } catch (Exception e) {
            return new CommonResult<String>(false,"修改数据保备份配置失败",e.getMessage());
        }
    }

    @PostMapping(value = "/deleteBackupDatasource")
    @ApiOperation("批量删除数据保备份配置")
    @ApiImplicitParam(name = "ids", value = "数据保备份配置ID，批量删除用逗号隔开", required = true)
    public CommonResult<String> deleteBackupDatasource(@RequestParam String ids) {
        try {
            if(StringUtils.isNotBlank(ids)){
                List<String> idList= Arrays.asList(ids.split(","));
                this.backupService.removeByIds(idList);

            }else{
                return new CommonResult<String>(false,"ids不能为空",null);
            }
            return new CommonResult<String>(true,"批量删除数据保备份配置成功",null);
        } catch (Exception e) {
            return new CommonResult<String>(false,"批量删除数据保备份配置失败",e.getMessage());
        }
    }


    @PostMapping(value = "/slicedQueryBackupDatasources")
    @ApiOperation("分页查询数据保备份配置列表")
    public PageList<BackupDatasource> list(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BackupDatasource> queryFilter) {
        //QueryFilter<BackupDatasource> queryFilter=QueryFilter.build();
        //String userName= AuthenticationUtil.getCurrentUsername();
        //queryFilter.withQuery(new QueryField("user_name", userName, QueryOP.EQUAL, FieldRelation.AND));
        return backupService.query(queryFilter);
    }

    @PostMapping(value = "/slicedQueryBackupLog")
    @ApiOperation("分页查询数据保备份配置日志列表")
    public PageList<BackupLog> logList(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BackupLog> queryFilter) {

        //QueryFilter<BackupLog> queryFilter=QueryFilter.build();
        //String userName= AuthenticationUtil.getCurrentUsername();
        //queryFilter.withQuery(new QueryField("user_name", userName, QueryOP.EQUAL, FieldRelation.AND));
        return logService.query(queryFilter);

    }

    @PostMapping(value = "/loadBackupDatasource")
    @ApiOperation("根据ID查询数据保备份配置")
    //@RequiresPermissions("BackupDatasource:load")
    public BackupDatasource loadBackupDatasource(String id) {
        BackupDatasource BackupDatasource=this.backupService.getById(id);
        return BackupDatasource;
    }

    //测试数据库连接
    @PostMapping(value = "/testDb")
    @ApiOperation("测试数据库连接")
    //@RequiresPermissions("BackupDatasource:load")
    public CommonResult<String> testDb(String id) {
        try {
            String result=this.backupService.testDB(id);
            return new CommonResult<String>(true,"测试数据库连接成功",result);
        } catch (Exception e) {
            return new CommonResult<String>(false,"测试数据库连接失败",e.getMessage());
        }
    }

    //测试服务器连接
    @PostMapping(value = "/testSystem")
    @ApiOperation("测试服务器连接")
    //@RequiresPermissions("BackupDatasource:load")
    public CommonResult<String> testSystem(String id) {
        try {
            String result=this.backupService.testSystem(id);
            return new CommonResult<String>(true,"测试服务器连接成功",result);
        } catch (Exception e) {
            return new CommonResult<String>(false,"测试服务器连接失败",e.getMessage());
        }
    }

    //手动备份
    @PostMapping(value = "/backUpDataBase")
    @ApiOperation("手动备份")
    //@RequiresPermissions("BackupDatasource:load")
    public CommonResult<String> backUpDataBase(String id) {
        try {
            this.backupService.backUpDataBase(id);
            return new CommonResult<String>(true,"手动备份成功","");
        } catch (Exception e) {
            return new CommonResult<String>(false,"手动备份失败","");
        }
    }

    @PostMapping(value = "/reduction")
    @ApiOperation("手动还原")
    //@RequiresPermissions("BackupDatasource:load")
    public CommonResult<String> Reduction(String id) {
        try {
            this.backupService.Reduction(id);
            return new CommonResult<String>(true,"手动还原成功","");
        } catch (Exception e) {
            return new CommonResult<String>(false,"手动还原失败","");
        }
    }
}
